/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.opensearch.sql.DataSourceSchemaName;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.resolver.QueryExemplarsTableFunctionResolver;
import org.opensearch.sql.prometheus.functions.resolver.QueryRangeTableFunctionResolver;
import org.opensearch.sql.prometheus.storage.PrometheusMetricTable;
import org.opensearch.sql.prometheus.storage.system.PrometheusSystemTable;
import org.opensearch.sql.storage.StorageEngine;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.utils.SystemIndexUtils;

public class PrometheusStorageEngine
implements StorageEngine {
    private final PrometheusClient prometheusClient;

    @Override
    public Collection<FunctionResolver> getFunctions() {
        ArrayList<FunctionResolver> functionList = new ArrayList<FunctionResolver>();
        functionList.add(new QueryRangeTableFunctionResolver(this.prometheusClient));
        functionList.add(new QueryExemplarsTableFunctionResolver(this.prometheusClient));
        return functionList;
    }

    @Override
    public Table getTable(DataSourceSchemaName dataSourceSchemaName, String tableName) {
        if (SystemIndexUtils.isSystemIndex(tableName).booleanValue()) {
            return new PrometheusSystemTable(this.prometheusClient, dataSourceSchemaName, tableName);
        }
        if ("information_schema".equals(dataSourceSchemaName.getSchemaName())) {
            return this.resolveInformationSchemaTable(dataSourceSchemaName, tableName);
        }
        return new PrometheusMetricTable(this.prometheusClient, tableName);
    }

    private Table resolveInformationSchemaTable(DataSourceSchemaName dataSourceSchemaName, String tableName) {
        if ("tables".equals(tableName)) {
            return new PrometheusSystemTable(this.prometheusClient, dataSourceSchemaName, "ALL.META_ODFE_SYS_TABLE");
        }
        throw new SemanticCheckException(String.format("Information Schema doesn't contain %s table", tableName));
    }

    @Generated
    public PrometheusStorageEngine(PrometheusClient prometheusClient) {
        this.prometheusClient = prometheusClient;
    }
}

