/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.parser.ScriptFilter;
import org.opensearch.sql.legacy.parser.SqlParser;
import org.opensearch.sql.legacy.parser.WhereParser;
import org.opensearch.sql.legacy.utils.Util;
import shaded.com.google.common.base.Joiner;

public class CaseWhenParser {
    private final SQLCaseExpr caseExpr;
    private final String alias;
    private final String tableAlias;

    public CaseWhenParser(SQLCaseExpr caseExpr, String alias, String tableAlias) {
        this.alias = alias;
        this.tableAlias = tableAlias;
        this.caseExpr = caseExpr;
    }

    public String parse() throws SqlParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.caseExpr.getValueExpr() != null) {
            for (SQLCaseExpr.Item item : this.caseExpr.getItems()) {
                SQLExpr left = this.caseExpr.getValueExpr();
                SQLExpr right = item.getConditionExpr();
                SQLBinaryOpExpr conditionExpr = new SQLBinaryOpExpr(left, SQLBinaryOperator.Equality, right);
                item.setConditionExpr((SQLExpr)conditionExpr);
            }
            this.caseExpr.setValueExpr(null);
        }
        for (SQLCaseExpr.Item item : this.caseExpr.getItems()) {
            SQLExpr conditionExpr = item.getConditionExpr();
            WhereParser parser = new WhereParser(new SqlParser(), conditionExpr);
            String scriptCode = this.explain(parser.findWhere());
            if (scriptCode.startsWith(" &&")) {
                scriptCode = scriptCode.substring(3);
            }
            if (result.size() == 0) {
                result.add("if(" + scriptCode + "){" + String.valueOf(Util.getScriptValueWithQuote(item.getValueExpr(), "'")) + "}");
                continue;
            }
            result.add("else if(" + scriptCode + "){" + String.valueOf(Util.getScriptValueWithQuote(item.getValueExpr(), "'")) + "}");
        }
        SQLExpr elseExpr = this.caseExpr.getElseExpr();
        if (elseExpr == null) {
            result.add("else { null }");
        } else {
            result.add("else {" + String.valueOf(Util.getScriptValueWithQuote(elseExpr, "'")) + "}");
        }
        return Joiner.on((String)" ").join(result);
    }

    public String explain(Where where) throws SqlParseException {
        ArrayList<String> codes = new ArrayList<String>();
        while (where.getWheres().size() == 1) {
            where = where.getWheres().getFirst();
        }
        this.explainWhere(codes, where);
        String relation = where.getConn().name().equals("AND") ? " && " : " || ";
        return Joiner.on((String)relation).join(codes);
    }

    private void explainWhere(List<String> codes, Where where) throws SqlParseException {
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            if (condition.getValue() instanceof ScriptFilter) {
                codes.add("(" + ((ScriptFilter)condition.getValue()).getScript() + ")");
            } else if (condition.getOPERATOR() == Condition.OPERATOR.BETWEEN) {
                Object[] objs = (Object[])condition.getValue();
                codes.add("(doc['" + condition.getName() + "'].value >= " + String.valueOf(objs[0]) + " && doc['" + condition.getName() + "'].value <=" + String.valueOf(objs[1]) + ")");
            } else {
                SQLExpr nameExpr = condition.getNameExpr();
                SQLExpr valueExpr = condition.getValueExpr();
                if (valueExpr instanceof SQLNullExpr) {
                    codes.add("(doc['" + nameExpr.toString() + "'].empty)");
                } else {
                    codes.add("(" + String.valueOf(Util.getScriptValueWithQuote(nameExpr, "'")) + condition.getOpertatorSymbol() + String.valueOf(Util.getScriptValueWithQuote(valueExpr, "'")) + ")");
                }
            }
        } else {
            for (Where subWhere : where.getWheres()) {
                ArrayList<String> subCodes = new ArrayList<String>();
                this.explainWhere(subCodes, subWhere);
                String relation = subWhere.getConn().name().equals("AND") ? "&&" : "||";
                codes.add(Joiner.on((String)relation).join(subCodes));
            }
        }
    }
}

