/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.jsonUDF;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.runtime.JsonFunctions;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.function.jsonUDF.JsonUtils;

public class JsonExtendFunctionImpl
extends ImplementorUDF {
    public JsonExtendFunctionImpl() {
        super(new JsonExtendImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.STRING_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return null;
    }

    public static Object eval(Object ... args) throws JsonProcessingException {
        String jsonStr = (String)args[0];
        List<Object> keys = Arrays.asList(args).subList(1, args.length);
        if (keys.size() % 2 != 0) {
            throw new RuntimeException("Json append function needs corresponding path and values, but current get: " + String.valueOf(keys));
        }
        JsonNode root = JsonUtils.convertInputToJsonNode(args[0]);
        ArrayList<Object> expands = new ArrayList<Object>();
        for (int i = 0; i < keys.size(); i += 2) {
            List<String> expandedPaths = JsonUtils.expandJsonPath(root, JsonUtils.convertToJsonPath(keys.get(i).toString()));
            for (String expandedPath : expandedPaths) {
                Object value = keys.get(i + 1);
                if (value instanceof List) {
                    List targetValues = (List)value;
                    for (Object targetValue : targetValues) {
                        expands.add(expandedPath + ".meaninglessKey");
                        expands.add(targetValue);
                    }
                    continue;
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    try {
                        List targetValues = (List)JsonUtils.gson.fromJson(stringValue, List.class);
                        for (Object targetValue : targetValues) {
                            expands.add(expandedPath + JsonUtils.MEANING_LESS_KEY_FOR_APPEND_AND_EXTEND);
                            expands.add(targetValue);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        expands.add(expandedPath + JsonUtils.MEANING_LESS_KEY_FOR_APPEND_AND_EXTEND);
                        expands.add(value);
                        continue;
                    }
                }
                expands.add(expandedPath + JsonUtils.MEANING_LESS_KEY_FOR_APPEND_AND_EXTEND);
                expands.add(value);
            }
        }
        return JsonFunctions.jsonInsert((String)jsonStr, (Object[])expands.toArray());
    }

    public static class JsonExtendImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ScalarFunctionImpl function = (ScalarFunctionImpl)ScalarFunctionImpl.create((Method)Types.lookupMethod(JsonExtendFunctionImpl.class, (String)"eval", (Class[])new Class[]{Object[].class}));
            return function.getImplementor().implement(translator, call, RexImpTable.NullAs.NULL);
        }
    }
}

