/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;

public class HashMapKeySetFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Set<HK>> {
    public static final Externalizer EXTERNALIZER = new Externalizer();

    public Set<HK> apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Optional existing = view.peek();
        if (existing.isPresent()) {
            return ((HashMapBucket)existing.get()).keySet();
        }
        return Collections.emptySet();
    }

    private static class Externalizer
    implements AdvancedExternalizer<HashMapKeySetFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends HashMapKeySetFunction>> getTypeClasses() {
            return Collections.singleton(HashMapKeySetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.HASH_MAP_KEYSET_FUNCTION;
        }

        public void writeObject(ObjectOutput output, HashMapKeySetFunction object) throws IOException {
        }

        public HashMapKeySetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new HashMapKeySetFunction();
        }
    }
}

