/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PatternMatchExpression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;

public class XSLMatch
extends StyleElement {
    private Expression select;
    private Pattern pattern;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected boolean mayContainFallback() {
        return true;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
    }

    @Override
    protected void prepareAttributes() {
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String value = att.getValue();
            String f = attName.getDisplayName();
            if (f.equals("select")) {
                this.select = this.makeExpression(value, att);
                continue;
            }
            if (f.equals("pattern")) {
                this.pattern = this.makePattern(value, "pattern");
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.select == null) {
            this.select = new ContextItemExpression();
        }
        if (this.pattern == null) {
            this.reportAbsence("pattern");
            this.pattern = new ItemTypePattern(AnyItemType.getInstance());
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        for (NodeInfo nodeInfo : this.children()) {
            if (nodeInfo instanceof XSLFallback) continue;
            this.compileError("Only xsl:fallback is allowed within xsl:match");
            break;
        }
        this.select = this.typeCheck("select", this.select);
        this.pattern = this.typeCheck("pattern", this.pattern);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new PatternMatchExpression(this.select, this.pattern);
    }
}

