/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIterator
implements SequenceIterator,
UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private Item item;
    boolean gone = false;

    private SingletonIterator(Item value) {
        this.item = value;
    }

    public static <T extends Item> UnfailingIterator makeIterator(T item) {
        if (item == null) {
            return EmptyIterator.emptyIterator();
        }
        return new SingletonIterator(item);
    }

    @Override
    public boolean hasNext() {
        return !this.gone;
    }

    @Override
    public Item next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.item;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void close() {
    }

    @Override
    public SingletonIterator getAnother() {
        return new SingletonIterator(this.item);
    }

    @Override
    public SingletonIterator getReverseIterator() {
        return new SingletonIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    @Override
    public GroundedValue materialize() {
        if (this.item instanceof GroundedValue) {
            return (GroundedValue)((Object)this.item);
        }
        return new ZeroOrOne<Item>(this.item);
    }

    @Override
    public int getProperties() {
        return 7;
    }
}

