untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwR4k2FfA2f/uzTW8XjmH2LKYibNjkG3LcGfxCmEJq5CaVM+hq7Go+qGbnEhdtS7xQ6wJkcQzyhgn7CnatTzYWgc=

OpenBSD 5.9 errata 36, Mar 9, 2017:

Prevent integer overflow in PF when calculating the adaptive timeout,
causing spuriously expired states under pressure.

Alternatively, disable adaptive timeouts with
  set timeout { adaptive.start 0, adaptive.end 0 }

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 036_pf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
retrieving revision 1.965
diff -u -p -r1.965 pf.c
--- sys/net/pf.c	31 Jan 2016 00:18:07 -0000	1.965
+++ sys/net/pf.c	9 Mar 2017 14:51:51 -0000
@@ -1164,7 +1164,7 @@ pf_purge_thread(void *v)
 int32_t
 pf_state_expires(const struct pf_state *state)
 {
-	int32_t		timeout;
+	u_int32_t	timeout;
 	u_int32_t	start;
 	u_int32_t	end;
 	u_int32_t	states;
@@ -1193,7 +1193,7 @@ pf_state_expires(const struct pf_state *
 		if (states >= end)
 			return (0);
 
-		timeout = timeout * (end - states) / (end - start);
+		timeout = (u_int64_t)timeout * (end - states) / (end - start);
 	}
 
 	return (state->expire + timeout);
