/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.util.Objects;

public class GetBranchKeyVersionInput {
    private final String branchKeyIdentifier;
    private final String branchKeyVersion;

    protected GetBranchKeyVersionInput(BuilderImpl builder) {
        this.branchKeyIdentifier = builder.branchKeyIdentifier();
        this.branchKeyVersion = builder.branchKeyVersion();
    }

    public String branchKeyIdentifier() {
        return this.branchKeyIdentifier;
    }

    public String branchKeyVersion() {
        return this.branchKeyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String branchKeyIdentifier;
        protected String branchKeyVersion;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetBranchKeyVersionInput model) {
            this.branchKeyIdentifier = model.branchKeyIdentifier();
            this.branchKeyVersion = model.branchKeyVersion();
        }

        @Override
        public Builder branchKeyIdentifier(String branchKeyIdentifier) {
            this.branchKeyIdentifier = branchKeyIdentifier;
            return this;
        }

        @Override
        public String branchKeyIdentifier() {
            return this.branchKeyIdentifier;
        }

        @Override
        public Builder branchKeyVersion(String branchKeyVersion) {
            this.branchKeyVersion = branchKeyVersion;
            return this;
        }

        @Override
        public String branchKeyVersion() {
            return this.branchKeyVersion;
        }

        @Override
        public GetBranchKeyVersionInput build() {
            if (Objects.isNull(this.branchKeyIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `branchKeyIdentifier`");
            }
            if (Objects.isNull(this.branchKeyVersion())) {
                throw new IllegalArgumentException("Missing value for required field `branchKeyVersion`");
            }
            return new GetBranchKeyVersionInput(this);
        }
    }

    public static interface Builder {
        public Builder branchKeyIdentifier(String var1);

        public String branchKeyIdentifier();

        public Builder branchKeyVersion(String var1);

        public String branchKeyVersion();

        public GetBranchKeyVersionInput build();
    }
}

