/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrap;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import RawECDHKeyring_Compile.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EphemeralPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.PublicKeyDiscoveryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations_EphemeralPrivateKeyToStaticPublicKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations_PublicKeyDiscovery;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations_RawPrivateKeyToStaticPublicKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, Error>> {
    public DecryptionMaterials _materials = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _senderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public RawEcdhStaticConfigurations _keyAgreementScheme = RawEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, RawEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec) {
        this._materials = materials;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = recipientPublicKey;
        this._senderPublicKey = senderPublicKey;
        this._keyAgreementScheme = keyAgreementScheme;
        this._curveSpec = curveSpec;
    }

    @Override
    public Result<DecryptionMaterials, Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _out6;
        Result<DecryptionMaterials, Error> res = null;
        AlgorithmSuiteInfo _0_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _1_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _2_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _3_ciphertext = edk.dtor_ciphertext();
        Result<DafnySequence, Error> _4_valueOrError0 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _4_valueOrError0 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_3_ciphertext, _0_suite);
        if (_4_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _4_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _5_providerWrappedMaterial = _4_valueOrError0.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_2_providerInfo.cardinalityInt(), Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN())) <= 0 && __default.ValidProviderInfoLength(_2_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        byte _7_keyringVersion = (Byte)_2_providerInfo.select(0);
        Outcome<Error> _8_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _8_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_7_keyringVersion}).equals(__default.RAW__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_8_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _8_valueOrError2.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        int _9_recipientPublicKeyLength = StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_2_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()));
        long _10_recipientPublicKeyLengthIndex = Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()) + Integer.toUnsignedLong(_9_recipientPublicKeyLength);
        long _11_senderPublicKeyIndex = _10_recipientPublicKeyLengthIndex + Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN();
        Outcome<Error> _12_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _12_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_10_recipientPublicKeyLengthIndex + 4L, _2_providerInfo.cardinalityInt()) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_12_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _12_valueOrError3.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _13_providerInfoRecipientPublicKey = _2_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.unsignedToInt((long)_10_recipientPublicKeyLengthIndex));
        DafnySequence _14_providerInfoSenderPublicKey = _2_providerInfo.drop(_11_senderPublicKeyIndex);
        Result<DafnySequence, Error> _15_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = __default.DecompressPublicKey((DafnySequence<? extends Byte>)_14_providerInfoSenderPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _15_valueOrError4 = _out0;
        if (_15_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _15_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _16_senderPublicKey = _15_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<DafnySequence, Error> _17_valueOrError5 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out1 = __default.DecompressPublicKey((DafnySequence<? extends Byte>)_13_providerInfoRecipientPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _17_valueOrError5 = _out1;
        if (_17_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _17_valueOrError5.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _18_recipientPublicKey = _17_valueOrError5.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Error> _19_valueOrError6 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out2 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_16_senderPublicKey);
        _19_valueOrError6 = _out2;
        if (_19_valueOrError6.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _19_valueOrError6.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _20___v0 = _19_valueOrError6.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Boolean, Error> _21_valueOrError7 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out3 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_18_recipientPublicKey);
        _21_valueOrError7 = _out3;
        if (_21_valueOrError7.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _21_valueOrError7.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _22___v1 = _21_valueOrError7.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        DafnySequence _23_sharedSecretPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence<? extends Byte> _24_sharedSecretPrivateKey = DafnySequence.empty(uint8._typeDescriptor());
        RawEcdhStaticConfigurations _source0 = this.keyAgreementScheme();
        if (_source0.is_PublicKeyDiscovery()) {
            PublicKeyDiscoveryInput _25___mcc_h0;
            PublicKeyDiscoveryInput _26_publicKeyDiscovery = _25___mcc_h0 = ((RawEcdhStaticConfigurations_PublicKeyDiscovery)_source0)._PublicKeyDiscovery;
            _23_sharedSecretPublicKey = _16_senderPublicKey;
            _24_sharedSecretPrivateKey = _26_publicKeyDiscovery.dtor_recipientStaticPrivateKey();
        } else if (_source0.is_RawPrivateKeyToStaticPublicKey()) {
            RawPrivateKeyToStaticPublicKeyInput _27___mcc_h1;
            RawPrivateKeyToStaticPublicKeyInput _28_rawPrivateKeyToStaticPublicKey = _27___mcc_h1 = ((RawEcdhStaticConfigurations_RawPrivateKeyToStaticPublicKey)_source0)._RawPrivateKeyToStaticPublicKey;
            _24_sharedSecretPrivateKey = _28_rawPrivateKeyToStaticPublicKey.dtor_senderStaticPrivateKey();
            _23_sharedSecretPublicKey = _28_rawPrivateKeyToStaticPublicKey.dtor_recipientPublicKey().equals((Object)_18_recipientPublicKey) ? _18_recipientPublicKey : _16_senderPublicKey;
        } else {
            EphemeralPrivateKeyToStaticPublicKeyInput _29___mcc_h2 = ((RawEcdhStaticConfigurations_EphemeralPrivateKeyToStaticPublicKey)_source0)._EphemeralPrivateKeyToStaticPublicKey;
            res = Result.create_Failure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EphemeralPrivateKeyToStaticPublicKey Not allowed on decrypt")));
            return res;
        }
        Result<Boolean, Error> _30_valueOrError8 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out4 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_23_sharedSecretPublicKey);
        _30_valueOrError8 = _out4;
        if (_30_valueOrError8.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _30_valueOrError8.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _31___v3 = _30_valueOrError8.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<DafnySequence, Error> _32_valueOrError9 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out5 = __default.LocalDeriveSharedSecret(ECCPrivateKey.create(_24_sharedSecretPrivateKey), ECCPublicKey.create((DafnySequence<? extends Byte>)_23_sharedSecretPublicKey), this.curveSpec(), this.cryptoPrimitives());
        _32_valueOrError9 = _out5;
        if (_32_valueOrError9.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _32_valueOrError9.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _33_sharedSecret = _32_valueOrError9.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        EcdhUnwrap _nw0 = new EcdhUnwrap();
        _nw0.__ctor((DafnySequence<? extends Byte>)_14_providerInfoSenderPublicKey, (DafnySequence<? extends Byte>)_13_providerInfoRecipientPublicKey, (DafnySequence<? extends Byte>)_33_sharedSecret, __default.RAW__ECDH__KEYRING__VERSION(), this.curveSpec(), this.cryptoPrimitives());
        EcdhUnwrap _34_ecdhUnwrap = _nw0;
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _35_unwrapOutputRes = _out6 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(EcdhUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _34_ecdhUnwrap);
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _36_valueOrError10 = Result.Default(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), UnwrapEdkMaterialOutput.Default(EcdhUnwrapInfo._typeDescriptor(), EcdhUnwrapInfo.Default()));
        _36_valueOrError10 = _35_unwrapOutputRes;
        if (_36_valueOrError10.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _36_valueOrError10.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<EcdhUnwrapInfo> _37_unwrapOutput = _36_valueOrError10.Extract(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor());
        Result<DecryptionMaterials, Error> _38_valueOrError11 = null;
        _38_valueOrError11 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _37_unwrapOutput.dtor_plaintextDataKey(), _37_unwrapOutput.dtor_symmetricSigningKey());
        if (_38_valueOrError11.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _38_valueOrError11.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _39_result = _38_valueOrError11.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _39_result);
        return res;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> senderPublicKey() {
        return this._senderPublicKey;
    }

    public RawEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawECDHKeyring.DecryptSingleEncryptedDataKey";
    }
}

