/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.cluster;

import java.time.Clock;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.time.FormatNames;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.sql.spark.cluster.IndexCleanup;

public class FlintIndexRetention
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(FlintIndexRetention.class);
    static final String SESSION_INDEX_NOT_EXIST_MSG = "Checkpoint index does not exist.";
    static final String RESULT_INDEX_NOT_EXIST_MSG = "Result index does not exist.";
    static final String UPDATE_TIME_FIELD = "updateTime";
    private final Duration defaultSessionTtl;
    private final Duration defaultResultTtl;
    private final Clock clock;
    private final IndexCleanup indexCleanup;
    private final String sessionIndexNameRegex;
    private final String resultIndexNameRegex;

    public FlintIndexRetention(Duration defaultSessionTtl, Duration defaultResultTtl, Clock clock, IndexCleanup indexCleanup, String sessionIndexNameRegex, String resultIndexNameRegex) {
        this.defaultSessionTtl = defaultSessionTtl;
        this.defaultResultTtl = defaultResultTtl;
        this.clock = clock;
        this.indexCleanup = indexCleanup;
        this.sessionIndexNameRegex = sessionIndexNameRegex;
        this.resultIndexNameRegex = resultIndexNameRegex;
    }

    @Override
    public void run() {
        this.purgeSessionIndex();
    }

    private void purgeSessionIndex() {
        this.purgeIndex(this.sessionIndexNameRegex, this.defaultSessionTtl, "lastUpdateTime", (CheckedConsumer<Long, Exception>)((CheckedConsumer)this::handleSessionPurgeResponse), (CheckedConsumer<Exception, Exception>)((CheckedConsumer)this::handleSessionPurgeError));
    }

    private void handleSessionPurgeResponse(Long response) {
        this.purgeStatementIndex();
    }

    private void handleSessionPurgeError(Exception exception) {
        this.handlePurgeError(SESSION_INDEX_NOT_EXIST_MSG, "session index", exception);
        this.purgeStatementIndex();
    }

    private void purgeStatementIndex() {
        this.purgeIndex(this.sessionIndexNameRegex, this.defaultSessionTtl, "submitTime", (CheckedConsumer<Long, Exception>)((CheckedConsumer)this::handleStatementPurgeResponse), (CheckedConsumer<Exception, Exception>)((CheckedConsumer)this::handleStatementPurgeError));
    }

    private void handleStatementPurgeResponse(Long response) {
        this.purgeResultIndex();
    }

    private void handleStatementPurgeError(Exception exception) {
        this.handlePurgeError(SESSION_INDEX_NOT_EXIST_MSG, "session index", exception);
        this.purgeResultIndex();
    }

    private void purgeResultIndex() {
        this.purgeIndex(this.resultIndexNameRegex, this.defaultResultTtl, UPDATE_TIME_FIELD, (CheckedConsumer<Long, Exception>)((CheckedConsumer)this::handleResultPurgeResponse), (CheckedConsumer<Exception, Exception>)((CheckedConsumer)this::handleResultPurgeError));
    }

    private void handleResultPurgeResponse(Long response) {
        LOG.debug("purge result index done");
    }

    private void handleResultPurgeError(Exception exception) {
        this.handlePurgeError(RESULT_INDEX_NOT_EXIST_MSG, "result index", exception);
    }

    private void handlePurgeError(String notExistMsg, String indexType, Exception exception) {
        if (exception instanceof IndexNotFoundException) {
            LOG.debug(notExistMsg);
        } else {
            LOG.error("delete docs by query fails for " + indexType, (Throwable)exception);
        }
    }

    private void purgeIndex(String indexName, Duration ttl, String timeStampField, CheckedConsumer<Long, Exception> successHandler, CheckedConsumer<Exception, Exception> errorHandler) {
        this.indexCleanup.deleteDocsByQuery(indexName, (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)timeStampField).lte((Object)(this.clock.millis() - ttl.toMillis())).format(FormatNames.EPOCH_MILLIS.getSnakeCaseName())), (ActionListener<Long>)ActionListener.wrap(response -> {
            try {
                successHandler.accept(response);
            }
            catch (Exception e) {
                LOG.error("Error handling response for index " + indexName, (Throwable)e);
            }
        }, ex -> {
            try {
                errorHandler.accept(ex);
            }
            catch (Exception e) {
                LOG.error("Error handling error for index " + indexName, (Throwable)e);
            }
        }));
    }
}

