/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.NullConfiguredProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public interface ConfiguredObjectProvenance
extends ObjectProvenance {
    public Map<String, Provenance> getConfiguredParameters();

    default public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
        return Collections.emptyMap();
    }

    @Override
    default public Iterator<Pair<String, Provenance>> iterator() {
        ArrayList<Pair<String, Provenance>> iterable = new ArrayList<Pair<String, Provenance>>();
        iterable.add(new Pair<String, StringProvenance>("class-name", new StringProvenance("class-name", this.getClassName())));
        for (Map.Entry<String, Provenance> entry : this.getConfiguredParameters().entrySet()) {
            iterable.add(new Pair<String, Provenance>(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Provenance> entry : this.getInstanceValues().entrySet()) {
            iterable.add(new Pair<String, Provenance>(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableList(iterable).iterator();
    }

    public static ConfiguredObjectProvenance getEmptyProvenance(String className) {
        return new NullConfiguredProvenance(className);
    }
}

