/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricGOST3410PrivateKey
extends AsymmetricGOST3410Key<GOST3410DomainParameters>
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters, BigInteger bigInteger) {
        super(algorithm, gOST3410Parameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, fpAcceptable, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricGOST3410PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey());
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i != byArray.length; ++i) {
                byArray2[i] = byArray[byArray.length - 1 - i];
            }
            return new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final GOST3410Parameters<GOST3410DomainParameters> getParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getParameters();
    }

    @Override
    public final byte[] getEncoded() {
        byte[] byArray = this.getX().toByteArray();
        byte[] byArray2 = byArray[0] == 0 ? new byte[byArray.length - 1] : new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = byArray[byArray.length - 1 - i];
        }
        GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters = this.getParameters();
        if (gOST3410Parameters.getEncryptionParamSet() != null) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(gOST3410Parameters.getPublicKeyParamSet(), gOST3410Parameters.getDigestParamSet(), gOST3410Parameters.getEncryptionParamSet())), new DEROctetString(byArray2));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(gOST3410Parameters.getPublicKeyParamSet(), gOST3410Parameters.getDigestParamSet())), new DEROctetString(byArray2));
    }

    public BigInteger getX() {
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return this.x;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.x.hashCode();
        n = 31 * n + this.getParameters().hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricGOST3410PrivateKey)) {
            return false;
        }
        AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)object;
        asymmetricGOST3410PrivateKey.checkApprovedOnlyModeStatus();
        return KeyUtils.isFieldEqual(this.x, asymmetricGOST3410PrivateKey.x) && KeyUtils.isFieldEqual(this.domainParameters, asymmetricGOST3410PrivateKey.domainParameters);
    }
}

