/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.judgments.JudgmentDataTransformer;
import org.opensearch.threadpool.ThreadPool;

public class LlmJudgmentTaskManager {
    @Generated
    private static final Logger log = LogManager.getLogger(LlmJudgmentTaskManager.class);
    private static final String THREAD_POOL_EXECUTOR_NAME = "generic";
    private static final int DEFAULT_MIN_CONCURRENT_THREADS = 24;
    private static final int PROCESSOR_NUMBER_DIVISOR = 2;
    private static final int ALLOCATED_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final ThreadPool threadPool;
    private final Semaphore rateLimiter;
    private final int maxConcurrentTasks;

    @Inject
    public LlmJudgmentTaskManager(ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.maxConcurrentTasks = Math.max(2, Math.min(24, ALLOCATED_PROCESSORS / 2));
        this.rateLimiter = new Semaphore(this.maxConcurrentTasks);
        log.info("LlmJudgmentTaskManager initialized with {} max concurrent tasks (processors: {})", (Object)this.maxConcurrentTasks, (Object)ALLOCATED_PROCESSORS);
    }

    public void scheduleTasksAsync(List<String> queryTextWithReferences, Function<String, Map<String, Object>> queryProcessor, boolean ignoreFailure, ActionListener<List<Map<String, Object>>> listener) {
        int totalQueries = queryTextWithReferences.size();
        log.info("Scheduling {} query text tasks for concurrent processing", (Object)totalQueries);
        try {
            List<CompletableFuture> futures = queryTextWithReferences.stream().map(queryTextWithReference -> CompletableFuture.supplyAsync(() -> {
                this.rateLimiter.acquire();
                try {
                    Map map = (Map)queryProcessor.apply((String)queryTextWithReference);
                    this.rateLimiter.release();
                    return map;
                }
                catch (Throwable throwable) {
                    try {
                        this.rateLimiter.release();
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.warn("Query processing failed, returning empty result for: {}", queryTextWithReference, (Object)e);
                        return JudgmentDataTransformer.createJudgmentResult(queryTextWithReference, Map.of());
                    }
                }
            }, this.threadPool.executor(THREAD_POOL_EXECUTOR_NAME))).collect(Collectors.toList());
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((v, ex) -> {
                List results = futures.stream().map(future -> {
                    try {
                        return (Map)future.join();
                    }
                    catch (Exception e) {
                        log.warn("Individual query future failed, skipping", (Throwable)e);
                        return null;
                    }
                }).filter(result -> result != null).collect(Collectors.toList());
                int processedQueries = results.size();
                int successQueries = (int)results.stream().mapToLong(result -> {
                    List ratings = (List)result.get("ratings");
                    return ratings != null && !ratings.isEmpty() ? 1L : 0L;
                }).sum();
                int failureQueries = totalQueries - processedQueries;
                if (results.isEmpty() && ex != null) {
                    log.error("Task manager failed - Total: {}, Processed: 0, Success: 0, Failure: {}", (Object)totalQueries, (Object)totalQueries, ex);
                    listener.onFailure((Exception)((Object)new SearchRelevanceException("All query text judgments failed", (Throwable)ex, RestStatus.INTERNAL_SERVER_ERROR)));
                } else {
                    log.info("Task manager completed - Total: {}, Processed: {}, Success: {}, Failure: {}", (Object)totalQueries, (Object)processedQueries, (Object)successQueries, (Object)failureQueries);
                    log.info("Task manager calling listener.onResponse with {} results", (Object)results.size());
                    listener.onResponse(results);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to schedule tasks - Total: {}", (Object)totalQueries, (Object)e);
            if (!ignoreFailure) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to schedule judgment tasks", e, RestStatus.INTERNAL_SERVER_ERROR)));
            }
            listener.onResponse(List.of());
        }
    }
}

