/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SNIHostName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.opensearch.Build;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.Version;
import org.opensearch.action.ActionModule;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.opensearch.action.admin.indices.view.ViewService;
import org.opensearch.action.search.SearchExecutionStatsCollector;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchRequestOperationsCompositeListenerFactory;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.action.search.SearchRequestSlowLog;
import org.opensearch.action.search.SearchRequestStats;
import org.opensearch.action.search.SearchTaskRequestOperationsListener;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.search.StreamSearchTransportService;
import org.opensearch.action.support.TransportAction;
import org.opensearch.action.update.UpdateHelper;
import org.opensearch.arrow.spi.StreamManager;
import org.opensearch.bootstrap.BootstrapCheck;
import org.opensearch.bootstrap.BootstrapContext;
import org.opensearch.cluster.ClusterInfoService;
import org.opensearch.cluster.ClusterManagerMetrics;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.InternalClusterInfoService;
import org.opensearch.cluster.NodeConnectionsService;
import org.opensearch.cluster.StreamNodeConnectionsService;
import org.opensearch.cluster.action.index.MappingUpdatedAction;
import org.opensearch.cluster.action.shard.LocalShardStateAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.applicationtemplates.SystemTemplatesPlugin;
import org.opensearch.cluster.applicationtemplates.SystemTemplatesService;
import org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.Manifest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.metadata.SystemIndexMetadataUpgradeService;
import org.opensearch.cluster.metadata.TemplateUpgradeService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.routing.BatchedRerouteService;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.cluster.service.LocalClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.StopWatch;
import org.opensearch.common.cache.module.CacheModule;
import org.opensearch.common.cache.service.CacheService;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.inject.Key;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.ModulesBuilder;
import org.opensearch.common.inject.util.Providers;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.lifecycle.Lifecycle;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.logging.HeaderWarning;
import org.opensearch.common.logging.NodeAndClusterIdStateListener;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.network.NetworkModule;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.ConsistentSettingsService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.SettingUpgrader;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.unit.RatioValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.Assertions;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.crypto.CryptoHandlerRegistry;
import org.opensearch.discovery.Discovery;
import org.opensearch.discovery.DiscoveryModule;
import org.opensearch.discovery.LocalDiscovery;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.env.NodeMetadata;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.extensions.NoopExtensionsManager;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.gateway.GatewayMetaState;
import org.opensearch.gateway.GatewayModule;
import org.opensearch.gateway.GatewayService;
import org.opensearch.gateway.MetaStateService;
import org.opensearch.gateway.PersistedClusterStateService;
import org.opensearch.gateway.ShardsBatchGatewayAllocator;
import org.opensearch.gateway.remote.RemoteClusterStateCleanupManager;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.identity.IdentityService;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexingPressureService;
import org.opensearch.index.IngestionConsumerFactory;
import org.opensearch.index.SegmentReplicationStatsTracker;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.autoforcemerge.AutoForceMergeManager;
import org.opensearch.index.compositeindex.CompositeIndexSettings;
import org.opensearch.index.engine.MergedSegmentWarmerFactory;
import org.opensearch.index.mapper.MappingTransformerRegistry;
import org.opensearch.index.recovery.RemoteStoreRestoreService;
import org.opensearch.index.remote.RemoteIndexPathUploader;
import org.opensearch.index.remote.RemoteStoreStatsTrackerFactory;
import org.opensearch.index.store.DefaultCompositeDirectoryFactory;
import org.opensearch.index.store.IndexStoreListener;
import org.opensearch.index.store.RemoteSegmentStoreDirectoryFactory;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCacheCleaner;
import org.opensearch.index.store.remote.filecache.FileCacheFactory;
import org.opensearch.index.store.remote.filecache.FileCacheSettings;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.indices.SystemIndices;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.indices.breaker.BreakerSettings;
import org.opensearch.indices.breaker.HierarchyCircuitBreakerService;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.indices.recovery.PeerRecoverySourceService;
import org.opensearch.indices.recovery.PeerRecoveryTargetService;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.replication.SegmentReplicationSourceFactory;
import org.opensearch.indices.replication.SegmentReplicationSourceService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.replication.SegmentReplicator;
import org.opensearch.indices.replication.checkpoint.MergedSegmentPublisher;
import org.opensearch.indices.replication.checkpoint.PublishMergedSegmentAction;
import org.opensearch.indices.replication.checkpoint.RemoteStorePublishMergedSegmentAction;
import org.opensearch.indices.store.IndicesStore;
import org.opensearch.ingest.IngestService;
import org.opensearch.ingest.SystemIngestPipelineCache;
import org.opensearch.monitor.MonitorService;
import org.opensearch.monitor.fs.FsHealthService;
import org.opensearch.monitor.fs.FsProbe;
import org.opensearch.monitor.fs.FsServiceProvider;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.node.NodeService;
import org.opensearch.node.NodeValidationException;
import org.opensearch.node.ResourceUsageCollectorService;
import org.opensearch.node.ResponseCollectorService;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.node.remotestore.RemoteStoreNodeService;
import org.opensearch.node.remotestore.RemoteStorePinnedTimestampService;
import org.opensearch.node.resource.tracker.NodeResourceUsageTracker;
import org.opensearch.persistent.PersistentTasksClusterService;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.persistent.PersistentTasksExecutorRegistry;
import org.opensearch.persistent.PersistentTasksService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.CachePlugin;
import org.opensearch.plugins.CircuitBreakerPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.CryptoKeyProviderPlugin;
import org.opensearch.plugins.CryptoPlugin;
import org.opensearch.plugins.DiscoveryPlugin;
import org.opensearch.plugins.EnginePlugin;
import org.opensearch.plugins.ExtensionAwarePlugin;
import org.opensearch.plugins.IdentityAwarePlugin;
import org.opensearch.plugins.IdentityPlugin;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.IngestionConsumerPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.MetadataUpgrader;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.PersistentTaskPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.PluginInfo;
import org.opensearch.plugins.PluginsService;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.StreamManagerPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.plugins.TaskManagerClientPlugin;
import org.opensearch.plugins.TelemetryAwarePlugin;
import org.opensearch.plugins.TelemetryPlugin;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlService;
import org.opensearch.ratelimitting.admissioncontrol.transport.AdmissionControlTransportInterceptor;
import org.opensearch.repositories.RepositoriesModule;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptModule;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchModule;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.support.AggregationUsageService;
import org.opensearch.search.backpressure.SearchBackpressureService;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.opensearch.search.deciders.ConcurrentSearchRequestDecider;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.pipeline.SearchPipelineService;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.snapshots.InternalSnapshotsInfoService;
import org.opensearch.snapshots.RestoreService;
import org.opensearch.snapshots.SnapshotShardsService;
import org.opensearch.snapshots.SnapshotsInfoService;
import org.opensearch.snapshots.SnapshotsService;
import org.opensearch.task.commons.clients.TaskManagerClient;
import org.opensearch.tasks.TaskCancellationMonitoringService;
import org.opensearch.tasks.TaskCancellationMonitoringSettings;
import org.opensearch.tasks.TaskCancellationService;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.tasks.TaskResultsService;
import org.opensearch.tasks.consumer.TopNSearchTasksLogger;
import org.opensearch.telemetry.TelemetryModule;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.MetricsRegistryFactory;
import org.opensearch.telemetry.metrics.NoopMetricsRegistryFactory;
import org.opensearch.telemetry.tracing.NoopTracerFactory;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.TracerFactory;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.RunnableTaskExecutionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.AuxTransport;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.StreamTransportService;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.usage.UsageService;
import org.opensearch.watcher.ResourceWatcherService;
import org.opensearch.wlm.WorkloadGroupService;
import org.opensearch.wlm.WorkloadGroupsStateAccessor;
import org.opensearch.wlm.WorkloadManagementSettings;
import org.opensearch.wlm.WorkloadManagementTransportInterceptor;
import org.opensearch.wlm.cancellation.MaximumResourceTaskSelectionStrategy;
import org.opensearch.wlm.cancellation.WorkloadGroupTaskCancellationService;
import org.opensearch.wlm.listeners.WorkloadGroupRequestOperationListener;
import org.opensearch.wlm.tracker.WorkloadGroupResourceUsageTrackerService;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_DATA_SETTING = Setting.boolSetting("node.data", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_MASTER_SETTING = Setting.boolSetting("node.master", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_INGEST_SETTING = Setting.boolSetting("node.ingest", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_REMOTE_CLUSTER_CLIENT = Setting.boolSetting("node.remote_cluster_client", RemoteClusterService.ENABLE_REMOTE_CLUSTERS, Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_LOCAL_STORAGE_SETTING = Setting.boolSetting("node.local_storage", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, Setting.Property.NodeScope));
    public static final Setting<String> BREAKER_TYPE_KEY = new Setting<String>("indices.breaker.type", "hierarchy", s -> {
        switch (s) {
            case "hierarchy": 
            case "none": {
                return s;
            }
        }
        throw new IllegalArgumentException("indices.breaker.type must be one of [hierarchy, none] but was: " + s);
    }, Setting.Property.NodeScope);
    private static final String ZERO = "0";
    public static final Setting<String> NODE_SEARCH_CACHE_SIZE_SETTING = new Setting<String>("node.search.cache.size", s -> DiscoveryNode.isDedicatedWarmNode(s) ? "80%" : ZERO, Node::validateFileCacheSize, Setting.Property.NodeScope);
    private static final String CLIENT_TYPE = "node";
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Node.class);
    private final Injector injector;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final ExtensionsManager extensionsManager;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;
    private final Tracer tracer;
    private final AutoForceMergeManager autoForceMergeManager;
    private final MetricsRegistry metricsRegistry;
    final NamedWriteableRegistry namedWriteableRegistry;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;
    private FileCache fileCache;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;
    private final MergedSegmentWarmerFactory mergedSegmentWarmerFactory;

    public Node(Environment environment) {
        this(environment, Collections.emptyList(), true);
    }

    protected Node(Environment initialEnvironment, Collection<PluginInfo> classpathPlugins, boolean forbidPrivateIndexSettings) {
        ArrayList<Object> resourcesToClose = new ArrayList<Object>();
        boolean success = false;
        try {
            RemoteStorePinnedTimestampService remoteStorePinnedTimestampService;
            RemoteClusterStateCleanupManager remoteClusterStateCleanupManager;
            RemoteClusterStateService remoteClusterStateService;
            RemoteIndexPathUploader remoteIndexPathUploader;
            MetricsRegistryFactory metricsRegistryFactory;
            TracerFactory tracerFactory;
            Settings tmpSettings = Settings.builder().put(initialEnvironment.settings()).put(Client.CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE).put(NODE_ATTRIBUTES.getKey() + "shard_indexing_pressure_enabled", "true").build();
            JvmInfo jvmInfo = JvmInfo.jvmInfo();
            this.logger.info("version[{}], pid[{}], build[{}/{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Build.CURRENT.getQualifiedVersion(), jvmInfo.pid(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, System.getProperty("java.version"), Runtime.version().toString()});
            if (jvmInfo.getBundledJdk()) {
                this.logger.info("JVM home [{}], using bundled JDK/JRE [{}]", (Object)System.getProperty("java.home"), (Object)jvmInfo.getUsingBundledJdk());
            } else {
                this.logger.info("JVM home [{}]", (Object)System.getProperty("java.home"));
                this.deprecationLogger.deprecate("no-jdk", "no-jdk distributions that do not bundle a JDK are deprecated and will be removed in a future release", new Object[0]);
            }
            this.logger.info("JVM arguments {}", (Object)Arrays.toString(jvmInfo.getInputArguments()));
            if (!Build.CURRENT.isProductionRelease()) {
                this.logger.warn("version [{}] is a pre-release version of OpenSearch and is not suitable for production", (Object)Build.CURRENT.getQualifiedVersion());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)initialEnvironment.configDir(), (Object)Arrays.toString(initialEnvironment.dataFiles()), (Object)initialEnvironment.logsDir(), (Object)initialEnvironment.pluginsDir());
            }
            FeatureFlags.initializeFeatureFlags(tmpSettings);
            this.pluginsService = new PluginsService(tmpSettings, initialEnvironment.configDir(), initialEnvironment.modulesDir(), initialEnvironment.pluginsDir(), classpathPlugins);
            Settings settings = this.pluginsService.updatedSettings();
            ArrayList<IdentityPlugin> identityPlugins = new ArrayList<IdentityPlugin>();
            identityPlugins.addAll(this.pluginsService.filterPlugins(IdentityPlugin.class));
            Set<DiscoveryNodeRole> additionalRoles = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getRoles).flatMap(Collection::stream).collect(Collectors.toSet());
            DiscoveryNode.setAdditionalRoles(additionalRoles);
            DiscoveryNode.setDeprecatedMasterRole();
            this.environment = new Environment(settings, initialEnvironment.configDir(), NODE_LOCAL_STORAGE_SETTING.get(settings));
            Environment.assertEquivalent(initialEnvironment, this.environment);
            Stream<IndexStoreListener> indexStoreListenerStream = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getIndexStoreListener).filter(Optional::isPresent).map(Optional::get);
            this.nodeEnvironment = !DiscoveryNode.isWarmNode(settings) ? new NodeEnvironment(settings, this.environment, new IndexStoreListener.CompositeIndexStoreListener(indexStoreListenerStream.collect(Collectors.toList()))) : new NodeEnvironment(settings, this.environment, new IndexStoreListener.CompositeIndexStoreListener(Stream.concat(indexStoreListenerStream, Stream.of(new FileCacheCleaner(this::fileCache))).collect(Collectors.toList())));
            this.logger.info("node name [{}], node ID [{}], cluster name [{}], roles {}", (Object)NODE_NAME_SETTING.get(tmpSettings), (Object)this.nodeEnvironment.nodeId(), (Object)ClusterName.CLUSTER_NAME_SETTING.get(tmpSettings).value(), (Object)DiscoveryNode.getRolesFromSettings(settings).stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toCollection(LinkedHashSet::new)));
            resourcesToClose.add(this.nodeEnvironment);
            List<ExecutorBuilder<?>> executorBuilders = this.pluginsService.getExecutorBuilders(settings);
            this.runnableTaskListener = new AtomicReference();
            ThreadPool threadPool = new ThreadPool(settings, this.runnableTaskListener, executorBuilders.toArray(new ExecutorBuilder[0]));
            IdentityService identityService = new IdentityService(settings, threadPool, identityPlugins);
            if (FeatureFlags.isEnabled("opensearch.experimental.feature.extensions.enabled")) {
                List<ExtensionAwarePlugin> extensionAwarePlugins = this.pluginsService.filterPlugins(ExtensionAwarePlugin.class);
                HashSet additionalSettings = new HashSet();
                for (ExtensionAwarePlugin extAwarePlugin : extensionAwarePlugins) {
                    additionalSettings.addAll(extAwarePlugin.getExtensionSettings());
                }
                this.extensionsManager = new ExtensionsManager(additionalSettings, identityService);
            } else {
                this.extensionsManager = new NoopExtensionsManager(identityService);
            }
            SetOnce repositoriesServiceReference = new SetOnce();
            RemoteStoreNodeService remoteStoreNodeService = new RemoteStoreNodeService(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool);
            this.localNodeFactory = new LocalNodeFactory(settings, this.nodeEnvironment.nodeId(), remoteStoreNodeService);
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            ResourceWatcherService resourceWatcherService = new ResourceWatcherService(settings, threadPool);
            resourcesToClose.add(resourceWatcherService);
            HeaderWarning.setThreadContext(threadPool.getThreadContext());
            resourcesToClose.add(() -> HeaderWarning.removeThreadContext(threadPool.getThreadContext()));
            ArrayList additionalSettings = new ArrayList();
            additionalSettings.add(NODE_DATA_SETTING);
            additionalSettings.add(NODE_INGEST_SETTING);
            additionalSettings.add(NODE_MASTER_SETTING);
            additionalSettings.add(NODE_REMOTE_CLUSTER_CLIENT);
            additionalSettings.addAll(this.pluginsService.getPluginSettings());
            ArrayList<String> additionalSettingsFilter = new ArrayList<String>(this.pluginsService.getPluginSettingsFilter());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient(settings, threadPool);
            ScriptModule scriptModule = new ScriptModule(settings, this.pluginsService.filterPlugins(ScriptPlugin.class));
            ScriptService scriptService = this.newScriptService(settings, scriptModule.engines, scriptModule.contexts);
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class));
            Set<SettingUpgrader<?>> settingsUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getSettingUpgraders).flatMap(Collection::stream).collect(Collectors.toSet());
            SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, additionalSettingsFilter, settingsUpgraders);
            threadPool.registerClusterSettingsListeners(settingsModule.getClusterSettings());
            scriptModule.registerClusterSettingsListeners(scriptService, settingsModule.getClusterSettings());
            NetworkService networkService = new NetworkService(this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            if (FeatureFlags.isEnabled("opensearch.experimental.feature.telemetry.enabled")) {
                TelemetrySettings telemetrySettings = new TelemetrySettings(settings, settingsModule.getClusterSettings());
                if (telemetrySettings.isTracingFeatureEnabled() || telemetrySettings.isMetricsFeatureEnabled()) {
                    List<TelemetryPlugin> telemetryPlugins = this.pluginsService.filterPlugins(TelemetryPlugin.class);
                    List telemetryPluginsImplementingTelemetryAware = telemetryPlugins.stream().filter(a -> TelemetryAwarePlugin.class.isAssignableFrom(a.getClass())).collect(Collectors.toList());
                    if (!telemetryPluginsImplementingTelemetryAware.isEmpty()) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Telemetry plugins %s should not implement TelemetryAwarePlugin interface", telemetryPluginsImplementingTelemetryAware));
                    }
                    TelemetryModule telemetryModule = new TelemetryModule(telemetryPlugins, telemetrySettings);
                    tracerFactory = telemetrySettings.isTracingFeatureEnabled() ? new TracerFactory(telemetrySettings, telemetryModule.getTelemetry(), threadPool.getThreadContext()) : new NoopTracerFactory();
                    metricsRegistryFactory = telemetrySettings.isMetricsFeatureEnabled() ? new MetricsRegistryFactory(telemetrySettings, telemetryModule.getTelemetry()) : new NoopMetricsRegistryFactory();
                } else {
                    tracerFactory = new NoopTracerFactory();
                    metricsRegistryFactory = new NoopMetricsRegistryFactory();
                }
            } else {
                tracerFactory = new NoopTracerFactory();
                metricsRegistryFactory = new NoopMetricsRegistryFactory();
            }
            this.tracer = ((TracerFactory)tracerFactory).getTracer();
            this.metricsRegistry = ((MetricsRegistryFactory)metricsRegistryFactory).getMetricsRegistry();
            resourcesToClose.add(() -> this.tracer.close());
            resourcesToClose.add(() -> this.metricsRegistry.close());
            ClusterManagerMetrics clusterManagerMetrics = new ClusterManagerMetrics(this.metricsRegistry);
            List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
            boolean clusterless = clusterPlugins.stream().anyMatch(ClusterPlugin::isClusterless);
            ClusterService clusterService = clusterless ? new LocalClusterService(settings, settingsModule.getClusterSettings(), threadPool, clusterManagerMetrics) : new ClusterService(settings, settingsModule.getClusterSettings(), threadPool, clusterManagerMetrics);
            clusterService.addStateApplier(scriptService);
            resourcesToClose.add((Object)clusterService);
            Set<Setting<?>> consistentSettings = settingsModule.getConsistentSettings();
            if (!consistentSettings.isEmpty()) {
                clusterService.addLocalNodeClusterManagerListener(new ConsistentSettingsService(settings, clusterService, consistentSettings).newHashPublisher());
            }
            SystemTemplatesService systemTemplatesService = new SystemTemplatesService(this.pluginsService.filterPlugins(SystemTemplatesPlugin.class), threadPool, clusterService.getClusterSettings(), settings);
            systemTemplatesService.verifyRepositories();
            clusterService.addLocalNodeClusterManagerListener(systemTemplatesService);
            ClusterInfoService clusterInfoService = this.newClusterInfoService(settings, clusterService, threadPool, this.client);
            UsageService usageService = new UsageService();
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : this.pluginsService.createGuiceModules()) {
                modules.add(pluginModule);
            }
            FsHealthService fsHealthService = new FsHealthService(settings, clusterService.getClusterSettings(), threadPool, this.nodeEnvironment, this.metricsRegistry);
            SetOnce rerouteServiceReference = new SetOnce();
            InternalSnapshotsInfoService snapshotsInfoService = new InternalSnapshotsInfoService(settings, clusterService, () -> ((SetOnce)repositoriesServiceReference).get(), () -> ((SetOnce)rerouteServiceReference).get());
            Map<String, Collection<SystemIndexDescriptor>> systemIndexDescriptorMap = Collections.unmodifiableMap(this.pluginsService.filterPlugins(SystemIndexPlugin.class).stream().collect(Collectors.toMap(plugin -> plugin.getClass().getCanonicalName(), plugin -> plugin.getSystemIndexDescriptors(settings))));
            SystemIndices systemIndices = new SystemIndices(systemIndexDescriptorMap);
            ClusterModule clusterModule = new ClusterModule(settings, clusterService, clusterPlugins, clusterInfoService, snapshotsInfoService, threadPool.getThreadContext(), clusterManagerMetrics, clusterless ? LocalShardStateAction.class : ShardStateAction.class);
            modules.add(clusterModule);
            List<MapperPlugin> mapperPlugins = this.pluginsService.filterPlugins(MapperPlugin.class);
            IndicesModule indicesModule = new IndicesModule(mapperPlugins);
            modules.add(indicesModule);
            SearchModule searchModule = new SearchModule(settings, this.pluginsService.filterPlugins(SearchPlugin.class));
            List<BreakerSettings> pluginCircuitBreakers = this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).stream().map(plugin -> plugin.getCircuitBreaker(settings)).collect(Collectors.toList());
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), pluginCircuitBreakers, settingsModule.getClusterSettings());
            this.initializeFileCache(settings, circuitBreakerService.getBreaker("request"));
            this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).forEach(plugin -> {
                CircuitBreaker breaker = circuitBreakerService.getBreaker(plugin.getCircuitBreaker(settings).getName());
                plugin.setCircuitBreaker(breaker);
            });
            resourcesToClose.add(circuitBreakerService);
            modules.add(new GatewayModule());
            PageCacheRecycler pageCacheRecycler = this.createPageCacheRecycler(settings);
            BigArrays bigArrays = this.createBigArrays(pageCacheRecycler, circuitBreakerService);
            modules.add(settingsModule);
            List namedWriteables = Stream.of(NetworkModule.getNamedWriteables().stream(), indicesModule.getNamedWriteables().stream(), searchModule.getNamedWriteables().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()), ClusterModule.getNamedWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList());
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), IndicesModule.getNamedXContents().stream(), searchModule.getNamedXContents().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream()), ClusterModule.getNamedXWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, xContentRegistry);
            PersistedClusterStateService lucenePersistedStateFactory = new PersistedClusterStateService(this.nodeEnvironment, xContentRegistry, bigArrays, clusterService.getClusterSettings(), threadPool::relativeTimeInMillis);
            RemoteStoreSettings remoteStoreSettings = new RemoteStoreSettings(settings, settingsModule.getClusterSettings());
            if (RemoteStoreNodeAttribute.isRemoteClusterStateConfigured(settings)) {
                remoteIndexPathUploader = new RemoteIndexPathUploader(threadPool, settings, () -> ((SetOnce)repositoriesServiceReference).get(), clusterService.getClusterSettings(), remoteStoreSettings);
                remoteClusterStateService = new RemoteClusterStateService(this.nodeEnvironment.nodeId(), () -> ((SetOnce)repositoriesServiceReference).get(), settings, clusterService, threadPool::preciseRelativeTimeInNanos, threadPool, List.of(remoteIndexPathUploader), namedWriteableRegistry);
                remoteClusterStateCleanupManager = remoteClusterStateService.getCleanupManager();
            } else {
                remoteClusterStateService = null;
                remoteIndexPathUploader = null;
                remoteClusterStateCleanupManager = null;
            }
            if (RemoteStoreNodeAttribute.isRemoteDataAttributePresent(settings) && RemoteStoreSettings.CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_ENABLED.get(settings).booleanValue()) {
                remoteStorePinnedTimestampService = new RemoteStorePinnedTimestampService(() -> ((SetOnce)repositoriesServiceReference).get(), settings, threadPool, clusterService);
                resourcesToClose.add(remoteStorePinnedTimestampService);
            } else {
                remoteStorePinnedTimestampService = null;
            }
            List<EnginePlugin> enginePlugins = this.pluginsService.filterPlugins(EnginePlugin.class);
            Collection engineFactoryProviders = enginePlugins.stream().map(plugin -> plugin::getEngineFactory).collect(Collectors.toList());
            HashMap<String, IngestionConsumerFactory> ingestionConsumerFactories = new HashMap<String, IngestionConsumerFactory>();
            this.pluginsService.filterPlugins(IngestionConsumerPlugin.class).forEach(plugin -> ingestionConsumerFactories.putAll(plugin.getIngestionConsumerFactories()));
            Map<String, IndexStorePlugin.DirectoryFactory> builtInDirectoryFactories = IndexModule.createBuiltInDirectoryFactories(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool, this.fileCache);
            HashMap<String, IndexStorePlugin.DirectoryFactory> directoryFactories = new HashMap<String, IndexStorePlugin.DirectoryFactory>();
            this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((k, v) -> {
                if (builtInDirectoryFactories.containsKey(k)) {
                    throw new IllegalStateException("registered index store type [" + k + "] conflicts with a built-in type");
                }
                directoryFactories.put((String)k, (IndexStorePlugin.DirectoryFactory)v);
            });
            directoryFactories.putAll(builtInDirectoryFactories);
            HashMap<String, DefaultCompositeDirectoryFactory> compositeDirectoryFactories = new HashMap<String, DefaultCompositeDirectoryFactory>();
            this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getCompositeDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((k, v) -> {
                if (k.equals("default")) {
                    throw new IllegalStateException("registered composite index store type [" + k + "] conflicts with a built-in default type");
                }
                compositeDirectoryFactories.put((String)k, (DefaultCompositeDirectoryFactory)v);
            });
            compositeDirectoryFactories.put("default", new DefaultCompositeDirectoryFactory());
            Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getRecoveryStateFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
            rerouteServiceReference.set((Object)rerouteService);
            clusterService.setRerouteService(rerouteService);
            clusterModule.setRerouteServiceForAllocator(rerouteService);
            RecoverySettings recoverySettings = new RecoverySettings(settings, settingsModule.getClusterSettings());
            CompositeIndexSettings compositeIndexSettings = new CompositeIndexSettings(settings, settingsModule.getClusterSettings());
            RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool, remoteStoreSettings.getSegmentsPathFixedPrefix());
            TaskResourceTrackingService taskResourceTrackingService = new TaskResourceTrackingService(settings, clusterService.getClusterSettings(), threadPool);
            SearchRequestStats searchRequestStats = new SearchRequestStats(clusterService.getClusterSettings());
            SearchRequestSlowLog searchRequestSlowLog = new SearchRequestSlowLog(clusterService);
            SearchTaskRequestOperationsListener searchTaskRequestOperationsListener = new SearchTaskRequestOperationsListener(taskResourceTrackingService);
            this.remoteStoreStatsTrackerFactory = new RemoteStoreStatsTrackerFactory(clusterService, settings);
            CacheModule cacheModule = new CacheModule(this.pluginsService.filterPlugins(CachePlugin.class), settings);
            CacheService cacheService = cacheModule.getCacheService();
            SegmentReplicator segmentReplicator = new SegmentReplicator(threadPool);
            IndicesService indicesService = new IndicesService(settings, this.pluginsService, this.nodeEnvironment, xContentRegistry, analysisModule.getAnalysisRegistry(), clusterModule.getIndexNameExpressionResolver(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, scriptService, clusterService, this.client, metaStateService, engineFactoryProviders, Map.copyOf(directoryFactories), Map.copyOf(compositeDirectoryFactories), searchModule.getValuesSourceRegistry(), recoveryStateFactories, remoteDirectoryFactory, () -> ((SetOnce)repositoriesServiceReference).get(), searchRequestStats, this.remoteStoreStatsTrackerFactory, ingestionConsumerFactories, recoverySettings, cacheService, remoteStoreSettings, this.fileCache, compositeIndexSettings, segmentReplicator::startReplication, segmentReplicator::getSegmentReplicationStats);
            IngestService ingestService = new IngestService(clusterService, threadPool, this.environment, scriptService, analysisModule.getAnalysisRegistry(), this.pluginsService.filterPlugins(IngestPlugin.class), this.client, indicesService, xContentRegistry, new SystemIngestPipelineCache());
            FsServiceProvider fsServiceProvider = new FsServiceProvider(settings, this.nodeEnvironment, this.fileCache, settingsModule.getClusterSettings(), indicesService);
            MonitorService monitorService = new MonitorService(settings, threadPool, fsServiceProvider);
            AliasValidator aliasValidator = new AliasValidator();
            ShardLimitValidator shardLimitValidator = new ShardLimitValidator(settings, clusterService, systemIndices);
            AwarenessReplicaBalance awarenessReplicaBalance = new AwarenessReplicaBalance(settings, clusterService.getClusterSettings());
            MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(settings, clusterService, indicesService, clusterModule.getAllocationService(), aliasValidator, shardLimitValidator, this.environment, settingsModule.getIndexScopedSettings(), threadPool, xContentRegistry, systemIndices, forbidPrivateIndexSettings, awarenessReplicaBalance, remoteStoreSettings, () -> ((SetOnce)repositoriesServiceReference).get());
            this.pluginsService.filterPlugins(Plugin.class).forEach(p -> p.getAdditionalIndexSettingProviders().forEach(metadataCreateIndexService::addAdditionalIndexSettingProvider));
            MetadataCreateDataStreamService metadataCreateDataStreamService = new MetadataCreateDataStreamService(threadPool, clusterService, metadataCreateIndexService);
            ViewService viewService = new ViewService(clusterService, this.client, null);
            Collection pluginComponents = this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.createComponents(this.client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, this.environment, this.nodeEnvironment, namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), () -> ((SetOnce)repositoriesServiceReference).get()).stream()).collect(Collectors.toList());
            Collection telemetryAwarePluginComponents = this.pluginsService.filterPlugins(TelemetryAwarePlugin.class).stream().flatMap(p -> p.createComponents(this.client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, this.environment, this.nodeEnvironment, namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), () -> ((SetOnce)repositoriesServiceReference).get(), this.tracer, this.metricsRegistry).stream()).collect(Collectors.toList());
            pluginComponents.addAll(telemetryAwarePluginComponents);
            List<IdentityAwarePlugin> identityAwarePlugins = this.pluginsService.filterPlugins(IdentityAwarePlugin.class);
            identityService.initializeIdentityAwarePlugins(identityAwarePlugins);
            WorkloadGroupResourceUsageTrackerService workloadGroupResourceUsageTrackerService = new WorkloadGroupResourceUsageTrackerService(taskResourceTrackingService);
            WorkloadManagementSettings workloadManagementSettings = new WorkloadManagementSettings(settings, settingsModule.getClusterSettings());
            WorkloadGroupsStateAccessor workloadGroupsStateAccessor = new WorkloadGroupsStateAccessor();
            WorkloadGroupService workloadGroupService = new WorkloadGroupService(new WorkloadGroupTaskCancellationService(workloadManagementSettings, new MaximumResourceTaskSelectionStrategy(), workloadGroupResourceUsageTrackerService, workloadGroupsStateAccessor), clusterService, threadPool, workloadManagementSettings, workloadGroupsStateAccessor);
            taskResourceTrackingService.addTaskCompletionListener(workloadGroupService);
            WorkloadGroupRequestOperationListener workloadGroupRequestOperationListener = new WorkloadGroupRequestOperationListener(workloadGroupService, threadPool);
            SearchRequestOperationsCompositeListenerFactory searchRequestOperationsCompositeListenerFactory = new SearchRequestOperationsCompositeListenerFactory((SearchRequestOperationsListener[])Stream.concat(Stream.of(searchRequestStats, searchRequestSlowLog, searchTaskRequestOperationsListener, workloadGroupRequestOperationListener), pluginComponents.stream().filter(p -> p instanceof SearchRequestOperationsListener).map(p -> (SearchRequestOperationsListener)p)).toArray(SearchRequestOperationsListener[]::new));
            ActionModule actionModule = new ActionModule(settings, clusterModule.getIndexNameExpressionResolver(), settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, this.pluginsService.filterPlugins(ActionPlugin.class), this.client, circuitBreakerService, usageService, systemIndices, identityService, this.extensionsManager);
            modules.add(actionModule);
            RestController restController = actionModule.getRestController();
            NodeResourceUsageTracker nodeResourceUsageTracker = new NodeResourceUsageTracker(monitorService.fsService(), threadPool, settings, clusterService.getClusterSettings());
            ResourceUsageCollectorService resourceUsageCollectorService = new ResourceUsageCollectorService(nodeResourceUsageTracker, clusterService, threadPool);
            AdmissionControlService admissionControlService = new AdmissionControlService(settings, clusterService, threadPool, resourceUsageCollectorService);
            AdmissionControlTransportInterceptor admissionControlTransportInterceptor = new AdmissionControlTransportInterceptor(admissionControlService);
            WorkloadManagementTransportInterceptor workloadManagementTransportInterceptor = new WorkloadManagementTransportInterceptor(threadPool, workloadGroupService);
            this.autoForceMergeManager = new AutoForceMergeManager(threadPool, monitorService, indicesService, clusterService);
            Collection secureSettingsFactories = this.pluginsService.filterPlugins(Plugin.class).stream().map(p -> p.getSecureSettingFactory(settings)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List<TransportInterceptor> transportInterceptors = List.of(admissionControlTransportInterceptor, workloadManagementTransportInterceptor);
            NetworkModule networkModule = new NetworkModule(settings, this.pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, restController, clusterService.getClusterSettings(), this.tracer, transportInterceptors, secureSettingsFactories);
            Collection indexTemplateMetadataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getIndexTemplateMetadataUpgrader).collect(Collectors.toList());
            MetadataUpgrader metadataUpgrader = new MetadataUpgrader(indexTemplateMetadataUpgraders);
            MetadataIndexUpgradeService metadataIndexUpgradeService = new MetadataIndexUpgradeService(settings, xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings(), systemIndices, scriptService);
            if (DiscoveryNode.isClusterManagerNode(settings)) {
                clusterService.addListener(new SystemIndexMetadataUpgradeService(systemIndices, clusterService));
            }
            new TemplateUpgradeService(this.client, clusterService, threadPool, indexTemplateMetadataUpgraders);
            Transport transport = networkModule.getTransportSupplier().get();
            Supplier<Transport> streamTransportSupplier = networkModule.getStreamTransportSupplier();
            if (FeatureFlags.isEnabled("opensearch.experimental.feature.transport.stream.enabled") && streamTransportSupplier == null) {
                throw new IllegalStateException("opensearch.experimental.feature.transport.stream.enabled is enabled but no stream transport supplier is provided");
            }
            Transport streamTransport = streamTransportSupplier != null ? streamTransportSupplier.get() : null;
            Set<String> taskHeaders = Stream.concat(this.pluginsService.filterPlugins(ActionPlugin.class).stream().flatMap(p -> p.getTaskHeaders().stream()), Stream.of("X-Opaque-Id")).collect(Collectors.toSet());
            TransportService transportService = this.newTransportService(settings, transport, streamTransport, threadPool, networkModule.getTransportInterceptor(), this.localNodeFactory, settingsModule.getClusterSettings(), taskHeaders, this.tracer);
            Optional<StreamTransportService> streamTransportService = streamTransport != null ? Optional.of(new StreamTransportService(settings, streamTransport, threadPool, networkModule.getTransportInterceptor(), (Function<BoundTransportAddress, DiscoveryNode>)new LocalNodeFactory(settings, this.nodeEnvironment.nodeId(), remoteStoreNodeService), settingsModule.getClusterSettings(), transportService.getTaskManager(), transportService.getRemoteClusterService(), this.tracer)) : Optional.empty();
            TopNSearchTasksLogger taskConsumer = new TopNSearchTasksLogger(settings, settingsModule.getClusterSettings());
            transportService.getTaskManager().registerTaskResourceConsumer(taskConsumer);
            streamTransportService.ifPresent(service -> service.getTaskManager().registerTaskResourceConsumer(taskConsumer));
            this.extensionsManager.initializeServicesAndRestHandler(actionModule, settingsModule, transportService, clusterService, this.environment.settings(), this.client, identityService);
            PersistedStateRegistry persistedStateRegistry = new PersistedStateRegistry();
            GatewayMetaState gatewayMetaState = new GatewayMetaState();
            ResponseCollectorService responseCollectorService = new ResponseCollectorService(clusterService);
            SearchTransportService searchTransportService = new SearchTransportService(transportService, SearchExecutionStatsCollector.makeWrapper(responseCollectorService));
            Optional<StreamSearchTransportService> streamSearchTransportService = streamTransportService.map(stc -> new StreamSearchTransportService((StreamTransportService)stc, SearchExecutionStatsCollector.makeWrapper(responseCollectorService)));
            HttpServerTransport httpServerTransport = this.newHttpTransport(networkModule);
            pluginComponents.addAll(this.newAuxTransports(networkModule));
            IndexingPressureService indexingPressureService = new IndexingPressureService(settings, clusterService);
            clusterService.setIndexingPressureService(indexingPressureService);
            SearchBackpressureSettings searchBackpressureSettings = new SearchBackpressureSettings(settings, clusterService.getClusterSettings());
            SearchBackpressureService searchBackpressureService = new SearchBackpressureService(searchBackpressureSettings, taskResourceTrackingService, threadPool, transportService.getTaskManager(), workloadGroupService);
            SegmentReplicationStatsTracker segmentReplicationStatsTracker = new SegmentReplicationStatsTracker(indicesService);
            RepositoriesModule repositoriesModule = new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), transportService, clusterService, threadPool, xContentRegistry, recoverySettings);
            CryptoHandlerRegistry.initRegistry(this.pluginsService.filterPlugins(CryptoPlugin.class), this.pluginsService.filterPlugins(CryptoKeyProviderPlugin.class), settings);
            RepositoriesService repositoryService = repositoriesModule.getRepositoryService();
            repositoriesServiceReference.set((Object)repositoryService);
            SnapshotsService snapshotsService = new SnapshotsService(settings, clusterService, clusterModule.getIndexNameExpressionResolver(), repositoryService, transportService, actionModule.getActionFilters(), remoteStorePinnedTimestampService, remoteStoreSettings);
            SnapshotShardsService snapshotShardsService = new SnapshotShardsService(settings, clusterService, repositoryService, transportService, indicesService);
            TransportNodesSnapshotsStatus nodesSnapshotsStatus = new TransportNodesSnapshotsStatus(threadPool, clusterService, transportService, snapshotShardsService, actionModule.getActionFilters());
            RestoreService restoreService = new RestoreService(clusterService, repositoryService, clusterModule.getAllocationService(), metadataCreateIndexService, metadataIndexUpgradeService, shardLimitValidator, indicesService, clusterInfoService::getClusterInfo, new FileCacheSettings(settings, clusterService.getClusterSettings())::getRemoteDataRatio);
            RemoteStoreRestoreService remoteStoreRestoreService = new RemoteStoreRestoreService(clusterService, clusterModule.getAllocationService(), metadataCreateIndexService, metadataIndexUpgradeService, shardLimitValidator, remoteClusterStateService);
            DiskThresholdMonitor diskThresholdMonitor = new DiskThresholdMonitor(settings, clusterService::state, clusterService.getClusterSettings(), this.client, threadPool::relativeTimeInMillis, rerouteService, new FileCacheSettings(settings, clusterService.getClusterSettings())::getRemoteDataRatio);
            clusterInfoService.addListener(diskThresholdMonitor::onNewInfo);
            Discovery discovery = clusterless ? new LocalDiscovery(transportService, clusterService.getClusterApplierService()) : new DiscoveryModule(settings, threadPool, transportService, namedWriteableRegistry, networkService, clusterService.getClusterManagerService(), clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class), clusterModule.getAllocationService(), this.environment.configDir(), gatewayMetaState, rerouteService, fsHealthService, persistedStateRegistry, remoteStoreNodeService, clusterManagerMetrics, remoteClusterStateService).getDiscovery();
            SearchPipelineService searchPipelineService = new SearchPipelineService(clusterService, threadPool, this.environment, scriptService, analysisModule.getAnalysisRegistry(), xContentRegistry, namedWriteableRegistry, this.pluginsService.filterPlugins(SearchPipelinePlugin.class), this.client);
            TaskCancellationMonitoringSettings taskCancellationMonitoringSettings = new TaskCancellationMonitoringSettings(settings, clusterService.getClusterSettings());
            TaskCancellationMonitoringService taskCancellationMonitoringService = new TaskCancellationMonitoringService(threadPool, transportService.getTaskManager(), taskCancellationMonitoringSettings);
            this.nodeService = new NodeService(settings, threadPool, monitorService, discovery, transportService, indicesService, this.pluginsService, circuitBreakerService, scriptService, httpServerTransport, ingestService, clusterService, settingsModule.getSettingsFilter(), responseCollectorService, searchTransportService, indexingPressureService, searchModule.getValuesSourceRegistry().getUsageService(), searchBackpressureService, searchPipelineService, this.fileCache, taskCancellationMonitoringService, resourceUsageCollectorService, segmentReplicationStatsTracker, repositoryService, admissionControlService, cacheService);
            if (FeatureFlags.isEnabled(FeatureFlags.ARROW_STREAMS_SETTING)) {
                List<StreamManagerPlugin> streamManagerPlugins = this.pluginsService.filterPlugins(StreamManagerPlugin.class);
                List<StreamManager> streamManagers = streamManagerPlugins.stream().map(StreamManagerPlugin::getStreamManager).filter(Optional::isPresent).map(Optional::get).toList();
                if (streamManagers.size() > 1) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Only one StreamManagerPlugin can be installed. Found: %d", streamManagerPlugins.size()));
                }
                if (!streamManagers.isEmpty()) {
                    StreamManager streamManager = streamManagers.getFirst();
                    streamManagerPlugins.forEach(plugin -> plugin.onStreamManagerInitialized(streamManager));
                }
            }
            SearchService searchService = this.newSearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, searchModule.getQueryPhase(), searchModule.getFetchPhase(), responseCollectorService, circuitBreakerService, searchModule.getIndexSearcherExecutor(threadPool), taskResourceTrackingService, searchModule.getConcurrentSearchRequestDeciderFactories(), searchModule.getPluginProfileMetricsProviders());
            List<PersistentTasksExecutor<?>> tasksExecutors = this.pluginsService.filterPlugins(PersistentTaskPlugin.class).stream().map(p -> p.getPersistentTasksExecutor(clusterService, threadPool, this.client, settingsModule, clusterModule.getIndexNameExpressionResolver())).flatMap(Collection::stream).collect(Collectors.toList());
            Optional taskManagerClientOptional = FeatureFlags.isEnabled("opensearch.experimental.feature.task.background.enabled") ? this.pluginsService.filterPlugins(TaskManagerClientPlugin.class).stream().map(plugin -> plugin.getTaskManagerClient(this.client, clusterService, threadPool)).findFirst() : Optional.empty();
            PersistentTasksExecutorRegistry registry = new PersistentTasksExecutorRegistry(tasksExecutors);
            PersistentTasksClusterService persistentTasksClusterService = new PersistentTasksClusterService(settings, registry, clusterService, threadPool);
            resourcesToClose.add(persistentTasksClusterService);
            PersistentTasksService persistentTasksService = new PersistentTasksService(clusterService, threadPool, this.client);
            this.mergedSegmentWarmerFactory = new MergedSegmentWarmerFactory(transportService, recoverySettings, clusterService);
            MappingTransformerRegistry mappingTransformerRegistry = new MappingTransformerRegistry(mapperPlugins, xContentRegistry);
            modules.add(b -> {
                b.bind(Node.class).toInstance(this);
                b.bind(NodeService.class).toInstance(this.nodeService);
                b.bind(NamedXContentRegistry.class).toInstance(xContentRegistry);
                b.bind(PluginsService.class).toInstance(this.pluginsService);
                b.bind(Client.class).toInstance(this.client);
                b.bind(NodeClient.class).toInstance(this.client);
                b.bind(Environment.class).toInstance(this.environment);
                b.bind(ExtensionsManager.class).toInstance(this.extensionsManager);
                b.bind(ThreadPool.class).toInstance(threadPool);
                b.bind(NodeEnvironment.class).toInstance(this.nodeEnvironment);
                b.bind(ResourceWatcherService.class).toInstance(resourceWatcherService);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(PageCacheRecycler.class).toInstance(pageCacheRecycler);
                b.bind(ScriptService.class).toInstance(scriptService);
                b.bind(AnalysisRegistry.class).toInstance(analysisModule.getAnalysisRegistry());
                b.bind(IngestService.class).toInstance(ingestService);
                b.bind(SearchPipelineService.class).toInstance(searchPipelineService);
                b.bind(IndexingPressureService.class).toInstance(indexingPressureService);
                b.bind(TaskResourceTrackingService.class).toInstance(taskResourceTrackingService);
                b.bind(SearchBackpressureService.class).toInstance(searchBackpressureService);
                b.bind(WorkloadGroupService.class).toInstance(workloadGroupService);
                b.bind(AdmissionControlService.class).toInstance(admissionControlService);
                b.bind(UsageService.class).toInstance(usageService);
                b.bind(AggregationUsageService.class).toInstance(searchModule.getValuesSourceRegistry().getUsageService());
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
                b.bind(MetadataUpgrader.class).toInstance(metadataUpgrader);
                b.bind(MetaStateService.class).toInstance(metaStateService);
                b.bind(PersistedClusterStateService.class).toInstance(lucenePersistedStateFactory);
                b.bind(IndicesService.class).toInstance(indicesService);
                b.bind(RemoteStoreStatsTrackerFactory.class).toInstance(this.remoteStoreStatsTrackerFactory);
                b.bind(AliasValidator.class).toInstance(aliasValidator);
                b.bind(MetadataCreateIndexService.class).toInstance(metadataCreateIndexService);
                b.bind(AwarenessReplicaBalance.class).toInstance(awarenessReplicaBalance);
                b.bind(MetadataCreateDataStreamService.class).toInstance(metadataCreateDataStreamService);
                b.bind(ViewService.class).toInstance(viewService);
                b.bind(SearchService.class).toInstance(searchService);
                b.bind(SearchTransportService.class).toInstance(searchTransportService);
                if (streamSearchTransportService.isPresent()) {
                    b.bind(StreamSearchTransportService.class).toInstance((StreamSearchTransportService)streamSearchTransportService.get());
                } else {
                    b.bind(StreamSearchTransportService.class).toProvider(Providers.of(null));
                }
                b.bind(SearchPhaseController.class).toInstance(new SearchPhaseController(namedWriteableRegistry, searchService::aggReduceContextBuilder));
                b.bind(Transport.class).toInstance(transport);
                b.bind(TransportService.class).toInstance(transportService);
                if (streamTransportService.isPresent()) {
                    b.bind(StreamTransportService.class).toInstance((StreamTransportService)streamTransportService.get());
                } else {
                    b.bind(StreamTransportService.class).toProvider(Providers.of(null));
                }
                b.bind(NetworkService.class).toInstance(networkService);
                b.bind(UpdateHelper.class).toInstance(new UpdateHelper(scriptService));
                b.bind(MetadataIndexUpgradeService.class).toInstance(metadataIndexUpgradeService);
                b.bind(ClusterInfoService.class).toInstance(clusterInfoService);
                b.bind(SnapshotsInfoService.class).toInstance(snapshotsInfoService);
                b.bind(GatewayMetaState.class).toInstance(gatewayMetaState);
                b.bind(Discovery.class).toInstance(discovery);
                b.bind(RemoteStoreSettings.class).toInstance(remoteStoreSettings);
                b.bind(PeerRecoverySourceService.class).toInstance(new PeerRecoverySourceService(transportService, indicesService, recoverySettings));
                b.bind(PeerRecoveryTargetService.class).toInstance(new PeerRecoveryTargetService(threadPool, transportService, recoverySettings, clusterService));
                b.bind(SegmentReplicationTargetService.class).toInstance(new SegmentReplicationTargetService(threadPool, recoverySettings, transportService, new SegmentReplicationSourceFactory(transportService, recoverySettings, clusterService), indicesService, clusterService, segmentReplicator));
                b.bind(SegmentReplicationSourceService.class).toInstance(new SegmentReplicationSourceService(indicesService, transportService, recoverySettings));
                b.bind(HttpServerTransport.class).toInstance(httpServerTransport);
                pluginComponents.stream().forEach(p -> b.bind(p.getClass()).toInstance(p));
                b.bind(PersistentTasksService.class).toInstance(persistentTasksService);
                b.bind(PersistentTasksClusterService.class).toInstance(persistentTasksClusterService);
                b.bind(PersistentTasksExecutorRegistry.class).toInstance(registry);
                b.bind(RepositoriesService.class).toInstance(repositoryService);
                b.bind(SnapshotsService.class).toInstance(snapshotsService);
                b.bind(SnapshotShardsService.class).toInstance(snapshotShardsService);
                b.bind(TransportNodesSnapshotsStatus.class).toInstance(nodesSnapshotsStatus);
                b.bind(RestoreService.class).toInstance(restoreService);
                b.bind(RemoteStoreRestoreService.class).toInstance(remoteStoreRestoreService);
                b.bind(RerouteService.class).toInstance(rerouteService);
                b.bind(ShardLimitValidator.class).toInstance(shardLimitValidator);
                b.bind(FsHealthService.class).toInstance(fsHealthService);
                b.bind(NodeResourceUsageTracker.class).toInstance(nodeResourceUsageTracker);
                b.bind(ResourceUsageCollectorService.class).toInstance(resourceUsageCollectorService);
                b.bind(SystemIndices.class).toInstance(systemIndices);
                b.bind(IdentityService.class).toInstance(identityService);
                b.bind(Tracer.class).toInstance(this.tracer);
                b.bind(SearchRequestStats.class).toInstance(searchRequestStats);
                b.bind(SearchRequestSlowLog.class).toInstance(searchRequestSlowLog);
                b.bind(MetricsRegistry.class).toInstance(this.metricsRegistry);
                b.bind(RemoteClusterStateService.class).toProvider(() -> remoteClusterStateService);
                b.bind(RemoteIndexPathUploader.class).toProvider(() -> remoteIndexPathUploader);
                b.bind(RemoteStorePinnedTimestampService.class).toProvider(() -> remoteStorePinnedTimestampService);
                b.bind(RemoteClusterStateCleanupManager.class).toProvider(() -> remoteClusterStateCleanupManager);
                b.bind(PersistedStateRegistry.class).toInstance(persistedStateRegistry);
                b.bind(SegmentReplicationStatsTracker.class).toInstance(segmentReplicationStatsTracker);
                b.bind(SearchRequestOperationsCompositeListenerFactory.class).toInstance(searchRequestOperationsCompositeListenerFactory);
                b.bind(SegmentReplicator.class).toInstance(segmentReplicator);
                b.bind(MergedSegmentWarmerFactory.class).toInstance(this.mergedSegmentWarmerFactory);
                b.bind(MappingTransformerRegistry.class).toInstance(mappingTransformerRegistry);
                b.bind(AutoForceMergeManager.class).toInstance(this.autoForceMergeManager);
                if (FeatureFlags.isEnabled("opensearch.experimental.feature.merged_segment_warmer.enabled")) {
                    if (RemoteStoreNodeAttribute.isRemoteDataAttributePresent(settings)) {
                        b.bind(MergedSegmentPublisher.PublishAction.class).to(RemoteStorePublishMergedSegmentAction.class).asEagerSingleton();
                    } else {
                        b.bind(MergedSegmentPublisher.PublishAction.class).to(PublishMergedSegmentAction.class).asEagerSingleton();
                    }
                } else {
                    b.bind(MergedSegmentPublisher.PublishAction.class).toInstance((shard, checkpoint) -> {});
                }
                b.bind(MergedSegmentPublisher.class).asEagerSingleton();
                taskManagerClientOptional.ifPresent(value -> b.bind(TaskManagerClient.class).toInstance((TaskManagerClient)value));
            });
            this.injector = modules.createInjector();
            clusterModule.setExistingShardsAllocators(this.injector.getInstance(GatewayAllocator.class), this.injector.getInstance(ShardsBatchGatewayAllocator.class));
            List pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).collect(Collectors.toList());
            pluginLifecycleComponents.addAll(this.pluginsService.getGuiceServiceClasses().stream().map(this.injector::getInstance).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            resourcesToClose.add((Closeable)((Object)this.injector.getInstance(PeerRecoverySourceService.class)));
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            ActionModule.DynamicActionRegistry dynamicActionRegistry = actionModule.getDynamicActionRegistry();
            dynamicActionRegistry.registerUnmodifiableActionMap(this.injector.getInstance(new Key<Map<ActionType, TransportAction>>(this){}));
            this.client.initialize(dynamicActionRegistry, () -> clusterService.localNode().getId(), transportService.getRemoteClusterService(), namedWriteableRegistry);
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.logger.debug("initializing HTTP handlers ...");
            actionModule.initRestHandlers(() -> clusterService.state().nodes());
            this.logger.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new OpenSearchException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    protected TransportService newTransportService(Settings settings, Transport transport, @Nullable Transport streamTransport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        return new TransportService(settings, transport, streamTransport, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, tracer);
    }

    public Settings settings() {
        return this.environment.settings();
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        GatewayMetaState gatewayMetaState;
        TransportService transportService;
        Discovery discovery;
        StreamTransportService streamTransportService;
        ClusterService clusterService;
        block23: {
            RemoteStorePinnedTimestampService remoteStorePinnedTimestampService;
            RemoteIndexPathUploader remoteIndexPathUploader;
            if (!this.lifecycle.moveToStarted()) {
                return this;
            }
            this.logger.info("starting ...");
            this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
            this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
            this.injector.getInstance(IndicesService.class).start();
            this.injector.getInstance(IndicesClusterStateService.class).start();
            this.injector.getInstance(SnapshotsService.class).start();
            this.injector.getInstance(SnapshotShardsService.class).start();
            this.injector.getInstance(RepositoriesService.class).start();
            this.injector.getInstance(SearchService.class).start();
            this.injector.getInstance(FsHealthService.class).start();
            this.injector.getInstance(NodeResourceUsageTracker.class).start();
            this.injector.getInstance(ResourceUsageCollectorService.class).start();
            this.nodeService.getMonitorService().start();
            this.nodeService.getSearchBackpressureService().start();
            this.nodeService.getTaskCancellationMonitoringService().start();
            this.injector.getInstance(WorkloadGroupService.class).start();
            clusterService = this.injector.getInstance(ClusterService.class);
            NodeConnectionsService nodeConnectionsService = this.injector.getInstance(NodeConnectionsService.class);
            nodeConnectionsService.start();
            clusterService.setNodeConnectionsService(nodeConnectionsService);
            streamTransportService = this.injector.getInstance(StreamTransportService.class);
            if (streamTransportService != null) {
                StreamNodeConnectionsService streamNodeConnectionsService = this.injector.getInstance(StreamNodeConnectionsService.class);
                streamNodeConnectionsService.start();
                clusterService.setStreamNodeConnectionsService(streamNodeConnectionsService);
            }
            this.injector.getInstance(GatewayService.class).start();
            discovery = this.injector.getInstance(Discovery.class);
            discovery.setNodeConnectionsService(nodeConnectionsService);
            clusterService.getClusterManagerService().setClusterStatePublisher(discovery);
            transportService = this.injector.getInstance(TransportService.class);
            transportService.getTaskManager().setTaskResultsService(this.injector.getInstance(TaskResultsService.class));
            transportService.getTaskManager().setTaskCancellationService(new TaskCancellationService(transportService));
            TaskResourceTrackingService taskResourceTrackingService = this.injector.getInstance(TaskResourceTrackingService.class);
            transportService.getTaskManager().setTaskResourceTrackingService(taskResourceTrackingService);
            this.runnableTaskListener.set(taskResourceTrackingService);
            if (streamTransportService != null) {
                streamTransportService.start();
            }
            transportService.start();
            assert (this.localNodeFactory.getNode() != null);
            assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
            this.injector.getInstance(PeerRecoverySourceService.class).start();
            this.injector.getInstance(SegmentReplicationTargetService.class).start();
            this.injector.getInstance(SegmentReplicationSourceService.class).start();
            RemoteClusterStateService remoteClusterStateService = this.injector.getInstance(RemoteClusterStateService.class);
            if (remoteClusterStateService != null) {
                remoteClusterStateService.start();
            }
            if ((remoteIndexPathUploader = this.injector.getInstance(RemoteIndexPathUploader.class)) != null) {
                remoteIndexPathUploader.start();
            }
            if ((remoteStorePinnedTimestampService = this.injector.getInstance(RemoteStorePinnedTimestampService.class)) != null) {
                remoteStorePinnedTimestampService.start();
            }
            gatewayMetaState = this.injector.getInstance(GatewayMetaState.class);
            gatewayMetaState.start(this.settings(), transportService, clusterService, this.injector.getInstance(MetaStateService.class), this.injector.getInstance(MetadataIndexUpgradeService.class), this.injector.getInstance(MetadataUpgrader.class), this.injector.getInstance(PersistedClusterStateService.class), this.injector.getInstance(RemoteClusterStateService.class), this.injector.getInstance(PersistedStateRegistry.class), this.injector.getInstance(RemoteStoreRestoreService.class));
            if (Assertions.ENABLED) {
                try {
                    assert (((Manifest)this.injector.getInstance(MetaStateService.class).loadFullState().v1()).isEmpty());
                    NodeMetadata nodeMetadata = NodeMetadata.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnvironment.nodeDataPaths());
                    assert (nodeMetadata != null);
                    assert (nodeMetadata.nodeVersion().equals((Object)Version.CURRENT));
                    assert (nodeMetadata.nodeId().equals(this.localNodeFactory.getNode().getId()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block23;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(new BootstrapContext(this.environment, onDiskMetadata), transportService.boundAddress(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getBootstrapChecks().stream()).collect(Collectors.toList()));
        clusterService.addStateApplier(transportService.getTaskManager());
        discovery.start();
        clusterService.start();
        this.autoForceMergeManager.start();
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        if (streamTransportService != null) {
            streamTransportService.acceptIncomingRequests();
        }
        discovery.startInitialJoin();
        final TimeValue initialStateTimeout = DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.get(this.settings());
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, this.logger, thread.getThreadContext());
            if (clusterState.nodes().getClusterManagerNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){
                    final /* synthetic */ Node this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        this.this$0.logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getClusterManagerNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new OpenSearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        this.injector.getInstance(HttpServerTransport.class).start();
        if (WRITE_PORTS_FILE_SETTING.get(this.settings()).booleanValue()) {
            TransportService transport = this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
        }
        this.logger.info("started");
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(plugin -> plugin.onNodeStarted(clusterService.localNode()));
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId(clusterService, this.injector.getInstance(ThreadPool.class).getThreadContext());
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        this.logger.info("stopping ...");
        this.injector.getInstance(ResourceWatcherService.class).close();
        this.injector.getInstance(HttpServerTransport.class).stop();
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(SnapshotShardsService.class).stop();
        this.injector.getInstance(RepositoriesService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(Discovery.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(NodeConnectionsService.class).stop();
        this.injector.getInstance(FsHealthService.class).stop();
        this.injector.getInstance(NodeResourceUsageTracker.class).stop();
        this.injector.getInstance(ResourceUsageCollectorService.class).stop();
        this.injector.getInstance(WorkloadGroupService.class).stop();
        this.nodeService.getMonitorService().stop();
        this.nodeService.getSearchBackpressureService().stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        StreamTransportService stc = this.injector.getInstance(StreamTransportService.class);
        if (stc != null) {
            stc.stop();
        }
        this.nodeService.getTaskCancellationMonitoringService().stop();
        this.autoForceMergeManager.stop();
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        this.injector.getInstance(IndicesService.class).stop();
        this.logger.info("stopped");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Object> toClose = new ArrayList<Object>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add((Closeable)((Object)this.injector.getInstance(HttpServerTransport.class)));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add((Closeable)((Object)this.injector.getInstance(SnapshotsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(SnapshotShardsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(RepositoriesService.class)));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close((Releasable)this.injector.getInstance(Client.class));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesClusterStateService.class)));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesService.class)));
        toClose.add(this.injector.getInstance(IndicesStore.class));
        toClose.add((Closeable)((Object)this.injector.getInstance(PeerRecoverySourceService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(SegmentReplicationSourceService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(SegmentReplicationTargetService.class)));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add((Closeable)((Object)this.injector.getInstance(ClusterService.class)));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add((Closeable)((Object)this.injector.getInstance(NodeConnectionsService.class)));
        toClose.add(() -> stopWatch.stop().start("discovery"));
        toClose.add((Closeable)((Object)this.injector.getInstance(Discovery.class)));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add((Object)this.nodeService.getMonitorService());
        toClose.add(this.nodeService.getSearchBackpressureService());
        toClose.add(() -> stopWatch.stop().start("fsHealth"));
        toClose.add((Closeable)((Object)this.injector.getInstance(FsHealthService.class)));
        toClose.add(() -> stopWatch.stop().start("resource_usage_tracker"));
        toClose.add((Closeable)((Object)this.injector.getInstance(NodeResourceUsageTracker.class)));
        toClose.add(() -> stopWatch.stop().start("resource_usage_collector"));
        toClose.add((Closeable)((Object)this.injector.getInstance(ResourceUsageCollectorService.class)));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add((Closeable)((Object)this.injector.getInstance(GatewayService.class)));
        toClose.add(() -> stopWatch.stop().start("search"));
        toClose.add((Closeable)((Object)this.injector.getInstance(SearchService.class)));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add((Closeable)((Object)this.injector.getInstance(TransportService.class)));
        StreamTransportService stc = this.injector.getInstance(StreamTransportService.class);
        if (stc != null) {
            toClose.add(stc);
        }
        toClose.add(this.nodeService.getTaskCancellationMonitoringService());
        toClose.add(this.injector.getInstance(RemoteStorePinnedTimestampService.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("script"));
        toClose.add(this.injector.getInstance(ScriptService.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdown());
        toClose.add(() -> stopWatch.stop().start("gateway_meta_state"));
        toClose.add(this.injector.getInstance(GatewayMetaState.class));
        toClose.add(() -> stopWatch.stop().start("node_environment"));
        toClose.add(this.injector.getInstance(NodeEnvironment.class));
        toClose.add(() -> ((StopWatch)stopWatch).stop());
        if (FeatureFlags.isEnabled("opensearch.experimental.feature.telemetry.enabled")) {
            toClose.add((Closeable)this.injector.getInstance(Tracer.class));
            toClose.add((Closeable)this.injector.getInstance(MetricsRegistry.class));
        }
        if (this.logger.isTraceEnabled()) {
            toClose.add(() -> this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint()));
        }
        this.autoForceMergeManager.stop();
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate(threadPool, timeout, timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsDir().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format((InetSocketAddress)new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsDir().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    public static CircuitBreakerService createCircuitBreakerService(Settings settings, List<BreakerSettings> breakerSettings, ClusterSettings clusterSettings) {
        String type = BREAKER_TYPE_KEY.get(settings);
        if (type.equals("hierarchy")) {
            return new HierarchyCircuitBreakerService(settings, breakerSettings, clusterSettings);
        }
        if (type.equals("none")) {
            return new NoneCircuitBreakerService();
        }
        throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
    }

    BigArrays createBigArrays(PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    PageCacheRecycler createPageCacheRecycler(Settings settings) {
        return new PageCacheRecycler(settings);
    }

    protected SearchService newSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, QueryPhase queryPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, Executor indexSearcherExecutor, TaskResourceTrackingService taskResourceTrackingService, Collection<ConcurrentSearchRequestDecider.Factory> concurrentSearchDeciderFactories, List<SearchPlugin.ProfileMetricsProvider> pluginProfilers) {
        return new SearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, queryPhase, fetchPhase, responseCollectorService, circuitBreakerService, indexSearcherExecutor, taskResourceTrackingService, concurrentSearchDeciderFactories, pluginProfilers);
    }

    protected ScriptService newScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts) {
        return new ScriptService(settings, engines, contexts);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings());
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        InternalClusterInfoService service = new InternalClusterInfoService(settings, clusterService, threadPool, client);
        if (DiscoveryNode.isClusterManagerNode(settings)) {
            clusterService.addListener(service);
        }
        return service;
    }

    protected HttpServerTransport newHttpTransport(NetworkModule networkModule) {
        return networkModule.getHttpServerTransportSupplier().get();
    }

    protected List<AuxTransport> newAuxTransports(NetworkModule networkModule) {
        return networkModule.getAuxServerTransportList();
    }

    private void initializeFileCache(Settings settings, CircuitBreaker circuitBreaker) throws IOException {
        if (!DiscoveryNode.isWarmNode(settings)) {
            return;
        }
        String capacityRaw = NODE_SEARCH_CACHE_SIZE_SETTING.get(settings);
        this.logger.info("cache size [{}]", (Object)capacityRaw);
        if (capacityRaw.equals(ZERO)) {
            throw new SettingsException("Unable to initialize the " + DiscoveryNodeRole.WARM_ROLE.roleName() + "-" + DiscoveryNodeRole.DATA_ROLE.roleName() + " node: Missing value for configuration " + NODE_SEARCH_CACHE_SIZE_SETTING.getKey());
        }
        NodeEnvironment.NodePath fileCacheNodePath = this.nodeEnvironment.fileCacheNodePath();
        long totalSpace = (Long)ExceptionsHelper.catchAsRuntimeException(() -> FsProbe.getTotalSize(fileCacheNodePath));
        long capacity = Node.calculateFileCacheSize(capacityRaw, totalSpace);
        if (capacity <= 0L || totalSpace <= capacity) {
            throw new SettingsException("Cache size must be larger than zero and less than total capacity");
        }
        this.fileCache = FileCacheFactory.createConcurrentLRUFileCache(capacity, circuitBreaker);
        fileCacheNodePath.fileCacheReservedSize = new ByteSizeValue(this.fileCache.capacity(), ByteSizeUnit.BYTES);
        ForkJoinPool loadFileCacheThreadpool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), CustomForkJoinWorkerThread::new, null, false);
        SetOnce exception = new SetOnce();
        ForkJoinTask<Void> fileCacheFilesLoadTask = loadFileCacheThreadpool.submit(new FileCache.LoadTask(fileCacheNodePath.fileCachePath, this.fileCache, (SetOnce<UncheckedIOException>)exception));
        if (DiscoveryNode.isDedicatedWarmNode(settings)) {
            ForkJoinTask<Void> indicesFilesLoadTask = loadFileCacheThreadpool.submit(new FileCache.LoadTask(fileCacheNodePath.indicesPath, this.fileCache, (SetOnce<UncheckedIOException>)exception));
            indicesFilesLoadTask.join();
        }
        fileCacheFilesLoadTask.join();
        loadFileCacheThreadpool.shutdown();
        if (exception.get() != null) {
            this.logger.error("File cache initialization failed.", (Throwable)exception.get());
            throw new OpenSearchException((Throwable)exception.get());
        }
    }

    private static long calculateFileCacheSize(String capacityRaw, long totalSpace) {
        try {
            RatioValue ratioValue = RatioValue.parseRatioValue(capacityRaw);
            return Math.round((double)totalSpace * ratioValue.getAsRatio());
        }
        catch (OpenSearchParseException e) {
            try {
                return ByteSizeValue.parseBytesSizeValue((String)capacityRaw, (String)NODE_SEARCH_CACHE_SIZE_SETTING.getKey()).getBytes();
            }
            catch (OpenSearchParseException ex) {
                ex.addSuppressed((Throwable)e);
                throw ex;
            }
        }
    }

    private static String validateFileCacheSize(String capacityRaw) {
        Node.calculateFileCacheSize(capacityRaw, 0L);
        return capacityRaw;
    }

    public FileCache fileCache() {
        return this.fileCache;
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;
        private final RemoteStoreNodeService remoteStoreNodeService;

        private LocalNodeFactory(Settings settings, String persistentNodeId, RemoteStoreNodeService remoteStoreNodeService) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
            this.remoteStoreNodeService = remoteStoreNodeService;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            DiscoveryNode discoveryNode = DiscoveryNode.createLocal(this.settings, boundTransportAddress.publishAddress(), this.persistentNodeId);
            if (RemoteStoreNodeAttribute.isRemoteStoreAttributePresent(this.settings)) {
                this.remoteStoreNodeService.createAndVerifyRepositories(discoveryNode);
            }
            this.localNode.set((Object)discoveryNode);
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }

    public static class DiscoverySettings {
        public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    }

    public static class CustomForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        public CustomForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool);
            this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }
}

