/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.transport.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.transport.request.GetLocksRequest;
import org.opensearch.jobscheduler.transport.response.GetLocksResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportGetAllLocksAction
extends HandledTransportAction<GetLocksRequest, GetLocksResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetAllLocksAction.class);
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetAllLocksAction(TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool) {
        super("cluster:admin/opensearch/jobscheduler/locks", transportService, actionFilters, GetLocksRequest::new);
        this.client = client;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, GetLocksRequest request, ActionListener<GetLocksResponse> listener) {
        if (request.getLockId() != null) {
            this.getLockById(request.getLockId(), (ActionListener<Map<String, LockModel>>)ActionListener.wrap(locks -> listener.onResponse((Object)new GetLocksResponse((Map<String, LockModel>)locks)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.getAllLocks((ActionListener<Map<String, LockModel>>)ActionListener.wrap(locks -> listener.onResponse((Object)new GetLocksResponse((Map<String, LockModel>)locks)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void getLockById(final String lockId, final ActionListener<Map<String, LockModel>> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            String[] parts = lockId.split("-", 2);
            if (parts.length != 2) {
                listener.onFailure((Exception)new IllegalArgumentException("Lock ID must be in format 'index-jobid'"));
                return;
            }
            String jobIndexName = parts[0];
            String jobId = parts[1];
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-job-scheduler-lock"});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"job_index_name", (String)jobIndexName)).must((QueryBuilder)QueryBuilders.termQuery((String)"job_id", (String)jobId)));
            searchRequest.source(searchSourceBuilder);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    HashMap result = new HashMap();
                    searchResponse.getHits().forEach(hit -> {
                        try {
                            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            parser.nextToken();
                            LockModel lock = LockModel.parse((XContentParser)parser, (long)hit.getSeqNo(), (long)hit.getPrimaryTerm());
                            result.put(lock.getLockId(), lock);
                        }
                        catch (IOException e) {
                            log.error("Error parsing lock from search hit", (Throwable)e);
                        }
                    });
                    listener.onResponse(result);
                }

                public void onFailure(Exception e) {
                    log.debug("Error in finding lock by ID {}", (Object)lockId, (Object)e);
                    listener.onResponse(new HashMap());
                }
            });
        }
    }

    private void getAllLocks(final ActionListener<Map<String, LockModel>> listener) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-job-scheduler-lock"});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(1000);
            searchRequest.scroll(TimeValue.timeValueMinutes((long)1L));
            searchRequest.source(searchSourceBuilder);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ TransportGetAllLocksAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse searchResponse) {
                    HashMap<String, LockModel> allLocks = new HashMap<String, LockModel>();
                    String scrollId = searchResponse.getScrollId();
                    this.this$0.processScrollResults(scrollId, searchResponse, allLocks, (ActionListener<Map<String, LockModel>>)listener);
                }

                public void onFailure(Exception e) {
                    log.debug("Error in obtaining all locks", (Throwable)e);
                    listener.onResponse(new HashMap());
                }
            });
        }
    }

    private void processScrollResults(final String scrollId, SearchResponse response, final Map<String, LockModel> allLocks, final ActionListener<Map<String, LockModel>> listener) {
        response.getHits().forEach(hit -> {
            try {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                parser.nextToken();
                LockModel lock = LockModel.parse((XContentParser)parser, (long)hit.getSeqNo(), (long)hit.getPrimaryTerm());
                allLocks.put(lock.getLockId(), lock);
            }
            catch (IOException e) {
                log.error("Error parsing lock from search hit", (Throwable)e);
            }
        });
        if (response.getHits().getHits().length > 0) {
            this.client.searchScroll(new SearchScrollRequest(scrollId).scroll(TimeValue.timeValueMinutes((long)1L)), (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ TransportGetAllLocksAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse searchResponse) {
                    this.this$0.processScrollResults(searchResponse.getScrollId(), searchResponse, allLocks, (ActionListener<Map<String, LockModel>>)listener);
                }

                public void onFailure(Exception e) {
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                    clearScrollRequest.addScrollId(scrollId);
                    this.this$0.client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> {}, ex -> log.warn("Failed to clear scroll context", (Throwable)ex)));
                    log.debug("Error while scrolling for locks", (Throwable)e);
                    listener.onResponse((Object)allLocks);
                }
            });
        } else {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            this.client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> {}, e -> log.warn("Failed to clear scroll context", (Throwable)e)));
            listener.onResponse(allLocks);
        }
    }
}

