/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.Set;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;

public interface ActionPrivileges {
    public static final ActionPrivileges EMPTY = new ActionPrivileges(){

        @Override
        public PrivilegesEvaluatorResponse hasClusterPrivilege(PrivilegesEvaluationContext context, String action) {
            return PrivilegesEvaluatorResponse.insufficient(action).reason("User has no privileges");
        }

        @Override
        public PrivilegesEvaluatorResponse hasAnyClusterPrivilege(PrivilegesEvaluationContext context, Set<String> actions) {
            return PrivilegesEvaluatorResponse.insufficient("any of " + String.valueOf(actions)).reason("User has no privileges");
        }

        @Override
        public PrivilegesEvaluatorResponse hasExplicitClusterPrivilege(PrivilegesEvaluationContext context, String action) {
            return PrivilegesEvaluatorResponse.insufficient(action).reason("User has no privileges");
        }

        @Override
        public PrivilegesEvaluatorResponse hasIndexPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices) {
            return PrivilegesEvaluatorResponse.insufficient("all of " + String.valueOf(actions)).reason("User has no privileges");
        }

        @Override
        public PrivilegesEvaluatorResponse hasExplicitIndexPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices) {
            return PrivilegesEvaluatorResponse.insufficient("all of " + String.valueOf(actions)).reason("User has no privileges");
        }
    };

    public PrivilegesEvaluatorResponse hasClusterPrivilege(PrivilegesEvaluationContext var1, String var2);

    public PrivilegesEvaluatorResponse hasAnyClusterPrivilege(PrivilegesEvaluationContext var1, Set<String> var2);

    public PrivilegesEvaluatorResponse hasExplicitClusterPrivilege(PrivilegesEvaluationContext var1, String var2);

    public PrivilegesEvaluatorResponse hasIndexPrivilege(PrivilegesEvaluationContext var1, Set<String> var2, IndexResolverReplacer.Resolved var3);

    public PrivilegesEvaluatorResponse hasExplicitIndexPrivilege(PrivilegesEvaluationContext var1, Set<String> var2, IndexResolverReplacer.Resolved var3);
}

