/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.dlic.rest.api.ssl.CertificateInfo;
import org.opensearch.security.ssl.config.CertType;

public class CertificatesInfo
implements Writeable,
ToXContent {
    private final Map<String, List<CertificateInfo>> certificates;

    public CertificatesInfo(Map<String, List<CertificateInfo>> certificates) {
        this.certificates = certificates;
    }

    public CertificatesInfo(StreamInput in) throws IOException {
        this.certificates = in.getVersion().onOrAfter(Version.V_3_2_0) ? in.readMap(StreamInput::readString, listIn -> listIn.readList(CertificateInfo::new)) : in.readMap(streamIn -> switch ((CertType.LegacyCertType)streamIn.readEnum(CertType.LegacyCertType.class)) {
            default -> throw new MatchException(null, null);
            case CertType.LegacyCertType.HTTP -> CertType.HTTP.id();
            case CertType.LegacyCertType.TRANSPORT -> CertType.TRANSPORT.id();
            case CertType.LegacyCertType.TRANSPORT_CLIENT -> CertType.TRANSPORT_CLIENT.id();
        }, listIn -> listIn.readList(CertificateInfo::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
            out.writeMap(this.certificates, StreamOutput::writeString, StreamOutput::writeList);
        } else {
            Set<String> legacyCerts = this.certificates.keySet();
            legacyCerts.retainAll(List.of(CertType.HTTP.id(), CertType.TRANSPORT.id(), CertType.TRANSPORT_CLIENT.id()));
            out.writeVInt(legacyCerts.size());
            for (String certId : legacyCerts) {
                if (CertType.HTTP.id().equals(certId)) {
                    out.writeEnum((Enum)CertType.LegacyCertType.HTTP);
                } else if (CertType.TRANSPORT.id().equals(certId)) {
                    out.writeEnum((Enum)CertType.LegacyCertType.TRANSPORT);
                } else if (CertType.TRANSPORT_CLIENT.id().equals(certId)) {
                    out.writeEnum((Enum)CertType.LegacyCertType.TRANSPORT_CLIENT);
                }
                out.writeList(this.certificates.get(certId));
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("certificates");
        for (Map.Entry<String, List<CertificateInfo>> entry : this.certificates.entrySet()) {
            builder.field(entry.getKey(), (Iterable)this.certificates.get(entry.getKey()));
        }
        return builder.endObject();
    }
}

