/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.JNodeAction;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.ZoomActions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = -3980354865216031972L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodeArea.class);
    public static final String SYNTAX_STYLE_SMALI = "text/smali";
    protected ContentPanel contentPanel;
    protected JNode node;

    public AbstractCodeArea(ContentPanel contentPanel, JNode node) {
        this.contentPanel = contentPanel;
        this.node = Objects.requireNonNull(node);
        this.setMarkOccurrences(false);
        this.setEditable(false);
        this.setCodeFoldingEnabled(false);
        this.setFadeCurrentLineHighlight(true);
        this.setCloseCurlyBraces(true);
        this.setAntiAliasingEnabled(true);
        this.loadSettings();
        JadxSettings settings = contentPanel.getTabbedPane().getMainWindow().getSettings();
        this.setLineWrap(settings.isCodeAreaLineWrap());
        this.addWrapLineMenuAction(settings);
        this.addCaretActions();
        this.addFastCopyAction();
        ZoomActions.register((JComponent)((Object)this), settings, this::loadSettings);
    }

    private void addWrapLineMenuAction(final JadxSettings settings) {
        JPopupMenu popupMenu = this.getPopupMenu();
        popupMenu.addSeparator();
        final JCheckBoxMenuItem wrapItem = new JCheckBoxMenuItem(NLS.str("popup.line_wrap"), this.getLineWrap());
        wrapItem.setAction(new AbstractAction(NLS.str("popup.line_wrap")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean wrap = !AbstractCodeArea.this.getLineWrap();
                settings.setCodeAreaLineWrap(wrap);
                AbstractCodeArea.this.contentPanel.getTabbedPane().getOpenTabs().values().forEach(v -> {
                    if (v instanceof AbstractCodeContentPanel) {
                        AbstractCodeArea codeArea = ((AbstractCodeContentPanel)v).getCodeArea();
                        AbstractCodeArea.this.setCodeAreaLineWrap(codeArea, wrap);
                        if (v instanceof ClassCodeContentPanel) {
                            codeArea = ((ClassCodeContentPanel)v).getSmaliCodeArea();
                            AbstractCodeArea.this.setCodeAreaLineWrap(codeArea, wrap);
                        }
                    }
                });
                settings.sync();
            }
        });
        popupMenu.add(wrapItem);
        popupMenu.addPopupMenuListener(new DefaultPopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                wrapItem.setState(AbstractCodeArea.this.getLineWrap());
            }
        });
    }

    private void setCodeAreaLineWrap(AbstractCodeArea codeArea, boolean wrap) {
        codeArea.setLineWrap(wrap);
        if (codeArea.isVisible()) {
            codeArea.repaint();
        }
    }

    private void addCaretActions() {
        final Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(2);
        }
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                caret.setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                caret.setVisible(false);
            }
        });
        this.addCaretListener(new CaretListener(){
            int lastPos = -1;
            String lastText = "";

            @Override
            public void caretUpdate(CaretEvent e) {
                int pos = AbstractCodeArea.this.getCaretPosition();
                if (this.lastPos != pos) {
                    this.lastPos = pos;
                    this.lastText = AbstractCodeArea.this.highlightCaretWord(this.lastText, pos);
                }
            }
        });
    }

    private void addFastCopyAction() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67 && UiUtils.isCtrlDown(e) && StringUtils.isEmpty((String)AbstractCodeArea.this.getSelectedText())) {
                    UiUtils.copyToClipboard(AbstractCodeArea.this.getWordUnderCaret());
                }
            }
        });
    }

    private String highlightCaretWord(String lastText, int pos) {
        String text = this.getWordByPosition(pos);
        if (StringUtils.isEmpty((String)text)) {
            this.highlightAllMatches(null);
            lastText = "";
        } else if (!lastText.equals(text)) {
            this.highlightAllMatches(text);
            lastText = text;
        }
        return lastText;
    }

    @Nullable
    public String getWordUnderCaret() {
        return this.getWordByPosition(this.getCaretPosition());
    }

    @Nullable
    public String getWordByPosition(int pos) {
        try {
            Token token = this.modelToToken(pos);
            return AbstractCodeArea.getWordFromToken(token);
        }
        catch (Exception e) {
            LOG.error("Failed to get word at pos: {}", (Object)pos, (Object)e);
            return null;
        }
    }

    @Nullable
    private static String getWordFromToken(@Nullable Token token) {
        if (token == null) {
            return null;
        }
        switch (token.getType()) {
            case 0: 
            case 21: 
            case 22: 
            case 23: {
                return null;
            }
            case 20: {
                char ch;
                if (token.length() == 1 && ((ch = token.charAt(0)) == ';' || ch == '.')) {
                    return null;
                }
                return token.getLexeme();
            }
        }
        return token.getLexeme();
    }

    @NotNull
    public abstract ICodeInfo getCodeInfo();

    public abstract void load();

    public abstract void refresh();

    public static RSyntaxTextArea getDefaultArea(MainWindow mainWindow) {
        RSyntaxTextArea area = new RSyntaxTextArea();
        area.setEditable(false);
        area.setCodeFoldingEnabled(false);
        AbstractCodeArea.loadCommonSettings(mainWindow, area);
        return area;
    }

    public static void loadCommonSettings(MainWindow mainWindow, RSyntaxTextArea area) {
        area.setAntiAliasingEnabled(true);
        mainWindow.getEditorTheme().apply(area);
        JadxSettings settings = mainWindow.getSettings();
        area.setFont(settings.getFont());
    }

    public void loadSettings() {
        AbstractCodeArea.loadCommonSettings(this.contentPanel.getTabbedPane().getMainWindow(), this);
    }

    public void scrollToPos(int pos) {
        try {
            this.setCaretPosition(pos);
            this.centerCurrentLine();
            this.forceCurrentLineHighlightRepaint();
        }
        catch (Exception e) {
            LOG.warn("Can't scroll to position {}", (Object)pos, (Object)e);
        }
    }

    public void centerCurrentLine() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, (Component)((Object)this));
        if (viewport == null) {
            return;
        }
        try {
            Rectangle r = this.modelToView(this.getCaretPosition());
            if (r == null) {
                return;
            }
            int extentHeight = viewport.getExtentSize().height;
            Dimension viewSize = viewport.getViewSize();
            if (viewSize == null) {
                return;
            }
            int viewHeight = viewSize.height;
            int y = Math.max(0, r.y - extentHeight / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't center current line", (Throwable)e);
        }
    }

    private void highlightAllMatches(@Nullable String str) {
        SearchContext context = new SearchContext(str);
        context.setMarkAll(true);
        context.setMatchCase(true);
        context.setWholeWord(true);
        SearchEngine.markAll((RTextArea)this, (SearchContext)context);
    }

    public JumpPosition getCurrentPosition() {
        return new JumpPosition(this.node, this.getCaretPosition());
    }

    public int getLineStartFor(int pos) throws BadLocationException {
        return this.getLineStartOffset(this.getLineOfOffset(pos));
    }

    public String getLineAt(int pos) throws BadLocationException {
        return this.getLineText(this.getLineOfOffset(pos) + 1);
    }

    public String getLineText(int line) throws BadLocationException {
        int lineNum = line - 1;
        int startOffset = this.getLineStartOffset(lineNum);
        int endOffset = this.getLineEndOffset(lineNum);
        return this.getText(startOffset, endOffset - startOffset);
    }

    public ContentPanel getContentPanel() {
        return this.contentPanel;
    }

    public JNode getNode() {
        return this.node;
    }

    @Nullable
    public JClass getJClass() {
        if (this.node instanceof JClass) {
            return (JClass)this.node;
        }
        return null;
    }

    public boolean isDisposed() {
        return this.node == null;
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        this.node = null;
        this.contentPanel = null;
        try {
            void var4_12;
            void var4_10;
            this.setIgnoreRepaint(true);
            this.setText("");
            this.setEnabled(false);
            this.setSyntaxEditingStyle("text/plain");
            this.setLinkGenerator(null);
            for (MouseListener mouseListener : this.getMouseListeners()) {
                this.removeMouseListener(mouseListener);
            }
            for (EventListener eventListener : this.getMouseMotionListeners()) {
                this.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            JPopupMenu popupMenu = this.getPopupMenu();
            Object[] objectArray = popupMenu.getPopupMenuListeners();
            int n = objectArray.length;
            boolean bl = false;
            while (var4_10 < n) {
                PopupMenuListener popupMenuListener = objectArray[var4_10];
                popupMenu.removePopupMenuListener(popupMenuListener);
                ++var4_10;
            }
            objectArray = popupMenu.getComponents();
            n = objectArray.length;
            boolean bl2 = false;
            while (var4_12 < n) {
                Action action;
                Object component = objectArray[var4_12];
                if (component instanceof JMenuItem && (action = ((JMenuItem)component).getAction()) instanceof JNodeAction) {
                    ((JNodeAction)action).dispose();
                }
                ++var4_12;
            }
            popupMenu.removeAll();
        }
        catch (Throwable e) {
            LOG.debug("Error on code area dispose", e);
        }
    }

    public Dimension getPreferredSize() {
        try {
            return super.getPreferredSize();
        }
        catch (Exception e) {
            LOG.warn("Failed to calculate preferred size for code area", (Throwable)e);
            Dimension d = new Dimension(400, 400);
            Insets insets = this.getInsets();
            if (this.getColumns() != 0) {
                d.width = Math.max(d.width, this.getColumns() * this.getColumnWidth() + insets.left + insets.right);
            }
            if (this.getRows() != 0) {
                d.height = Math.max(d.height, this.getRows() * this.getRowHeight() + insets.top + insets.bottom);
            }
            return d;
        }
    }

    static {
        TokenMakerFactory tokenMakerFactory = TokenMakerFactory.getDefaultInstance();
        if (!(tokenMakerFactory instanceof AbstractTokenMakerFactory)) {
            throw new JadxRuntimeException("Unexpected TokenMakerFactory instance: " + tokenMakerFactory.getClass());
        }
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)tokenMakerFactory;
        atmf.putMapping(SYNTAX_STYLE_SMALI, "jadx.gui.ui.codearea.SmaliTokenMaker");
    }
}

