/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.SimpleEffect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ConditionalEffectInterpreter;", "", "dispatcher", "Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "<init>", "(Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;)V", "interpret", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "conditionalEffectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;", "resolution"})
public final class ConditionalEffectInterpreter {
    @NotNull
    private final ContractInterpretationDispatcher dispatcher;

    public ConditionalEffectInterpreter(@NotNull ContractInterpretationDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.dispatcher = dispatcher;
    }

    @Nullable
    public final ConditionalEffect interpret(@NotNull ConditionalEffectDeclaration conditionalEffectDeclaration) {
        Intrinsics.checkNotNullParameter((Object)conditionalEffectDeclaration, (String)"conditionalEffectDeclaration");
        ESEffect eSEffect = this.dispatcher.interpretEffect$resolution(conditionalEffectDeclaration.getEffect());
        SimpleEffect simpleEffect = eSEffect instanceof SimpleEffect ? (SimpleEffect)eSEffect : null;
        if (simpleEffect == null) {
            return null;
        }
        SimpleEffect effect = simpleEffect;
        ESExpression eSExpression = this.dispatcher.interpretCondition$resolution(conditionalEffectDeclaration.getCondition());
        if (eSExpression == null) {
            return null;
        }
        ESExpression condition = eSExpression;
        return new ConditionalEffect(condition, effect);
    }
}

