/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.CustomerGatewayDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeCustomerGateways
extends BaseCmd {
    public DescribeCustomerGateways(String[] args) {
        super("ec2dcgw", "ec2-describe-customer-gateways");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[ CUSTOMER_GATEWAY ... ] [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about your customer gateways. The CUSTOMER_GATEWAY");
        System.out.println("     parameters, if specified, are the IDs of a customer gateways to describe.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeCustomerGateways(this.getFilterMap(true), this.getNonOptions());
        for (CustomerGatewayDescription cgw : (List)rsp.getResponse()) {
            out.output(System.out, cgw);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DescribeCustomerGateways(args).invoke();
    }
}

