/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerowsbyhashset;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.Messages;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSet;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueRowsByHashSetMeta
extends BaseStepMeta
implements StepMetaInterface {
    private boolean storeValues;
    private String[] compareFields;

    public void setCompareFields(String[] compareField) {
        this.compareFields = compareField;
    }

    public boolean getStoreValues() {
        return this.storeValues;
    }

    public void setStoreValues(boolean storeValues) {
        this.storeValues = storeValues;
    }

    public String[] getCompareFields() {
        return this.compareFields;
    }

    public void allocate(int nrfields) {
        this.compareFields = new String[nrfields];
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        UniqueRowsByHashSetMeta retval = (UniqueRowsByHashSetMeta)super.clone();
        int nrfields = this.compareFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.getCompareFields()[i] = this.compareFields[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.storeValues = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"store_values"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.compareFields[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("UniqueRowsByHashSetMeta.Exception.UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.compareFields[i] = "field" + i;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      " + XMLHandler.addTagValue((String)"store_values", (boolean)this.storeValues));
        retval.append("    <fields>");
        for (int i = 0; i < this.compareFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.compareFields[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.storeValues = rep.getStepAttributeBoolean(id_step, "store_values");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.compareFields[i] = rep.getStepAttributeString(id_step, i, "field_name");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("UniqueRowsByHashSetMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            for (int i = 0; i < this.compareFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.compareFields[i]);
            }
        }
        catch (KettleException e) {
            throw new KettleException(Messages.getString("UniqueRowsByHashSetMeta.Exception.UnableToSaveStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, Messages.getString("UniqueRowsByHashSetMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, Messages.getString("UniqueRowsByHashSetMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new UniqueRowsByHashSet(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UniqueRowsByHashSetData();
    }
}

