/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.IOException;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;

public class SecureFile
extends SecureDirectory {
    public SecureFile(String pathname) {
        super(pathname);
    }

    public SecureFile(String parent, String child) {
        super(parent, child);
    }

    public SecureFile(File parent, String child) {
        super(parent, child);
    }

    @Override
    public boolean createNewFile() throws IOException {
        boolean rv = super.createNewFile();
        if (rv) {
            this.setPerms();
        }
        return rv;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File rv = File.createTempFile(prefix, suffix);
        SecureFileOutputStream.setPerms(rv);
        return rv;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File rv = File.createTempFile(prefix, suffix, directory);
        SecureFileOutputStream.setPerms(rv);
        return rv;
    }

    @Override
    protected void setPerms() {
        if (!SecureFileOutputStream.canSetPerms()) {
            return;
        }
        try {
            this.setReadable(false, false);
            this.setReadable(true, true);
            this.setWritable(false, false);
            this.setWritable(true, true);
            if (isNotWindows && this.isDirectory()) {
                this.setExecutable(false, false);
                this.setExecutable(true, true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

