/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class RoboTrackFrameDecoder
extends BaseFrameDecoder {
    private int messageLength(ByteBuf buf) {
        return switch (buf.getUnsignedByte(buf.readerIndex())) {
            case 0 -> 69;
            case 128 -> 3;
            case 3, 4, 6 -> 24;
            case 7 -> 8 + buf.getUnsignedShortLE(buf.readerIndex() + 1);
            case 8 -> 6;
            default -> Integer.MAX_VALUE;
        };
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        int length = this.messageLength(buf);
        if (buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

