/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Set;
import org.apache.solr.client.api.model.BalanceReplicasRequestBody;
import org.apache.solr.client.api.model.MigrateReplicasRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ClusterApi {

    public static class MigrateReplicas
    extends SolrRequest<MigrateReplicasResponse> {
        private final MigrateReplicasRequestBody requestBody = new MigrateReplicasRequestBody();

        public MigrateReplicas() {
            super(SolrRequest.METHOD.valueOf("POST"), "/cluster/replicas/migrate");
            this.addHeader("Content-type", "application/json");
        }

        public void setSourceNodes(Set<String> sourceNodes) {
            this.requestBody.sourceNodes = sourceNodes;
        }

        public void setTargetNodes(Set<String> targetNodes) {
            this.requestBody.targetNodes = targetNodes;
        }

        public void setWaitForFinalState(Boolean waitForFinalState) {
            this.requestBody.waitForFinalState = waitForFinalState;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected MigrateReplicasResponse createResponse(SolrClient client) {
            return new MigrateReplicasResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class MigrateReplicasResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public MigrateReplicasResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class BalanceReplicas
    extends SolrRequest<BalanceReplicasResponse> {
        private final BalanceReplicasRequestBody requestBody = new BalanceReplicasRequestBody();

        public BalanceReplicas() {
            super(SolrRequest.METHOD.valueOf("POST"), "/cluster/replicas/balance");
            this.addHeader("Content-type", "application/json");
        }

        public void setNodes(Set<String> nodes) {
            this.requestBody.nodes = nodes;
        }

        public void setWaitForFinalState(Boolean waitForFinalState) {
            this.requestBody.waitForFinalState = waitForFinalState;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected BalanceReplicasResponse createResponse(SolrClient client) {
            return new BalanceReplicasResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class BalanceReplicasResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public BalanceReplicasResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

