/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.core.SolrCoreMetric;

public class SolrCoreHandlerMetric
extends SolrCoreMetric {
    public static final String CORE_REQUESTS_TOTAL = "solr_metrics_core_requests";
    public static final String CORE_REQUESTS_UPDATE_HANDLER = "solr_metrics_core_update_handler";
    public static final String CORE_REQUESTS_TOTAL_TIME = "solr_metrics_core_requests_time";
    public static final String CORE_REQUEST_TIMES = "solr_metrics_core_average_request_time";

    public SolrCoreHandlerMetric(Metric dropwizardMetric, String coreName, String metricName, boolean cloudMode) {
        super(dropwizardMetric, coreName, metricName, cloudMode);
    }

    @Override
    public SolrCoreMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        this.labels.put("category", parsedMetric[0]);
        this.labels.put("handler", parsedMetric[1]);
        this.labels.put("type", parsedMetric[2]);
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        if (this.dropwizardMetric instanceof Meter) {
            formatter.exportMeter(CORE_REQUESTS_TOTAL, (Meter)this.dropwizardMetric, this.getLabels());
        } else if (this.dropwizardMetric instanceof Counter) {
            if (this.metricName.endsWith("requests")) {
                formatter.exportCounter(CORE_REQUESTS_TOTAL, (Counter)this.dropwizardMetric, this.getLabels());
            } else if (this.metricName.endsWith("totalTime")) {
                this.labels.remove("type");
                formatter.exportCounter(CORE_REQUESTS_TOTAL_TIME, (Counter)this.dropwizardMetric, this.getLabels());
            }
        } else if (this.dropwizardMetric instanceof Gauge) {
            if (!this.metricName.endsWith("handlerStart")) {
                formatter.exportGauge(CORE_REQUESTS_UPDATE_HANDLER, (Gauge)this.dropwizardMetric, this.getLabels());
            }
        } else if (this.dropwizardMetric instanceof Timer) {
            this.labels.remove("type");
            formatter.exportTimer(CORE_REQUEST_TIMES, (Timer)this.dropwizardMetric, this.getLabels());
        }
    }
}

