/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.util.NamedList;

public class SnapshotListTool
extends ToolBase {
    public SnapshotListTool() {
        this(CLIO.getOutStream());
    }

    public SnapshotListTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "snapshot-list";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of collection to list snapshots for.").build(), SolrCLI.OPTION_CREDENTIALS);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String collectionName = cli.getOptionValue("name");
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            this.listSnapshots(solrClient, collectionName);
        }
    }

    public void listSnapshots(SolrClient solrClient, String collectionName) {
        CollectionAdminRequest.ListSnapshots listSnaps = new CollectionAdminRequest.ListSnapshots(collectionName);
        try {
            CollectionAdminResponse resp = (CollectionAdminResponse)listSnaps.process(solrClient);
            if (resp.getStatus() != 0) {
                throw new IllegalStateException("The LISTSNAPSHOTS request failed. The status code is " + resp.getStatus());
            }
            NamedList apiResult = (NamedList)resp.getResponse().get("snapshots");
            for (int i = 0; i < apiResult.size(); ++i) {
                this.echo(apiResult.getName(i));
            }
        }
        catch (Exception e) {
            this.echo("Failed to list snapshots for collection " + collectionName + " due to following error : " + e.getLocalizedMessage());
        }
    }
}

