/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.manager.messageprocessor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.crossdc.common.IQueueHandler;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.apache.solr.crossdc.common.ResubmitBackoffPolicy;
import org.apache.solr.crossdc.common.SolrExceptionUtil;
import org.apache.solr.crossdc.manager.messageprocessor.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SolrMessageProcessor
extends MessageProcessor
implements IQueueHandler<MirroredSolrRequest<?>> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)"metrics");
    final CloudSolrClient client;
    private static final String VERSION_FIELD = "_version_";

    public SolrMessageProcessor(CloudSolrClient client, ResubmitBackoffPolicy resubmitBackoffPolicy) {
        super(resubmitBackoffPolicy);
        this.client = client;
    }

    public IQueueHandler.Result<MirroredSolrRequest<?>> handleItem(MirroredSolrRequest<?> mirroredSolrRequest) {
        try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"collection", (String)SolrMessageProcessor.getCollectionFromRequest(mirroredSolrRequest));){
            this.connectToSolrIfNeeded();
            IQueueHandler.Result<MirroredSolrRequest<?>> result = this.processMirroredRequest(mirroredSolrRequest);
            return result;
        }
    }

    private IQueueHandler.Result<MirroredSolrRequest<?>> processMirroredRequest(MirroredSolrRequest<?> request) {
        IQueueHandler.Result<MirroredSolrRequest<?>> result = this.handleSolrRequest(request);
        this.backoffIfNeeded(result, request.getType());
        return result;
    }

    private IQueueHandler.Result<MirroredSolrRequest<?>> handleSolrRequest(MirroredSolrRequest<?> mirroredSolrRequest) {
        IQueueHandler.Result<MirroredSolrRequest<?>> result;
        SolrRequest request = mirroredSolrRequest.getSolrRequest();
        SolrParams requestParams = request.getParams();
        if (log.isDebugEnabled()) {
            log.debug("handleSolrRequest start params={}", (Object)requestParams);
        }
        this.logFirstAttemptLatency(mirroredSolrRequest);
        try {
            this.prepareIfUpdateRequest(request);
            this.logRequest(request);
            result = this.processMirroredSolrRequest(request, mirroredSolrRequest.getType());
        }
        catch (Exception e) {
            result = this.handleException(mirroredSolrRequest, e);
        }
        if (log.isDebugEnabled()) {
            log.debug("handleSolrRequest end params={} result={}", (Object)requestParams, result);
        }
        return result;
    }

    private IQueueHandler.Result<MirroredSolrRequest<?>> handleException(MirroredSolrRequest<?> mirroredSolrRequest, Exception e) {
        SolrException solrException = SolrExceptionUtil.asSolrException((Exception)e);
        this.logIf4xxException(solrException);
        if (!this.isRetryable(e)) {
            log.error("Non retryable exception processing Solr update", (Throwable)e);
            return new IQueueHandler.Result(IQueueHandler.ResultStatus.FAILED_NO_RETRY, (Throwable)e);
        }
        this.logFailure(mirroredSolrRequest, e, solrException);
        mirroredSolrRequest.setAttempt(mirroredSolrRequest.getAttempt() + 1);
        this.maybeBackoff(mirroredSolrRequest, solrException);
        return new IQueueHandler.Result(IQueueHandler.ResultStatus.FAILED_RESUBMIT, (Throwable)e, mirroredSolrRequest);
    }

    private void maybeBackoff(MirroredSolrRequest<?> request, SolrException solrException) {
        if (solrException == null) {
            return;
        }
        long sleepTimeMs = 1000L;
        String backoffTimeSuggested = solrException.getMetadata("backoffTime-ms");
        if (backoffTimeSuggested != null && !"0".equals(backoffTimeSuggested)) {
            sleepTimeMs = Math.max(1L, Long.parseLong(backoffTimeSuggested));
        }
        log.info("Consumer backoff. sleepTimeMs={}", (Object)sleepTimeMs);
        this.metrics.meter(MetricRegistry.name((String)request.getType().name(), (String[])new String[]{"backoff"})).mark(sleepTimeMs);
        this.uncheckedSleep(sleepTimeMs);
    }

    private boolean isRetryable(Exception e) {
        int code;
        SolrException se = SolrExceptionUtil.asSolrException((Exception)e);
        if (se != null && (code = se.code()) == SolrException.ErrorCode.CONFLICT.code) {
            return false;
        }
        log.warn("Unexpected exception, will resubmit the request to the queue", (Throwable)e);
        return true;
    }

    private void logIf4xxException(SolrException solrException) {
        if (solrException != null && 400 <= solrException.code() && solrException.code() < 500) {
            log.error("Exception occurred with 4xx response. {}", (Object)solrException.code(), (Object)solrException);
        }
    }

    private void logFailure(MirroredSolrRequest<?> mirroredSolrRequest, Exception e, SolrException solrException) {
        if (solrException != null && 400 <= solrException.code() && solrException.code() < 500) {
            log.error("Exception occurred with 4xx response. {}", (Object)solrException.code(), (Object)solrException);
            return;
        }
        log.warn("Resubmitting mirrored solr request after failure errorCode={} retryCount={}", new Object[]{solrException != null ? solrException.code() : -1, mirroredSolrRequest.getAttempt(), e});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueueHandler.Result<MirroredSolrRequest<?>> processMirroredSolrRequest(SolrRequest<?> request, MirroredSolrRequest.Type type) throws Exception {
        SolrResponseBase response;
        if (log.isDebugEnabled()) {
            log.debug("Sending request to Solr at ZK address={} with params {}", (Object)ZkStateReader.from((CloudSolrClient)this.client).getZkClient().getZkServerAddress(), (Object)request.getParams());
        }
        Timer.Context ctx = this.metrics.timer(MetricRegistry.name((String)type.name(), (String[])new String[]{"outputTime"})).time();
        try {
            response = (SolrResponseBase)request.process((SolrClient)this.client);
        }
        finally {
            ctx.stop();
        }
        int status = response.getStatus();
        if (log.isTraceEnabled()) {
            log.trace("result status={}", (Object)status);
        }
        if (status != 0) {
            this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"outputErrors"})).inc();
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)status), "response=" + response);
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished sending request to Solr at ZK address={} with params {} status_code={}", new Object[]{ZkStateReader.from((CloudSolrClient)this.client).getZkClient().getZkServerAddress(), request.getParams(), status});
        }
        IQueueHandler.Result result = new IQueueHandler.Result(IQueueHandler.ResultStatus.HANDLED);
        return result;
    }

    private void logRequest(SolrRequest<?> request) {
        if (request instanceof UpdateRequest) {
            StringBuilder rmsg = new StringBuilder(64);
            String collection = request.getCollection();
            rmsg.append("Submitting update request for collection=").append(collection != null ? collection : request.getParams().get("collection"));
            if (((UpdateRequest)request).getDeleteById() != null) {
                int numDeleteByIds = ((UpdateRequest)request).getDeleteById().size();
                rmsg.append(" numDeleteByIds=").append(numDeleteByIds);
            }
            if (((UpdateRequest)request).getDocuments() != null) {
                int numUpdates = ((UpdateRequest)request).getDocuments().size();
                rmsg.append(" numUpdates=").append(numUpdates);
            }
            if (((UpdateRequest)request).getDeleteQuery() != null) {
                int numDeleteByQuery = ((UpdateRequest)request).getDeleteQuery().size();
                rmsg.append(" numDeleteByQuery=").append(numDeleteByQuery);
            }
            if (log.isInfoEnabled()) {
                log.info(rmsg.toString());
            }
        }
    }

    private void prepareIfUpdateRequest(SolrRequest<?> request) {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            List documents = updateRequest.getDocuments();
            if (log.isTraceEnabled()) {
                log.trace("update request docs={} deletebyid={} deletebyquery={}", new Object[]{documents, updateRequest.getDeleteById(), updateRequest.getDeleteQuery()});
            }
            if (documents != null) {
                for (SolrInputDocument doc : documents) {
                    this.sanitizeDocument(doc);
                }
            }
            this.removeVersionFromDeleteByIds(updateRequest);
        }
    }

    private void sanitizeDocument(SolrInputDocument doc) {
        SolrInputField field = doc.getField(VERSION_FIELD);
        if (log.isTraceEnabled()) {
            log.trace("Removing {} value={}", (Object)VERSION_FIELD, field == null ? "null" : field.getValue());
        }
        doc.remove((Object)VERSION_FIELD);
    }

    private void removeVersionFromDeleteByIds(UpdateRequest updateRequest) {
        Map deleteIds;
        if (log.isTraceEnabled()) {
            log.trace("remove versions from deletebyids");
        }
        if ((deleteIds = updateRequest.getDeleteByIdMap()) != null) {
            for (Map idParams : deleteIds.values()) {
                if (idParams == null) continue;
                idParams.put("ver", null);
            }
        }
    }

    private void logFirstAttemptLatency(MirroredSolrRequest<?> mirroredSolrRequest) {
        if (mirroredSolrRequest.getAttempt() == 1) {
            long latency = System.nanoTime() - mirroredSolrRequest.getSubmitTimeNanos();
            log.debug("First attempt latency = {} ns", (Object)latency);
            this.metrics.timer(MetricRegistry.name((String)mirroredSolrRequest.getType().name(), (String[])new String[]{"outputLatency"})).update(latency, TimeUnit.NANOSECONDS);
        }
    }

    void preventCircularMirroring(MirroredSolrRequest<?> mirroredSolrRequest) {
        if (mirroredSolrRequest.getSolrRequest() instanceof UpdateRequest) {
            String shouldMirror;
            UpdateRequest updateRequest = (UpdateRequest)mirroredSolrRequest.getSolrRequest();
            ModifiableSolrParams params = updateRequest.getParams();
            String string = shouldMirror = params == null ? null : params.get("shouldMirror");
            if (shouldMirror == null) {
                log.warn("{} param is missing - setting to false. Request={}", (Object)"shouldMirror", mirroredSolrRequest);
                updateRequest.setParam("shouldMirror", "false");
            } else if (!"false".equalsIgnoreCase(shouldMirror)) {
                log.warn("{} param equal to {}", (Object)"shouldMirror", (Object)shouldMirror);
            }
        } else {
            String shouldMirror;
            SolrParams params = mirroredSolrRequest.getSolrRequest().getParams();
            String string = shouldMirror = params == null ? null : params.get("shouldMirror");
            if (shouldMirror == null) {
                if (params instanceof ModifiableSolrParams) {
                    log.warn("{} param is missing - setting to false", (Object)"shouldMirror");
                    ((ModifiableSolrParams)params).set("shouldMirror", new String[]{"false"});
                } else {
                    log.warn("{} param is missing and params are not modifiable", (Object)"shouldMirror");
                }
            } else if (!"false".equalsIgnoreCase(shouldMirror)) {
                log.warn("{} param is present and set to {}", (Object)"shouldMirror", (Object)shouldMirror);
            }
        }
    }

    private void connectToSolrIfNeeded() {
        boolean connected = false;
        while (!connected) {
            try {
                this.client.connect();
                connected = true;
            }
            catch (Exception e) {
                log.error("Unable to connect to solr server. Not consuming.", (Throwable)e);
                this.uncheckedSleep(5000L);
            }
        }
    }

    public void uncheckedSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void backoffIfNeeded(IQueueHandler.Result<MirroredSolrRequest<?>> result, MirroredSolrRequest.Type type) {
        long backoffMs;
        if (result.status().equals((Object)IQueueHandler.ResultStatus.FAILED_RESUBMIT) && (backoffMs = this.getResubmitBackoffPolicy().getBackoffTimeMs((MirroredSolrRequest)result.getItem())) > 0L) {
            this.metrics.meter(MetricRegistry.name((String)type.name(), (String[])new String[]{"backoff"})).mark(backoffMs);
            try {
                Thread.sleep(backoffMs);
            }
            catch (InterruptedException ex) {
                log.warn("Thread interrupted while backing off before retry");
                Thread.currentThread().interrupt();
            }
        }
    }

    private static String getCollectionFromRequest(MirroredSolrRequest<?> mirroredSolrRequest) {
        if (mirroredSolrRequest == null || mirroredSolrRequest.getSolrRequest() == null) {
            return null;
        }
        return mirroredSolrRequest.getSolrRequest().getCollection();
    }
}

