/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class InterceptorContainer<T> {
    private final List<ResourceInterceptor<T>> globalResourceInterceptors = new ArrayList<ResourceInterceptor<T>>();
    private final List<ResourceInterceptor<T>> nameResourceInterceptors = new ArrayList<ResourceInterceptor<T>>();

    public void addGlobalRequestInterceptor(ResourceInterceptor<T> interceptor) {
        this.globalResourceInterceptors.add(interceptor);
    }

    public void addNameRequestInterceptor(ResourceInterceptor<T> interceptor) {
        this.nameResourceInterceptors.add(interceptor);
    }

    public List<ResourceInterceptor<T>> getGlobalResourceInterceptors() {
        return this.globalResourceInterceptors;
    }

    public List<ResourceInterceptor<T>> getNameResourceInterceptors() {
        return this.nameResourceInterceptors;
    }

    public void sort() {
        Collections.sort(this.globalResourceInterceptors);
        Collections.sort(this.nameResourceInterceptors);
    }

    public boolean isEmpty() {
        return this.globalResourceInterceptors.isEmpty() && this.nameResourceInterceptors.isEmpty();
    }

    public ResourceInterceptor<T> create() {
        return new ResourceInterceptor();
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        for (ResourceInterceptor<?> resourceInterceptor : this.globalResourceInterceptors) {
            if (resourceInterceptor.getFactory() != null) continue;
            resourceInterceptor.setFactory(factoryCreator.apply(resourceInterceptor.getClassName()));
        }
        for (ResourceInterceptor<?> resourceInterceptor : this.nameResourceInterceptors) {
            if (resourceInterceptor.getFactory() != null) continue;
            resourceInterceptor.setFactory(factoryCreator.apply(resourceInterceptor.getClassName()));
        }
    }

    public static class Reversed<T>
    extends InterceptorContainer<T> {
        @Override
        public ResourceInterceptor<T> create() {
            return new ResourceInterceptor.Reversed();
        }
    }
}

