/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataA
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 6539022022231148667L;
    private final Inet4Address address;
    private final boolean addressPlainText;

    public static DnsRDataA newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataA(rawData, offset, length);
    }

    private DnsRDataA(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a DnsRDataA (Min: ").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (length == 4) {
            this.address = ByteArrays.getInet4Address(rawData, offset);
            this.addressPlainText = false;
        } else {
            String addr = new String(ByteArrays.getSubArray(rawData, offset, length));
            try {
                byte[] octets = ByteArrays.parseInet4Address(addr);
                this.address = (Inet4Address)Inet4Address.getByAddress(octets);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("Couldn't get an Inet4Address from ").append(addr).append(". data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString(), e);
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)"Never get here.");
            }
            this.addressPlainText = true;
        }
    }

    private DnsRDataA(Builder builder2) {
        if (builder2 == null || builder2.address == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.address: ").append(builder2.address);
            throw new NullPointerException(sb.toString());
        }
        this.address = builder2.address;
        this.addressPlainText = builder2.addressPlainText;
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public boolean isAddressPlainText() {
        return this.addressPlainText;
    }

    @Override
    public int length() {
        if (this.addressPlainText) {
            return this.address.getHostAddress().length();
        }
        return 4;
    }

    @Override
    public byte[] getRawData() {
        if (this.addressPlainText) {
            return this.address.getHostAddress().getBytes();
        }
        return this.address.getAddress();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("A RDATA:").append(ls).append(indent).append("  ADDRESS: ").append(this.address.getHostAddress()).append(" (").append(this.addressPlainText ? "text" : "encoded").append(")").append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + (this.addressPlainText ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsRDataA dnsRDataA = (DnsRDataA)o;
        if (this.addressPlainText != dnsRDataA.addressPlainText) {
            return false;
        }
        return this.address.equals(dnsRDataA.address);
    }

    public static final class Builder {
        private Inet4Address address;
        private boolean addressPlainText;

        public Builder() {
        }

        private Builder(DnsRDataA obj) {
            this.address = obj.address;
            this.addressPlainText = obj.addressPlainText;
        }

        public Builder address(Inet4Address address) {
            this.address = address;
            return this;
        }

        public Builder addressPlainText(boolean addressPlainText) {
            this.addressPlainText = addressPlainText;
            return this;
        }

        public DnsRDataA build() {
            return new DnsRDataA(this);
        }
    }
}

