/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.production.TileProductionCalculator;
import net.sf.freecol.common.model.production.WorkerAssignment;
import net.sf.freecol.util.test.FreeColTestCase;

public class ClassicTileProductionTest
extends FreeColTestCase {
    private static final File EXPECTED_DIRECTORY = new File("test/expected-data");
    private static final File ACTUAL_DIRECTORY = new File("test/data");
    private static final File verifiedResultFile = new File(EXPECTED_DIRECTORY, "verified-tile-production.csv");
    private static final File expectedResultFile = new File(EXPECTED_DIRECTORY, "expected-tile-production.csv");
    private static final File actualResultFile = new File(ACTUAL_DIRECTORY, "actual-tile-production.csv");

    public void testTileProduction() throws Exception {
        this.produceActualResultFile(actualResultFile);
        this.compareResultFiles(verifiedResultFile, actualResultFile);
        this.compareResultFiles(expectedResultFile, actualResultFile);
    }

    private void produceActualResultFile(File actualResultFile) throws FileNotFoundException {
        Game game = ClassicTileProductionTest.getStandardGame();
        List<TileImprovementType> tileImprovementColumns = ClassicTileProductionTest.spec().getTileImprovementTypeList();
        String tileImprovementFormatString = tileImprovementColumns.stream().map(t -> "%s;").reduce(String::concat).orElseThrow();
        try (PrintWriter out = new PrintWriter(actualResultFile);){
            this.writeHeaderTo(out, tileImprovementColumns);
            for (TileType tileType : ClassicTileProductionTest.spec().getTileTypeList()) {
                for (GoodsType goodsType : ClassicTileProductionTest.spec().getFarmedGoodsTypeList()) {
                    for (ResourceType resourceType : this.nullAnd(tileType.getResourceTypeValues())) {
                        List<List<TileImprovementTypeWithMagnitude>> tileImprovementPermutations = this.determineTileImprovementPermutations(tileType);
                        List<UnitType> unitTypes = this.getUnitTypesThatShouldBeTestedFor(goodsType);
                        for (UnitType unitType : unitTypes) {
                            for (List<TileImprovementTypeWithMagnitude> tileImprovementsWithMagnitude : tileImprovementPermutations) {
                                for (int colonyProductionBonus = -2; colonyProductionBonus <= 2; ++colonyProductionBonus) {
                                    ProductionTestCombination ptc = new ProductionTestCombination(tileType, goodsType, resourceType, unitType, tileImprovementsWithMagnitude, colonyProductionBonus);
                                    List<Object> output = this.executeProductionTestCombination(ptc, game, tileImprovementColumns);
                                    this.writeOutputTo(out, output, tileImprovementFormatString);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private List<Object> executeProductionTestCombination(ProductionTestCombination ptc, Game game, List<TileImprovementType> tileImprovementColumns) {
        ProductionInfo pi;
        UnitType defaultUnitType = ClassicTileProductionTest.spec().getDefaultUnitType();
        UnitType pettyCriminalUnitType = ClassicTileProductionTest.spec().getUnitType("model.unit.pettyCriminal");
        UnitType indenturedServantUnitType = ClassicTileProductionTest.spec().getUnitType("model.unit.indenturedServant");
        Tile tile = new Tile(game, ptc.tileType, 0, 1);
        if (ptc.resourceType != null) {
            tile.addResource(new Resource(game, tile, ptc.resourceType));
        }
        for (TileImprovementTypeWithMagnitude titwm : ptc.tileImprovementsWithMagnitude) {
            TileImprovement tileImprovement = new TileImprovement(game, tile, titwm.getTileImprovementType(), null);
            tileImprovement.setMagnitude(titwm.getMagnitude());
            tileImprovement.setTurnsToComplete(0);
            tile.add(tileImprovement);
        }
        ProductionType productionType = ProductionType.getBestProductionType(ptc.goodsType, ptc.tileType.getAvailableProductionTypes(false));
        TileProductionCalculator tpc = new TileProductionCalculator(null, ptc.colonyProductionBonus);
        if (ptc.unitType != null) {
            pi = tpc.getBasicProductionInfo(tile, new Turn(1), new WorkerAssignment(ptc.unitType, productionType), false);
        } else {
            ProductionType unattendedProductionType = ProductionType.getBestProductionType(ptc.goodsType, ptc.tileType.getAvailableProductionTypes(true));
            pi = tpc.getBasicProductionInfo(tile, new Turn(1), new WorkerAssignment(null, unattendedProductionType), true);
        }
        if (ptc.unitType == defaultUnitType) {
            ProductionInfo piCriminal = tpc.getBasicProductionInfo(tile, new Turn(1), new WorkerAssignment(pettyCriminalUnitType, productionType), false);
            ClassicTileProductionTest.assertEquals((String)"Petty criminals should have the same production as a Free Colonist on tiles.", (int)this.getProductionAmount(ptc.goodsType, pi), (int)this.getProductionAmount(ptc.goodsType, piCriminal));
            ProductionInfo piIndentured = tpc.getBasicProductionInfo(tile, new Turn(1), new WorkerAssignment(indenturedServantUnitType, productionType), false);
            ClassicTileProductionTest.assertEquals((String)"Indentured Servants should have the same production as a Free Colonist on tiles.", (int)this.getProductionAmount(ptc.goodsType, pi), (int)this.getProductionAmount(ptc.goodsType, piIndentured));
        }
        ArrayList<Object> output = new ArrayList<Object>();
        output.add(this.getProductionAmount(ptc.goodsType, pi));
        output.add(ptc.tileType.getId());
        output.add(ptc.goodsType.getId());
        output.add(ptc.resourceType != null ? ptc.resourceType.getId() : "");
        output.add(ptc.unitType != null ? ptc.unitType.getId() : "unattended");
        for (TileImprovementType columnType : tileImprovementColumns) {
            int magnitude = ptc.tileImprovementsWithMagnitude.stream().filter(t -> t.getTileImprovementType() == columnType).findAny().orElse(new TileImprovementTypeWithMagnitude(null, 0)).getMagnitude();
            output.add(magnitude);
        }
        output.add(Integer.toString(ptc.colonyProductionBonus));
        return output;
    }

    private void writeHeaderTo(PrintWriter out, List<TileImprovementType> tileImprovementColumns) {
        String tileImprovementColumnHeaderString = tileImprovementColumns.stream().map(t -> t.getId() + ";").reduce(String::concat).orElseThrow();
        out.println("Production;Tile Type;Goods Type;Bonus Resource;Unit Type;" + tileImprovementColumnHeaderString + "Colony Production Bonus");
    }

    private void writeOutputTo(PrintWriter out, List<Object> output, String tileImprovementFormatString) {
        String formatString = "%s;%s;%s;%s;%s;" + tileImprovementFormatString + "%s";
        String result = String.format(formatString, output.toArray());
        out.println(result);
    }

    private List<UnitType> getUnitTypesThatShouldBeTestedFor(GoodsType goodsType) {
        UnitType defaultUnitType = ClassicTileProductionTest.spec().getDefaultUnitType();
        UnitType indianConvert = ClassicTileProductionTest.spec().getUnitType("model.unit.indianConvert");
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>(List.of(defaultUnitType, indianConvert));
        unitTypes.add(null);
        UnitType expertUnitType = ClassicTileProductionTest.spec().getExpertForProducing(goodsType);
        if (expertUnitType != null) {
            unitTypes.add(expertUnitType);
        }
        return unitTypes;
    }

    private void compareResultFiles(File expectedFile, File actualFile) throws IOException {
        String header = this.readHeaderFromResultFile(expectedFile);
        Map<String, Integer> expected = this.readResultFile(expectedFile);
        Map<String, Integer> actual = this.readResultFile(actualFile);
        StringBuilder sb = new StringBuilder();
        sb.append("There are actual production values that do not match the expected values.\n\n");
        sb.append("Expected Production;" + header + "\n");
        int failedChecks = 0;
        for (Map.Entry<String, Integer> expectedEntry : expected.entrySet()) {
            String key = expectedEntry.getKey();
            Integer actualProduction = actual.get(key);
            if (actualProduction == null) {
                ClassicTileProductionTest.fail((String)("Missing actual production for: " + key));
            }
            if (expectedEntry.getValue() == actualProduction) continue;
            ++failedChecks;
            sb.append(expectedEntry.getValue() + ";" + actualProduction + ";" + key + "\n");
        }
        ClassicTileProductionTest.assertEquals((String)sb.toString(), (int)0, (int)failedChecks);
    }

    private String readHeaderFromResultFile(File resultFile) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(resultFile)));){
            String string = in.readLine();
            return string;
        }
    }

    private Map<String, Integer> readResultFile(File resultFile) throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(resultFile)));){
            String line = in.readLine();
            while ((line = in.readLine()) != null) {
                if (line.isBlank() || line.startsWith("#")) continue;
                String[] a = line.split(";", 2);
                result.put(a[1], Integer.parseInt(a[0]));
            }
        }
        return result;
    }

    private int getProductionAmount(GoodsType goodstype, ProductionInfo pi) {
        if (pi.getProduction().isEmpty()) {
            return 0;
        }
        return pi.getProduction().stream().filter(ag -> ag.getType().equals(goodstype)).map(AbstractGoods::getAmount).findFirst().orElse(0);
    }

    private <T> List<T> nullAnd(List<T> input) {
        ArrayList<T> result = new ArrayList<T>(input);
        result.add(null);
        return result;
    }

    private List<List<TileImprovementTypeWithMagnitude>> determineTileImprovementPermutations(TileType tileType) {
        List tileImprovements = ClassicTileProductionTest.spec().getTileImprovementTypeList().stream().filter(ti -> ti.isTileTypeAllowed(tileType)).collect(Collectors.toList());
        int numberOfPermutations = (int)Math.pow(2.0, tileImprovements.size());
        ArrayList<List<TileImprovementTypeWithMagnitude>> tileImprovementPermutations = new ArrayList<List<TileImprovementTypeWithMagnitude>>(numberOfPermutations);
        for (int i = 0; i < numberOfPermutations; ++i) {
            BitSet bitSet = BitSet.valueOf(new long[]{i});
            ArrayList<TileImprovementTypeWithMagnitude> permutation = new ArrayList<TileImprovementTypeWithMagnitude>(tileImprovements.size());
            ArrayList<TileImprovementTypeWithMagnitude> permutation2 = new ArrayList<TileImprovementTypeWithMagnitude>(tileImprovements.size());
            boolean hasRiver = false;
            for (int j = 0; j < bitSet.length(); ++j) {
                if (!bitSet.get(j)) continue;
                TileImprovementType tileImprovementType = (TileImprovementType)tileImprovements.get(j);
                permutation.add(new TileImprovementTypeWithMagnitude(tileImprovementType, 1));
                if (tileImprovementType.getId().equals("model.improvement.river")) {
                    permutation2.add(new TileImprovementTypeWithMagnitude(tileImprovementType, 2));
                    hasRiver = true;
                    continue;
                }
                permutation2.add(new TileImprovementTypeWithMagnitude(tileImprovementType, 1));
            }
            tileImprovementPermutations.add(permutation);
            if (!hasRiver) continue;
            tileImprovementPermutations.add(permutation2);
        }
        return tileImprovementPermutations;
    }

    private static class TileImprovementTypeWithMagnitude {
        private final TileImprovementType tileImprovementType;
        private final int magnitude;

        public TileImprovementTypeWithMagnitude(TileImprovementType tileImprovementType, int magnitude) {
            this.tileImprovementType = tileImprovementType;
            this.magnitude = magnitude;
        }

        public TileImprovementType getTileImprovementType() {
            return this.tileImprovementType;
        }

        public int getMagnitude() {
            return this.magnitude;
        }
    }

    private static class ProductionTestCombination {
        private final TileType tileType;
        private final GoodsType goodsType;
        private final ResourceType resourceType;
        private final UnitType unitType;
        private final List<TileImprovementTypeWithMagnitude> tileImprovementsWithMagnitude;
        private final int colonyProductionBonus;

        public ProductionTestCombination(TileType tileType, GoodsType goodsType, ResourceType resourceType, UnitType unitType, List<TileImprovementTypeWithMagnitude> tileImprovementsWithMagnitude, int colonyProductionBonus) {
            this.tileType = tileType;
            this.goodsType = goodsType;
            this.resourceType = resourceType;
            this.unitType = unitType;
            this.tileImprovementsWithMagnitude = tileImprovementsWithMagnitude;
            this.colonyProductionBonus = colonyProductionBonus;
        }
    }
}

