info = {
    "name": "se",
    "date_order": "YMD",
    "january": [
        "ođđajagemánnu",
        "ođđj"
    ],
    "february": [
        "guov",
        "guovvamánnu"
    ],
    "march": [
        "njuk",
        "njukčamánnu"
    ],
    "april": [
        "cuo",
        "cuoŋománnu"
    ],
    "may": [
        "mies",
        "miessemánnu"
    ],
    "june": [
        "geas",
        "geassemánnu"
    ],
    "july": [
        "suoi",
        "suoidnemánnu"
    ],
    "august": [
        "borg",
        "borgemánnu"
    ],
    "september": [
        "čakč",
        "čakčamánnu"
    ],
    "october": [
        "golg",
        "golggotmánnu"
    ],
    "november": [
        "skáb",
        "skábmamánnu"
    ],
    "december": [
        "juov",
        "juovlamánnu"
    ],
    "monday": [
        "vuos",
        "vuossárga"
    ],
    "tuesday": [
        "maŋ",
        "maŋŋebárga"
    ],
    "wednesday": [
        "gask",
        "gaskavahkku"
    ],
    "thursday": [
        "duor",
        "duorasdat"
    ],
    "friday": [
        "bear",
        "bearjadat"
    ],
    "saturday": [
        "láv",
        "lávvardat"
    ],
    "sunday": [
        "sotn",
        "sotnabeaivi"
    ],
    "am": [
        "ib",
        "iđitbeaivet",
        "iđitbeaivi"
    ],
    "pm": [
        "eahketbeaivet",
        "eahketbeaivi",
        "eb"
    ],
    "year": [
        "jáhki"
    ],
    "month": [
        "mánnu"
    ],
    "week": [
        "váhkku"
    ],
    "day": [
        "beaivi"
    ],
    "hour": [
        "diibmu"
    ],
    "minute": [
        "minuhtta"
    ],
    "second": [
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "odne"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 month ago": [
            "this month"
        ],
        "0 second ago": [
            "now"
        ],
        "0 week ago": [
            "this week"
        ],
        "0 year ago": [
            "this year"
        ],
        "1 day ago": [
            "ikte"
        ],
        "1 month ago": [
            "last month"
        ],
        "1 week ago": [
            "last week"
        ],
        "1 year ago": [
            "last year"
        ],
        "in 1 day": [
            "ihttin"
        ],
        "in 1 month": [
            "next month"
        ],
        "in 1 week": [
            "next week"
        ],
        "in 1 year": [
            "next year"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) jándor árat",
            "(\\d+[.,]?\\d*) jándora árat"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) diibmu árat",
            "(\\d+[.,]?\\d*) diibmur árat"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) minuhta árat",
            "(\\d+[.,]?\\d*) minuhtta árat"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) mánotbadji árat"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) sekunda árat",
            "(\\d+[.,]?\\d*) sekundda árat"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) vahkku árat",
            "(\\d+[.,]?\\d*) vahku árat"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) jahki árat",
            "(\\d+[.,]?\\d*) jahkki árat"
        ],
        "in \\1 day": [
            "(\\d+[.,]?\\d*) jándor maŋŋilit",
            "(\\d+[.,]?\\d*) jándora maŋŋilit"
        ],
        "in \\1 hour": [
            "(\\d+[.,]?\\d*) diibmu maŋŋilit",
            "(\\d+[.,]?\\d*) diibmur maŋŋilit"
        ],
        "in \\1 minute": [
            "(\\d+[.,]?\\d*) minuhta maŋŋilit",
            "(\\d+[.,]?\\d*) minuhtta maŋŋilit"
        ],
        "in \\1 month": [
            "(\\d+[.,]?\\d*) mánotbadji maŋŋilit"
        ],
        "in \\1 second": [
            "(\\d+[.,]?\\d*) sekunda maŋŋilit",
            "(\\d+[.,]?\\d*) sekundda maŋŋilit"
        ],
        "in \\1 week": [
            "(\\d+[.,]?\\d*) vahkku maŋŋilit",
            "(\\d+[.,]?\\d*) vahku maŋŋilit"
        ],
        "in \\1 year": [
            "(\\d+[.,]?\\d*) jahki maŋŋilit",
            "(\\d+[.,]?\\d*) jahkki maŋŋilit"
        ]
    },
    "locale_specific": {
        "se-FI": {
            "name": "se-FI",
            "monday": [
                "vuossárgga"
            ],
            "tuesday": [
                "maŋŋebárgga"
            ],
            "wednesday": [
                "gaskavahku"
            ],
            "thursday": [
                "duorastaga"
            ],
            "friday": [
                "bearjadaga"
            ],
            "saturday": [
                "lávvardaga"
            ],
            "year": [
                "j",
                "jahki"
            ],
            "week": [
                "vahkku"
            ],
            "relative-type": {
                "0 year ago": [
                    "dán jagi"
                ],
                "1 year ago": [
                    "mannan jagi"
                ],
                "in 1 year": [
                    "boahtte jagi"
                ]
            },
            "relative-type-regex": {
                "\\1 year ago": [
                    "(\\d+[.,]?\\d*) jagi árat"
                ],
                "in \\1 year": [
                    "(\\d+[.,]?\\d*) jagi siste"
                ]
            }
        },
        "se-SE": {
            "name": "se-SE"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
