// Generated by gmmproc 2.77.0 -- DO NOT MODIFY!
#ifndef _GTKMM_FILEDIALOG_H
#define _GTKMM_FILEDIALOG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2022 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <giomm/listmodel.h>
#include <giomm/file.h>
#include <gtkmm/filefilter.h>
#include <gtk/gtk.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API FileDialog_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Window;

/** A %Gtk::FileDialog object collects the arguments that
 * are needed to present a file chooser dialog to the
 * user, such as a title for the dialog and whether it
 * should be modal.
 *
 * The dialog is shown with open(), save(), etc. These APIs follow the
 * GIO async pattern, and the result can be obtained by calling
 * the corresponding finish function, for example open_finish().
 *
 * @ingroup Dialogs
 * @newin{4,10}
 */

class GTKMM_API FileDialog : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = FileDialog;
  using CppClassType = FileDialog_Class;
  using BaseObjectType = GtkFileDialog;
  using BaseClassType = GtkFileDialogClass;

  // noncopyable
  FileDialog(const FileDialog&) = delete;
  FileDialog& operator=(const FileDialog&) = delete;

private:  friend class FileDialog_Class;
  static CppClassType filedialog_class_;

protected:
  explicit FileDialog(const Glib::ConstructParams& construct_params);
  explicit FileDialog(GtkFileDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  FileDialog(FileDialog&& src) noexcept;
  FileDialog& operator=(FileDialog&& src) noexcept;

  ~FileDialog() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileDialog*       gobj()       { return reinterpret_cast<GtkFileDialog*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFileDialog* gobj() const { return reinterpret_cast<GtkFileDialog*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkFileDialog* gobj_copy();

private:

     
protected:
  FileDialog();

public:
  
  static Glib::RefPtr<FileDialog> create();


  /** Returns the title that will be shown on the
   * file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The title.
   */
  Glib::ustring get_title() const;
  
  /** Sets the title that will be shown on the
   * file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param title The new title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Returns whether the file chooser dialog
   * blocks interaction with the parent window
   * while it is presented.
   * 
   * @newin{4,10}
   * 
   * @return <tt>true</tt> if the file chooser dialog is modal.
   */
  bool get_modal() const;
  
  /** Sets whether the file chooser dialog
   * blocks interaction with the parent window
   * while it is presented.
   * 
   * @newin{4,10}
   * 
   * @param modal The new value.
   */
  void set_modal(bool modal =  true);

  
  /** Gets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filters, as
   * a `Gio::ListModel` of `Gtk::FileFilters`.
   */
  Glib::RefPtr<Gio::ListModel> get_filters();
  
  /** Gets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filters, as
   * a `Gio::ListModel` of `Gtk::FileFilters`.
   */
  Glib::RefPtr<const Gio::ListModel> get_filters() const;
  
  /** Sets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param filters A `Gio::ListModel` of `Gtk::FileFilters`.
   */
  void set_filters(const Glib::RefPtr<Gio::ListModel>& filters);

  
  /** Gets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The current filter.
   */
  Glib::RefPtr<FileFilter> get_default_filter();
  
  /** Gets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The current filter.
   */
  Glib::RefPtr<const FileFilter> get_default_filter() const;
  
  /** Sets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * If set to <tt>nullptr</tt>, the first item in property_filters()
   * will be used as the default filter. If that list is empty, the dialog
   * will be unfiltered.
   * 
   * @newin{4,10}
   * 
   * @param filter A `Gtk::FileFilter`.
   */
  void set_default_filter(const Glib::RefPtr<FileFilter>& filter);

  
  /** Gets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The folder.
   */
  Glib::RefPtr<Gio::File> get_initial_folder();
  
  /** Gets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The folder.
   */
  Glib::RefPtr<const Gio::File> get_initial_folder() const;
  
  /** Sets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param folder A `Gio::File`.
   */
  void set_initial_folder(const Glib::RefPtr<Gio::File>& folder);

  
  /** Gets the name for the file that should be initially set.
   * 
   * @newin{4,10}
   * 
   * @return The name.
   */
  std::string get_initial_name() const;
  
  /** Sets the name for the file that should be initially set.
   * For saving dialogs, this will usually be pre-entered into the name field.
   * 
   * If a file with this name already exists in the directory set via
   * property_initial_folder(), the dialog should preselect it.
   * 
   * @newin{4,10}
   * 
   * @param name A UTF8 string.
   */
  void set_initial_name(const std::string& name);

  
  /** Gets the file that will be initially selected in
   * the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The file.
   */
  Glib::RefPtr<Gio::File> get_initial_file();
  
  /** Gets the file that will be initially selected in
   * the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The file.
   */
  Glib::RefPtr<const Gio::File> get_initial_file() const;
  
  /** Sets the file that will be initially selected in
   * the file chooser dialog.
   * 
   * This function is a shortcut for calling both
   * set_initial_folder() and
   * set_initial_name() with the directory and
   * name of @a file respectively.
   * 
   * @newin{4,10}
   * 
   * @param file A `Gio::File`.
   */
  void set_initial_file(const Glib::RefPtr<Gio::File>& file);

  
  /** @newin{4,10}
   * 
   * @return The label shown on the file chooser's accept button.
   */
  Glib::ustring get_accept_label() const;
  
  /** Sets the label shown on the file chooser's accept button.
   * 
   * Leaving the accept label unset or setting it as <tt>nullptr</tt> will fall back to
   * a default label, depending on what API is used to launch the file dialog.
   * 
   * @newin{4,10}
   * 
   * @param accept_label The new accept label.
   */
  void set_accept_label(const Glib::ustring& accept_label);

  
  /** This function initiates a file selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call open_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void open(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A open() convenience overload.
  void open(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the open() call and
   * returns the resulting file.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected.
   * Otherwise, <tt>nullptr</tt> is returned and @a error is set.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Gio::File> open_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** This function initiates a directory selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * If you pass @a initial_folder, the file chooser will initially be
   * opened in the parent directory of that folder, otherwise, it
   * will be in the directory property_initial_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call select_folder_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void select_folder(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A select_folder() convenience overload.
  void select_folder(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the select_folder() call and
   * returns the resulting file.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected.
   * Otherwise, <tt>nullptr</tt> is returned and @a error is set.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Gio::File> select_folder_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** This function initiates a file save operation by
   * presenting a file chooser dialog to the user.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call save_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void save(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A save() convenience overload.
  void save(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the save() call and
   * returns the resulting file.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected.
   * Otherwise, <tt>nullptr</tt> is returned and @a error is set.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Gio::File> save_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

 
  /** This function initiates a multi-file selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * The file chooser will initially be opened in the directory
   * property_initial_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call open_multiple_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void open_multiple(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A open_multiple() convenience overload.
  void open_multiple(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  
  /** Finishes the open_multiple() call and
   * returns the resulting files in a std::vector.
   *
   * @newin{4,10}
   *
   * @param result A `Gio::AsyncResult`.
   * @return The files that were selected, as a vector of `Gio::File`s.
   *         Otherwise, an exception is thrown.
   *
   * @throws Gtk::DialogError
   */
  std::vector<Glib::RefPtr<Gio::File>> open_multiple_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** This function initiates a multi-directory selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * The file chooser will initially be opened in the directory
   * property_initial_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call select_multiple_folders_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void select_multiple_folders(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A select_multiple_folders() convenience overload.
  void select_multiple_folders(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  
  /** Finishes the select_multiple_folders()
   * call and returns the resulting files in a std::vector.
   *
   * @newin{4,10}
   *
   * @param result A Gio::AsyncResult.
   * @return The files that were selected, as a vector of `Gio::File`s.
   *         Otherwise, an exception is thrown.
   *
   * @throws Gtk::DialogError
   */
  std::vector<Glib::RefPtr<Gio::File>> select_multiple_folders_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  /** A title that may be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** A title that may be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** Whether the file chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** Whether the file chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The list of filters.
   * 
   * See property_default_filter() about how those two properties interact.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::ListModel> > property_filters() ;

/** The list of filters.
   * 
   * See property_default_filter() about how those two properties interact.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::ListModel> > property_filters() const;

  /** The default filter, that is, the filter that is initially
   * active in the file chooser dialog.
   * 
   * If the default filter is <tt>nullptr</tt>, the first filter of property_filters()
   * is used as the default filter. If that property contains no filter, the dialog will
   * be unfiltered.
   * 
   * If property_filters() is not <tt>nullptr</tt>, the default filter should be part
   * of the list. If it is not, the dialog may choose to not make it available.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<FileFilter> > property_default_filter() ;

/** The default filter, that is, the filter that is initially
   * active in the file chooser dialog.
   * 
   * If the default filter is <tt>nullptr</tt>, the first filter of property_filters()
   * is used as the default filter. If that property contains no filter, the dialog will
   * be unfiltered.
   * 
   * If property_filters() is not <tt>nullptr</tt>, the default filter should be part
   * of the list. If it is not, the dialog may choose to not make it available.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileFilter> > property_default_filter() const;

  /** The initial file, that is, the file that is initially selected
   * in the file chooser dialog
   * 
   * This is a utility property that sets both property_initial_folder() and
   * property_initial_name().
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_initial_file() ;

/** The initial file, that is, the file that is initially selected
   * in the file chooser dialog
   * 
   * This is a utility property that sets both property_initial_folder() and
   * property_initial_name().
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_initial_file() const;

  /** The initial folder, that is, the directory that is initially
   * opened in the file chooser dialog
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_initial_folder() ;

/** The initial folder, that is, the directory that is initially
   * opened in the file chooser dialog
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_initial_folder() const;

  /** The initial name, that is, the filename that is initially
   * selected in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::string > property_initial_name() ;

/** The initial name, that is, the filename that is initially
   * selected in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_initial_name() const;

  /** Label for the file chooser's accept button.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_accept_label() ;

/** Label for the file chooser's accept button.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_accept_label() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FileDialog
   */
  GTKMM_API
  Glib::RefPtr<Gtk::FileDialog> wrap(GtkFileDialog* object, bool take_copy = false);
}


#endif /* _GTKMM_FILEDIALOG_H */

