/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.platform;

import java.nio.ByteOrder;
import org.jruby.util.SafePropertyAccessor;

public abstract class Platform {
    private static final String DARWIN = "darwin";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String FREEBSD = "freebsd";
    private static final String DRAGONFLYBSD = "dragonflybsd";
    private static final String OPENBSD = "openbsd";
    private static final String SOLARIS = "solaris";
    private static final String OPENVMS = "openvms";
    private static final String GCJ = "GNU libgcj";
    private static final String IBM = "IBM J9 VM";
    private static final String OPENJ9 = "Eclipse OpenJ9 VM";
    public static final String ARCH = Platform.initArchitecture();
    public static final String OS = Platform.initOperatingSystem();
    public static final String JVM = Platform.getProperty("java.vm.name", "unknown");
    public static final String OS_VERSION = Platform.getProperty("os.version", "unknown");
    public static final boolean IS_WINDOWS = OS.equals("windows");
    public static final boolean IS_MAC = OS.equals("darwin");
    public static final boolean IS_FREEBSD = OS.equals("freebsd");
    public static final boolean IS_DRAGONFLYBSD = OS.equals("dragonflybsd");
    public static final boolean IS_OPENBSD = OS.equals("openbsd");
    public static final boolean IS_LINUX = OS.equals("linux");
    public static final boolean IS_WSL = IS_LINUX && OS_VERSION.contains("Microsoft");
    public static final boolean IS_SOLARIS = OS.equals("solaris");
    public static final boolean IS_BSD = IS_MAC || IS_FREEBSD || IS_OPENBSD || IS_DRAGONFLYBSD;
    public static final boolean IS_OPENVMS = OS.equals("openvms");
    public static final String NAME = String.format("%s-%s", ARCH, OS);
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;
    public static final int BIT_WIDTH = jnr.ffi.Platform.getNativePlatform().is32Bit() ? 32 : 64;
    public static final boolean IS_GCJ = JVM.equals("GNU libgcj");
    public static final boolean IS_J9;
    public static final boolean IS_IBM;

    private Platform() {
    }

    public String getPackageName() {
        return String.format("%s.%s.%s", Platform.class.getPackage().getName(), OS, ARCH);
    }

    public String getOSPackageName() {
        return String.format("%s.%s", Platform.class.getPackage().getName(), OS);
    }

    private static String initOperatingSystem() {
        String osname;
        switch (osname = Platform.getProperty("os.name", "unknown").toLowerCase()) {
            case "mac os x": {
                return DARWIN;
            }
        }
        if (osname.startsWith(WINDOWS)) {
            return WINDOWS;
        }
        if (osname.startsWith("sunos")) {
            return SOLARIS;
        }
        return osname;
    }

    private static String initArchitecture() {
        String arch;
        switch (arch = Platform.getProperty("os.arch", "unknown").toLowerCase()) {
            case "x86": {
                return "i386";
            }
            case "universal": {
                String bits = SafePropertyAccessor.getProperty("sun.arch.data.model");
                if ("32".equals(bits)) {
                    System.setProperty("os.arch", "i386");
                    arch = "i386";
                    break;
                }
                if (!"64".equals(bits)) break;
                System.setProperty("os.arch", "x86_64");
                arch = "x86_64";
            }
        }
        return arch;
    }

    public static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    static {
        IS_IBM = IS_J9 = JVM.equals(OPENJ9) || JVM.equals(IBM);
    }
}

