require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_VMSTAT_H)) {
    eval 'sub _LINUX_VMSTAT_H () {1;}' unless defined(&_LINUX_VMSTAT_H);
    require 'linux/types.ph';
    require 'linux/percpu.ph';
    require 'linux/config.ph';
    require 'linux/mmzone.ph';
    require 'asm/atomic.ph';
    if(defined(&CONFIG_VM_EVENT_COUNTERS)) {
	eval 'sub FOR_ALL_ZONES {
	    my($x) = @_;
    	    eval q($x &_DMA, $x &_DMA32, $x &_NORMAL, $x &_HIGH);
	}' unless defined(&FOR_ALL_ZONES);
	eval("sub PGPGIN () { 0; }") unless defined(&PGPGIN);
	eval("sub PGPGOUT () { 1; }") unless defined(&PGPGOUT);
	eval("sub PSWPIN () { 2; }") unless defined(&PSWPIN);
	eval("sub PSWPOUT () { 3; }") unless defined(&PSWPOUT);
	eval("sub PGFREE () { 4; }") unless defined(&PGFREE);
	eval("sub PGACTIVATE () { 5; }") unless defined(&PGACTIVATE);
	eval("sub PGDEACTIVATE () { 6; }") unless defined(&PGDEACTIVATE);
	eval("sub PGFAULT () { 7; }") unless defined(&PGFAULT);
	eval("sub PGMAJFAULT () { 8; }") unless defined(&PGMAJFAULT);
	eval("sub PGINODESTEAL () { 9; }") unless defined(&PGINODESTEAL);
	eval("sub SLABS_SCANNED () { 10; }") unless defined(&SLABS_SCANNED);
	eval("sub KSWAPD_STEAL () { 11; }") unless defined(&KSWAPD_STEAL);
	eval("sub KSWAPD_INODESTEAL () { 12; }") unless defined(&KSWAPD_INODESTEAL);
	eval("sub PAGEOUTRUN () { 13; }") unless defined(&PAGEOUTRUN);
	eval("sub ALLOCSTALL () { 14; }") unless defined(&ALLOCSTALL);
	eval("sub PGROTATED () { 15; }") unless defined(&PGROTATED);
	eval("sub NR_VM_EVENT_ITEMS () { 16; }") unless defined(&NR_VM_EVENT_ITEMS);
	eval 'sub __count_vm_event {
	    my($item) = @_;
    	    eval q({  &__get_cpu_var( &vm_event_states). $event[$item]++; });
	}' unless defined(&__count_vm_event);
	eval 'sub count_vm_event {
	    my($item) = @_;
    	    eval q({  &get_cpu_var( &vm_event_states). $event[$item]++;  &put_cpu(); });
	}' unless defined(&count_vm_event);
	eval 'sub __count_vm_events {
	    my($item,$delta) = @_;
    	    eval q({  &__get_cpu_var( &vm_event_states). $event[$item] += $delta; });
	}' unless defined(&__count_vm_events);
	eval 'sub count_vm_events {
	    my($item,$delta) = @_;
    	    eval q({  &get_cpu_var( &vm_event_states). $event[$item] += $delta;  &put_cpu(); });
	}' unless defined(&count_vm_events);
    } else {
	eval 'sub get_cpu_vm_events {
	    my($e) = @_;
    	    eval q(0);
	}' unless defined(&get_cpu_vm_events);
	eval 'sub count_vm_event {
	    my($e) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&count_vm_event);
	eval 'sub count_vm_events {
	    my($e,$d) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&count_vm_events);
	eval 'sub __count_vm_event {
	    my($e) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&__count_vm_event);
	eval 'sub __count_vm_events {
	    my($e,$d) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&__count_vm_events);
	eval 'sub vm_events_fold_cpu {
	    my($x) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&vm_events_fold_cpu);
    }
    eval 'sub __count_zone_vm_events {
        my($item, $zone, $delta) = @_;
	    eval q( &__count_vm_events($item &_DMA +  &zone_idx($zone), $delta));
    }' unless defined(&__count_zone_vm_events);
    eval 'sub zone_page_state_add {
        my($x,$zone,$item) = @_;
	    eval q({  &atomic_long_add($x,  ($zone->{vm_stat[$item]}));  &atomic_long_add($x,  $vm_stat[$item]); });
    }' unless defined(&zone_page_state_add);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub global_page_state {
        my($item) = @_;
	    eval q({ my $x =  &atomic_long_read( $vm_stat[$item]);  $x; });
    }' unless defined(&global_page_state);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub zone_page_state {
        my($zone,$item) = @_;
	    eval q({ my $x =  &atomic_long_read( ($zone->{vm_stat[$item]}));  $x; });
    }' unless defined(&zone_page_state);
    if(defined(&CONFIG_NUMA)) {
	unless(defined(&CONFIG_DMA_IS_NORMAL)) {
	    if(!defined( &CONFIG_DMA_IS_DMA32)  && (defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) >= 64) {
	    }
	}
	if(defined(&CONFIG_HIGHMEM)) {
	}
    } else {
	eval 'sub node_page_state {
	    my($node, $item) = @_;
    	    eval q( &global_page_state($item));
	}' unless defined(&node_page_state);
	eval 'sub zone_statistics {
	    my($_zl,$_z) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&zone_statistics);
    }
    eval 'sub __add_zone_page_state {
        my($__z, $__i, $__d) = @_;
	    eval q( &__mod_zone_page_state($__z, $__i, $__d));
    }' unless defined(&__add_zone_page_state);
    eval 'sub __sub_zone_page_state {
        my($__z, $__i, $__d) = @_;
	    eval q( &__mod_zone_page_state($__z, $__i,-($__d)));
    }' unless defined(&__sub_zone_page_state);
    eval 'sub add_zone_page_state {
        my($__z, $__i, $__d) = @_;
	    eval q( &mod_zone_page_state($__z, $__i, $__d));
    }' unless defined(&add_zone_page_state);
    eval 'sub sub_zone_page_state {
        my($__z, $__i, $__d) = @_;
	    eval q( &mod_zone_page_state($__z, $__i, -($__d)));
    }' unless defined(&sub_zone_page_state);
    eval 'sub zap_zone_vm_stats {
        my($zone) = @_;
	    eval q({  &memset( ($zone->{vm_stat}), 0, $sizeof{ ($zone->{vm_stat})}); });
    }' unless defined(&zap_zone_vm_stats);
    if(defined(&CONFIG_SMP)) {
    } else {
	eval 'sub __inc_zone_state {
	    my($zone,$item) = @_;
    	    eval q({  &atomic_long_inc( ($zone->{vm_stat[$item]}));  &atomic_long_inc( $vm_stat[$item]); });
	}' unless defined(&__inc_zone_state);
	eval 'sub __inc_zone_page_state {
	    my($page,$item) = @_;
    	    eval q({  &__inc_zone_state( &page_zone($page), $item); });
	}' unless defined(&__inc_zone_page_state);
	eval 'sub __dec_zone_page_state {
	    my($page,$item) = @_;
    	    eval q({  &atomic_long_dec( &page_zone($page)-> $vm_stat[$item]);  &atomic_long_dec( $vm_stat[$item]); });
	}' unless defined(&__dec_zone_page_state);
	eval 'sub inc_zone_page_state () { &__inc_zone_page_state;}' unless defined(&inc_zone_page_state);
	eval 'sub dec_zone_page_state () { &__dec_zone_page_state;}' unless defined(&dec_zone_page_state);
	eval 'sub mod_zone_page_state () { &__mod_zone_page_state;}' unless defined(&mod_zone_page_state);
    }
}
1;
