require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TIME_H)) {
    eval 'sub _LINUX_TIME_H () {1;}' unless defined(&_LINUX_TIME_H);
    unless(defined(&__KERNEL__)) {
	require 'time.ph';
    } else {
	require 'linux/types.ph';
	if(defined(&__KERNEL__)) {
	    require 'linux/seqlock.ph';
	}
	unless(defined(&_STRUCT_TIMESPEC)) {
	    eval 'sub _STRUCT_TIMESPEC () {1;}' unless defined(&_STRUCT_TIMESPEC);
	}
	if(defined(&__KERNEL__)) {
	    eval 'sub MSEC_PER_SEC () {1000;}' unless defined(&MSEC_PER_SEC);
	    eval 'sub USEC_PER_MSEC () {1000;}' unless defined(&USEC_PER_MSEC);
	    eval 'sub NSEC_PER_USEC () {1000;}' unless defined(&NSEC_PER_USEC);
	    eval 'sub NSEC_PER_MSEC () {1000000;}' unless defined(&NSEC_PER_MSEC);
	    eval 'sub USEC_PER_SEC () {1000000;}' unless defined(&USEC_PER_SEC);
	    eval 'sub NSEC_PER_SEC () {1000000000;}' unless defined(&NSEC_PER_SEC);
	    eval 'sub FSEC_PER_SEC () {1000000000000000;}' unless defined(&FSEC_PER_SEC);
	    eval 'sub timespec_equal {
	        my($a,$b) = @_;
    		eval q({ ( ($a->{tv_sec}) ==  ($b->{tv_sec}))  && ( ($a->{tv_nsec}) ==  ($b->{tv_nsec})); });
	    }' unless defined(&timespec_equal);
	    eval 'sub timeval_compare {
	        my($lhs,$rhs) = @_;
    		eval q({  &if ( ($lhs->{tv_sec}) <  ($rhs->{tv_sec})) -1;  &if ( ($lhs->{tv_sec}) >  ($rhs->{tv_sec})) 1;  ($lhs->{tv_usec}) -  ($rhs->{tv_usec}); });
	    }' unless defined(&timeval_compare);
	    eval 'sub timespec_valid {
	        my($ts) = @_;
    		eval q(((($ts)-> &tv_sec >= 0)  && (( ($ts)-> &tv_nsec) <  &NSEC_PER_SEC)));
	    }' unless defined(&timespec_valid);
	    eval 'sub get_seconds {
	        my($void) = @_;
    		eval q({  ($xtime->{tv_sec}); });
	    }' unless defined(&get_seconds);
	    eval 'sub CURRENT_TIME () {( &current_kernel_time());}' unless defined(&CURRENT_TIME);
	    eval 'sub CURRENT_TIME_SEC () {( {  ($xtime->{tv_sec}), 0});}' unless defined(&CURRENT_TIME_SEC);
	    eval 'sub do_posix_clock_monotonic_gettime {
	        my($ts) = @_;
    		eval q( &ktime_get_ts($ts));
	    }' unless defined(&do_posix_clock_monotonic_gettime);
	}
	eval 'sub NFDBITS () { &__NFDBITS;}' unless defined(&NFDBITS);
	eval 'sub FD_SETSIZE () { &__FD_SETSIZE;}' unless defined(&FD_SETSIZE);
	eval 'sub FD_SET {
	    my($fd,$fdsetp) = @_;
    	    eval q( &__FD_SET($fd,$fdsetp));
	}' unless defined(&FD_SET);
	eval 'sub FD_CLR {
	    my($fd,$fdsetp) = @_;
    	    eval q( &__FD_CLR($fd,$fdsetp));
	}' unless defined(&FD_CLR);
	eval 'sub FD_ISSET {
	    my($fd,$fdsetp) = @_;
    	    eval q( &__FD_ISSET($fd,$fdsetp));
	}' unless defined(&FD_ISSET);
	eval 'sub FD_ZERO {
	    my($fdsetp) = @_;
    	    eval q( &__FD_ZERO($fdsetp));
	}' unless defined(&FD_ZERO);
	eval 'sub ITIMER_REAL () {0;}' unless defined(&ITIMER_REAL);
	eval 'sub ITIMER_VIRTUAL () {1;}' unless defined(&ITIMER_VIRTUAL);
	eval 'sub ITIMER_PROF () {2;}' unless defined(&ITIMER_PROF);
	eval 'sub CLOCK_REALTIME () {0;}' unless defined(&CLOCK_REALTIME);
	eval 'sub CLOCK_MONOTONIC () {1;}' unless defined(&CLOCK_MONOTONIC);
	eval 'sub CLOCK_PROCESS_CPUTIME_ID () {2;}' unless defined(&CLOCK_PROCESS_CPUTIME_ID);
	eval 'sub CLOCK_THREAD_CPUTIME_ID () {3;}' unless defined(&CLOCK_THREAD_CPUTIME_ID);
	eval 'sub CLOCK_SGI_CYCLE () {10;}' unless defined(&CLOCK_SGI_CYCLE);
	eval 'sub MAX_CLOCKS () {16;}' unless defined(&MAX_CLOCKS);
	eval 'sub CLOCKS_MASK () {( &CLOCK_REALTIME |  &CLOCK_MONOTONIC);}' unless defined(&CLOCKS_MASK);
	eval 'sub CLOCKS_MONO () { &CLOCK_MONOTONIC;}' unless defined(&CLOCKS_MONO);
	eval 'sub TIMER_ABSTIME () {0x1;}' unless defined(&TIMER_ABSTIME);
    }
}
1;
