require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_PGTABLE_3LEVEL_H)) {
    eval 'sub _I386_PGTABLE_3LEVEL_H () {1;}' unless defined(&_I386_PGTABLE_3LEVEL_H);
    require 'asm-generic/pgtable-nopud.ph';
    eval 'sub pte_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pte %p(%08lx%08lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e), ($e). &pte_high, ($e). &pte_low));
    }' unless defined(&pte_ERROR);
    eval 'sub pmd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pmd %p(%016Lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pmd_val($e)));
    }' unless defined(&pmd_ERROR);
    eval 'sub pgd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pgd %p(%016Lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pgd_val($e)));
    }' unless defined(&pgd_ERROR);
    eval 'sub pud_none {
        my($pud) = @_;
	    eval q(0);
    }' unless defined(&pud_none);
    eval 'sub pud_bad {
        my($pud) = @_;
	    eval q(0);
    }' unless defined(&pud_bad);
    eval 'sub pud_present {
        my($pud) = @_;
	    eval q(1);
    }' unless defined(&pud_present);
    eval 'sub set_pte_at {
        my($mm,$addr,$ptep,$pteval) = @_;
	    eval q( &set_pte($ptep,$pteval));
    }' unless defined(&set_pte_at);
    eval 'sub __HAVE_ARCH_SET_PTE_ATOMIC () {1;}' unless defined(&__HAVE_ARCH_SET_PTE_ATOMIC);
    eval 'sub set_pte_atomic {
        my($pteptr,$pteval) = @_;
	    eval q( &set_64bit(($pteptr), &pte_val($pteval)));
    }' unless defined(&set_pte_atomic);
    eval 'sub set_pmd {
        my($pmdptr,$pmdval) = @_;
	    eval q( &set_64bit(($pmdptr), &pmd_val($pmdval)));
    }' unless defined(&set_pmd);
    eval 'sub set_pud {
        my($pudptr,$pudval) = @_;
	    eval q((*($pudptr) = ($pudval)));
    }' unless defined(&set_pud);
    eval 'sub pud_page {
        my($pud) = @_;
	    eval q((  &__va( &pud_val($pud) &  &PAGE_MASK)));
    }' unless defined(&pud_page);
    eval 'sub pud_page_kernel {
        my($pud) = @_;
	    eval q((  &__va( &pud_val($pud) &  &PAGE_MASK)));
    }' unless defined(&pud_page_kernel);
    eval 'sub pmd_offset {
        my($pud, $address) = @_;
	    eval q((( &pmd_t *)  &pud_page(*($pud)) +  &pmd_index($address)));
    }' unless defined(&pmd_offset);
    eval 'sub pmd_clear {
        my($pmd) = @_;
	    eval q({  &u32 * &tmp = ( &u32 *)$pmd; * &tmp = 0;  &smp_wmb(); *( &tmp + 1) = 0; });
    }' unless defined(&pmd_clear);
    eval 'sub ptep_get_and_clear {
        my($mm,$addr,$ptep) = @_;
	    eval q({  &pte_t  &res;  ($res->{pte_low}) =  &xchg( ($ptep->{pte_low}), 0);  ($res->{pte_high}) =  ($ptep->{pte_high});  ($ptep->{pte_high}) = 0;  &res; });
    }' unless defined(&ptep_get_and_clear);
    eval 'sub pte_same {
        my($a,$b) = @_;
	    eval q({  ($a->{pte_low}) ==  ($b->{pte_low})  &&  ($a->{pte_high}) ==  ($b->{pte_high}); });
    }' unless defined(&pte_same);
    eval 'sub pte_page {
        my($x) = @_;
	    eval q( &pfn_to_page( &pte_pfn($x)));
    }' unless defined(&pte_page);
    eval 'sub pte_none {
        my($pte) = @_;
	    eval q({ ! ($pte->{pte_low})  && ! ($pte->{pte_high}); });
    }' unless defined(&pte_none);
    eval 'sub pte_pfn {
        my($pte) = @_;
	    eval q({ ( ($pte->{pte_low}) >>  &PAGE_SHIFT) | ( ($pte->{pte_high}) << (32-  &PAGE_SHIFT)); });
    }' unless defined(&pte_pfn);
    eval 'sub pfn_pte {
        my($page_nr,$pgprot) = @_;
	    eval q({  &pte_t  &pte;  ($pte->{pte_high}) = ($page_nr >> (32-  &PAGE_SHIFT)) | ( &pgprot_val($pgprot) >> 32);  ($pte->{pte_high}) &= ( &__supported_pte_mask >> 32);  ($pte->{pte_low}) = (($page_nr <<  &PAGE_SHIFT) |  &pgprot_val($pgprot)) &  &__supported_pte_mask;  &pte; });
    }' unless defined(&pfn_pte);
    eval 'sub pfn_pmd {
        my($page_nr,$pgprot) = @_;
	    eval q({  &__pmd((($page_nr <<  &PAGE_SHIFT) |  &pgprot_val($pgprot)) &  &__supported_pte_mask); });
    }' unless defined(&pfn_pmd);
    eval 'sub pte_to_pgoff {
        my($pte) = @_;
	    eval q((($pte). &pte_high));
    }' unless defined(&pte_to_pgoff);
    eval 'sub pgoff_to_pte {
        my($off) = @_;
	    eval q((( &pte_t) {  &_PAGE_FILE, ($off) }));
    }' unless defined(&pgoff_to_pte);
    eval 'sub PTE_FILE_MAX_BITS () {32;}' unless defined(&PTE_FILE_MAX_BITS);
    eval 'sub __swp_type {
        my($x) = @_;
	    eval q(((($x). &val) & 0x1f));
    }' unless defined(&__swp_type);
    eval 'sub __swp_offset {
        my($x) = @_;
	    eval q((($x). &val >> 5));
    }' unless defined(&__swp_offset);
    eval 'sub __swp_entry {
        my($type, $offset) = @_;
	    eval q((( &swp_entry_t){($type) | ($offset) << 5}));
    }' unless defined(&__swp_entry);
    eval 'sub __pte_to_swp_entry {
        my($pte) = @_;
	    eval q((( &swp_entry_t){ ($pte). &pte_high }));
    }' unless defined(&__pte_to_swp_entry);
    eval 'sub __swp_entry_to_pte {
        my($x) = @_;
	    eval q((( &pte_t){ 0, ($x). &val }));
    }' unless defined(&__swp_entry_to_pte);
    eval 'sub __pmd_free_tlb {
        my($tlb, $x) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&__pmd_free_tlb);
    eval 'sub vmalloc_sync_all () {
        eval q((( &void)0));
    }' unless defined(&vmalloc_sync_all);
}
1;
