require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_APIC_H)) {
    eval 'sub __ASM_APIC_H () {1;}' unless defined(&__ASM_APIC_H);
    require 'linux/pm.ph';
    require 'asm/fixmap.ph';
    require 'asm/apicdef.ph';
    require 'asm/processor.ph';
    require 'asm/system.ph';
    eval 'sub Dprintk () {( &x...);}' unless defined(&Dprintk);
    eval 'sub APIC_QUIET () {0;}' unless defined(&APIC_QUIET);
    eval 'sub APIC_VERBOSE () {1;}' unless defined(&APIC_VERBOSE);
    eval 'sub APIC_DEBUG () {2;}' unless defined(&APIC_DEBUG);
    eval 'sub lapic_disable {
        my($void) = @_;
	    eval q({  &enable_local_apic = -1;  &clear_bit( &X86_FEATURE_APIC,  ($boot_cpu_data->{x86_capability})); });
    }' unless defined(&lapic_disable);
    eval 'sub lapic_enable {
        my($void) = @_;
	    eval q({  &enable_local_apic = 1; });
    }' unless defined(&lapic_enable);
    eval 'sub apic_printk () {( &v,  &s,  &a...)  &do {  &if (( &v) <=  &apic_verbosity)  &printk( &s,  &a); }  &while (0);}' unless defined(&apic_printk);
    if(defined(&CONFIG_X86_LOCAL_APIC)) {
	eval 'sub apic_write_atomic {
	    my($reg,$v) = @_;
    	    eval q({  &xchg(( &volatile my $long *)( &APIC_BASE+$reg), $v); });
	}' unless defined(&apic_write_atomic);
	eval 'sub apic_read {
	    my($reg) = @_;
    	    eval q({ *(( &volatile my $long *)( &APIC_BASE+$reg)); });
	}' unless defined(&apic_read);
	eval 'sub apic_wait_icr_idle {
	    my($void) = @_;
    	    eval q({  &while (  &apic_read(  &APIC_ICR ) &  &APIC_ICR_BUSY )  &cpu_relax(); });
	}' unless defined(&apic_wait_icr_idle);
	if(defined(&CONFIG_X86_GOOD_APIC)) {
	    eval 'sub FORCE_READ_AROUND_WRITE () {0;}' unless defined(&FORCE_READ_AROUND_WRITE);
	    eval 'sub apic_read_around {
	        my($x) = @_;
    		eval q();
	    }' unless defined(&apic_read_around);
	    eval 'sub apic_write_around {
	        my($x,$y) = @_;
    		eval q( &apic_write(($x),($y)));
	    }' unless defined(&apic_write_around);
	} else {
	    eval 'sub FORCE_READ_AROUND_WRITE () {1;}' unless defined(&FORCE_READ_AROUND_WRITE);
	    eval 'sub apic_read_around {
	        my($x) = @_;
    		eval q( &apic_read($x));
	    }' unless defined(&apic_read_around);
	    eval 'sub apic_write_around {
	        my($x,$y) = @_;
    		eval q( &apic_write_atomic(($x),($y)));
	    }' unless defined(&apic_write_around);
	}
	eval 'sub ack_APIC_irq {
	    my($void) = @_;
    	    eval q({  &apic_write_around( &APIC_EOI, 0); });
	}' unless defined(&ack_APIC_irq);
	eval 'sub ARCH_APICTIMER_STOPS_ON_C3 () {1;}' unless defined(&ARCH_APICTIMER_STOPS_ON_C3);
    } else {
    }
}
1;
