require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MD_K_H)) {
    eval 'sub _MD_K_H () {1;}' unless defined(&_MD_K_H);
    require 'linux/kernel.ph';
    eval 'sub MD_RESERVED () {0;}' unless defined(&MD_RESERVED);
    eval 'sub LINEAR () {1;}' unless defined(&LINEAR);
    eval 'sub RAID0 () {2;}' unless defined(&RAID0);
    eval 'sub RAID1 () {3;}' unless defined(&RAID1);
    eval 'sub RAID5 () {4;}' unless defined(&RAID5);
    eval 'sub TRANSLUCENT () {5;}' unless defined(&TRANSLUCENT);
    eval 'sub HSM () {6;}' unless defined(&HSM);
    eval 'sub MULTIPATH () {7;}' unless defined(&MULTIPATH);
    eval 'sub MAX_PERSONALITY () {8;}' unless defined(&MAX_PERSONALITY);
    eval 'sub pers_to_level {
        my($pers) = @_;
	    eval q({  &switch ($pers) {  &case  &MULTIPATH: -4;  &case  &HSM: -3;  &case  &TRANSLUCENT: -2;  &case  &LINEAR: -1;  &case  &RAID0: 0;  &case  &RAID1: 1;  &case  &RAID5: 5; }  &panic(\\"pers_to_level()\\"); 0; });
    }' unless defined(&pers_to_level);
    eval 'sub level_to_pers {
        my($level) = @_;
	    eval q({  &switch ($level) {  &case -4:  &MULTIPATH;  &case -3:  &HSM;  &case -2:  &TRANSLUCENT;  &case -1:  &LINEAR;  &case 0:  &RAID0;  &case 1:  &RAID1;  &case 4:  &case 5:  &RAID5; }  &MD_RESERVED; });
    }' unless defined(&level_to_pers);
    if(((defined(&MINORBITS) ? &MINORBITS : undef) != 8)) {
	die("MD\ doesnt\ handle\ bigger\ kdev\ yet");
    }
    eval 'sub MAX_MD_DEVS () {(1<< &MINORBITS);}' unless defined(&MAX_MD_DEVS);
    eval 'sub kdev_to_mddev {
        my($dev) = @_;
	    eval q({  &if ( &MAJOR($dev) !=  &MD_MAJOR)  &BUG();  ($mddev_map[MINOR($dev)]->{mddev}); });
    }' unless defined(&kdev_to_mddev);
    eval 'sub MAX_CHUNK_SIZE () {(4096*1024);}' unless defined(&MAX_CHUNK_SIZE);
    eval 'sub MD_READAHEAD () { &vm_max_readahead;}' unless defined(&MD_READAHEAD);
    eval 'sub disk_faulty {
        my($d) = @_;
	    eval q({  ($d->{state}) & (1<<  &MD_DISK_FAULTY); });
    }' unless defined(&disk_faulty);
    eval 'sub disk_active {
        my($d) = @_;
	    eval q({  ($d->{state}) & (1<<  &MD_DISK_ACTIVE); });
    }' unless defined(&disk_active);
    eval 'sub disk_sync {
        my($d) = @_;
	    eval q({  ($d->{state}) & (1<<  &MD_DISK_SYNC); });
    }' unless defined(&disk_sync);
    eval 'sub disk_spare {
        my($d) = @_;
	    eval q({ ! &disk_sync($d)  && ! &disk_active($d)  && ! &disk_faulty($d); });
    }' unless defined(&disk_spare);
    eval 'sub disk_removed {
        my($d) = @_;
	    eval q({  ($d->{state}) & (1<<  &MD_DISK_REMOVED); });
    }' unless defined(&disk_removed);
    eval 'sub mark_disk_faulty {
        my($d) = @_;
	    eval q({  ($d->{state}) |= (1<<  &MD_DISK_FAULTY); });
    }' unless defined(&mark_disk_faulty);
    eval 'sub mark_disk_active {
        my($d) = @_;
	    eval q({  ($d->{state}) |= (1<<  &MD_DISK_ACTIVE); });
    }' unless defined(&mark_disk_active);
    eval 'sub mark_disk_sync {
        my($d) = @_;
	    eval q({  ($d->{state}) |= (1<<  &MD_DISK_SYNC); });
    }' unless defined(&mark_disk_sync);
    eval 'sub mark_disk_spare {
        my($d) = @_;
	    eval q({  ($d->{state}) = 0; });
    }' unless defined(&mark_disk_spare);
    eval 'sub mark_disk_removed {
        my($d) = @_;
	    eval q({  ($d->{state}) = (1<<  &MD_DISK_FAULTY) | (1<<  &MD_DISK_REMOVED); });
    }' unless defined(&mark_disk_removed);
    eval 'sub mark_disk_inactive {
        my($d) = @_;
	    eval q({  ($d->{state}) &= ~(1<<  &MD_DISK_ACTIVE); });
    }' unless defined(&mark_disk_inactive);
    eval 'sub mark_disk_nonsync {
        my($d) = @_;
	    eval q({  ($d->{state}) &= ~(1<<  &MD_DISK_SYNC); });
    }' unless defined(&mark_disk_nonsync);
    eval 'sub DISKOP_SPARE_INACTIVE () {0;}' unless defined(&DISKOP_SPARE_INACTIVE);
    eval 'sub DISKOP_SPARE_WRITE () {1;}' unless defined(&DISKOP_SPARE_WRITE);
    eval 'sub DISKOP_SPARE_ACTIVE () {2;}' unless defined(&DISKOP_SPARE_ACTIVE);
    eval 'sub DISKOP_HOT_REMOVE_DISK () {3;}' unless defined(&DISKOP_HOT_REMOVE_DISK);
    eval 'sub DISKOP_HOT_ADD_DISK () {4;}' unless defined(&DISKOP_HOT_ADD_DISK);
    eval 'sub mddev_to_kdev {
        my($mddev) = @_;
	    eval q({  &MKDEV( &MD_MAJOR,  &mdidx($mddev)); });
    }' unless defined(&mddev_to_kdev);
    eval 'sub ITERATE_RDEV_GENERIC {
        my($head,$field,$rdev,$tmp) = @_;
	    eval q( &for ($tmp =  ($head->{next}); $rdev =  &md_list_entry($tmp,  &mdk_rdev_t, $field), $tmp =  ($tmp->{next}),  ($tmp->{prev}) != $head ; ));
    }' unless defined(&ITERATE_RDEV_GENERIC);
    eval 'sub ITERATE_RDEV {
        my($mddev,$rdev,$tmp) = @_;
	    eval q( &ITERATE_RDEV_GENERIC(($mddev)-> &disks, &same_set,$rdev,$tmp));
    }' unless defined(&ITERATE_RDEV);
    eval 'sub ITERATE_RDEV_ORDERED {
        my($mddev,$rdev,$i) = @_;
	    eval q( &for ($i = 0; $rdev =  &find_rdev_nr($mddev, $i), $i <  ($mddev->{nb_dev}); $i++));
    }' unless defined(&ITERATE_RDEV_ORDERED);
    eval 'sub ITERATE_RDEV_ALL {
        my($rdev,$tmp) = @_;
	    eval q( &ITERATE_RDEV_GENERIC( &all_raid_disks, &all,$rdev,$tmp));
    }' unless defined(&ITERATE_RDEV_ALL);
    eval 'sub ITERATE_RDEV_PENDING {
        my($rdev,$tmp) = @_;
	    eval q( &ITERATE_RDEV_GENERIC( &pending_raid_disks, &pending,$rdev,$tmp));
    }' unless defined(&ITERATE_RDEV_PENDING);
    eval 'sub ITERATE_MDDEV {
        my($mddev,$tmp) = @_;
	    eval q( &for ($tmp =  ($all_mddevs->{next}); $mddev =  &md_list_entry($tmp,  &mddev_t,  &all_mddevs), $tmp =  ($tmp->{next}),  ($tmp->{prev}) !=  &all_mddevs ; ));
    }' unless defined(&ITERATE_MDDEV);
    eval 'sub lock_mddev {
        my($mddev) = @_;
	    eval q({  &down_interruptible( ($mddev->{reconfig_sem})); });
    }' unless defined(&lock_mddev);
    eval 'sub unlock_mddev {
        my($mddev) = @_;
	    eval q({  &up( ($mddev->{reconfig_sem})); });
    }' unless defined(&unlock_mddev);
    eval 'sub xchg_values {
        my($x,$y) = @_;
	    eval q( &do {  &__typeof__($x)  &__tmp = $x; $x = $y; $y =  &__tmp; }  &while (0));
    }' unless defined(&xchg_values);
    eval 'sub THREAD_WAKEUP () {0;}' unless defined(&THREAD_WAKEUP);
    eval 'sub MAX_DISKNAME_LEN () {64;}' unless defined(&MAX_DISKNAME_LEN);
    eval 'sub __wait_event_lock_irq {
        my($wq, $condition, $lock) = @_;
	    eval q( &do {  &wait_queue_t  &__wait;  &init_waitqueue_entry(& &__wait,  &current);  &add_wait_queue($wq, & &__wait);  &for (;;) {  &set_current_state( &TASK_UNINTERRUPTIBLE);  &if ($condition)  &break;  &spin_unlock_irq($lock);  &run_task_queue( &tq_disk);  &schedule();  &spin_lock_irq($lock); }  ($current->{state}) =  &TASK_RUNNING;  &remove_wait_queue($wq, & &__wait); }  &while (0));
    }' unless defined(&__wait_event_lock_irq);
    eval 'sub wait_event_lock_irq {
        my($wq, $condition, $lock) = @_;
	    eval q( &do {  &if ($condition)  &break;  &__wait_event_lock_irq($wq, $condition, $lock); }  &while (0));
    }' unless defined(&wait_event_lock_irq);
    eval 'sub __wait_disk_event {
        my($wq, $condition) = @_;
	    eval q( &do {  &wait_queue_t  &__wait;  &init_waitqueue_entry(& &__wait,  &current);  &add_wait_queue($wq, & &__wait);  &for (;;) {  &set_current_state( &TASK_UNINTERRUPTIBLE);  &if ($condition)  &break;  &run_task_queue( &tq_disk);  &schedule(); }  ($current->{state}) =  &TASK_RUNNING;  &remove_wait_queue($wq, & &__wait); }  &while (0));
    }' unless defined(&__wait_disk_event);
    eval 'sub wait_disk_event {
        my($wq, $condition) = @_;
	    eval q( &do {  &if ($condition)  &break;  &__wait_disk_event($wq, $condition); }  &while (0));
    }' unless defined(&wait_disk_event);
}
1;
