untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVeOYR/WSVCwvXE5j06+GNdrNhSuqVqclY4d7HDnKS5i1ZIoRKW91qp7lwG51sZ6laGDrKLpp5F+CtqA4MZUTLwE=

OpenBSD 7.7 errata 013, October 28, 2025:

Ensure the group selected by a TLSv1.3 server for a HelloRetryRequest is
not one for which the client has already sent a key share.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 013_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl
    cd /usr/src/lib/libssl
    make obj
    make
    make install

Index: lib/libssl/ssl_tlsext.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_tlsext.c,v
diff -u -p -r1.154 ssl_tlsext.c
--- lib/libssl/ssl_tlsext.c	9 Jul 2024 12:27:27 -0000	1.154
+++ lib/libssl/ssl_tlsext.c	22 Oct 2025 19:51:53 -0000
@@ -1554,6 +1554,7 @@ tlsext_keyshare_server_process(SSL *s, u
 		for (j = 0; j < server_groups_len; j++) {
 			if (server_groups[j] == client_groups[i]) {
 				client_preferred_group = client_groups[i];
+				s->s3->hs.tls13.server_group = client_preferred_group;
 				preferred_group_found = 1;
 				break;
 			}
Index: lib/libssl/tls13_server.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_server.c,v
diff -u -p -r1.109 tls13_server.c
--- lib/libssl/tls13_server.c	22 Jul 2024 14:47:15 -0000	1.109
+++ lib/libssl/tls13_server.c	22 Oct 2025 19:51:39 -0000
@@ -437,8 +437,6 @@ tls13_server_engage_record_protection(st
 int
 tls13_server_hello_retry_request_send(struct tls13_ctx *ctx, CBB *cbb)
 {
-	int nid;
-
 	ctx->hs->tls13.hrr = 1;
 
 	if (!tls13_synthetic_handshake_message(ctx))
@@ -446,9 +444,7 @@ tls13_server_hello_retry_request_send(st
 
 	if (ctx->hs->key_share != NULL)
 		return 0;
-	if (!tls1_get_supported_group(ctx->ssl, &nid))
-		return 0;
-	if (!tls1_ec_nid2group_id(nid, &ctx->hs->tls13.server_group))
+	if (ctx->hs->tls13.server_group == 0)
 		return 0;
 
 	if (!tls13_server_hello_build(ctx, cbb, 1))
@@ -510,8 +506,6 @@ tls13_server_hello_send(struct tls13_ctx
 		return 0;
 	if (!tls13_servername_process(ctx))
 		return 0;
-
-	ctx->hs->tls13.server_group = 0;
 
 	if (!tls13_server_hello_build(ctx, cbb, 0))
 		return 0;
