untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ10Y65b7rdUbWutqJX+ZS1KnUyRULYuWchpeuQRpaFOWvSHBrCOYChwVTNxyKBGBeaqXYG9ytZ0JOd6euZgovwk=

OpenBSD 7.0 errata 025, September 23, 2022:

In libexpat fix heap use-after-free vulnerability CVE-2022-40674.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 025_expat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libexpat:
    cd /usr/src/lib/libexpat
    make obj
    make
    make install

Index: lib/libexpat/COPYING
===================================================================
RCS file: /cvs/src/lib/libexpat/COPYING,v
retrieving revision 1.4
diff -u -p -r1.4 COPYING
--- lib/libexpat/COPYING	29 Dec 2020 16:59:42 -0000	1.4
+++ lib/libexpat/COPYING	20 Sep 2022 23:15:28 -0000
@@ -1,5 +1,5 @@
 Copyright (c) 1998-2000 Thai Open Source Software Center Ltd and Clark Cooper
-Copyright (c) 2001-2019 Expat maintainers
+Copyright (c) 2001-2022 Expat maintainers
 
 Permission is hereby granted, free of charge, to any person obtaining
 a copy of this software and associated documentation files (the
Index: lib/libexpat/Changes
===================================================================
RCS file: /cvs/src/lib/libexpat/Changes,v
retrieving revision 1.17.2.3
diff -u -p -r1.17.2.3 Changes
--- lib/libexpat/Changes	22 Feb 2022 18:02:41 -0000	1.17.2.3
+++ lib/libexpat/Changes	20 Sep 2022 23:15:28 -0000
@@ -2,6 +2,122 @@ NOTE: We are looking for help with a few
       https://github.com/libexpat/libexpat/labels/help%20wanted
       If you can help, please get in touch.  Thanks!
 
+Release 2.4.9 Tue September 20 2022
+        Security fixes:
+       #629 #640  CVE-2022-40674 -- Heap use-after-free vulnerability in
+                    function doContent. Expected impact is denial of service
+                    or potentially arbitrary code execution.
+
+        Bug fixes:
+            #634  MinGW: Fix mis-compilation for -D__USE_MINGW_ANSI_STDIO=0
+            #614  docs: Fix documentation on effect of switch XML_DTD on
+                    symbol visibility in doc/reference.html
+
+        Other changes:
+            #638  MinGW: Make fix-xmltest-log.sh drop more Wine bug output
+       #596 #625  Autotools: Sync CMake templates with CMake 3.22
+            #608  CMake: Migrate from use of CMAKE_*_POSTFIX to
+                    dedicated variables EXPAT_*_POSTFIX to stop affecting
+                    other projects
+       #597 #599  Windows|CMake: Add missing -DXML_STATIC to test runners
+                    and fuzzers
+       #512 #621  Windows|CMake: Render .def file from a template to fix
+                    linking with -DEXPAT_DTD=OFF and/or -DEXPAT_ATTR_INFO=ON
+       #611 #621  MinGW|CMake: Apply MSVC .def file when linking
+       #622 #624  MinGW|CMake: Sync library name with GNU Autotools,
+                    i.e. produce libexpat-1.dll rather than libexpat.dll
+                    by default.  Filename libexpat.dll.a is unaffected.
+            #632  MinGW|CMake: Set missing variable CMAKE_RC_COMPILER in
+                    toolchain file "cmake/mingw-toolchain.cmake" to avoid
+                    error "windres: Command not found" on e.g. Ubuntu 20.04
+       #597 #627  CMake: Unify inconsistent use of set() and option() in
+                    context of public build time options to take need for
+                    set(.. FORCE) in projects using Expat by means of
+                    add_subdirectory(..) off Expat's users' shoulders
+       #626 #641  Stop exporting API symbols when building a static library
+            #644  Resolve use of deprecated "fgrep" by "grep -F"
+            #620  CMake: Make documentation on variables a bit more consistent
+            #636  CMake: Drop leading whitespace from a #cmakedefine line in
+                    file expat_config.h.cmake
+            #594  xmlwf: Fix harmless variable mix-up in function nsattcmp
+  #592 #593 #610  Address Cppcheck warnings
+            #643  Address Clang 15 compiler warnings
+       #642 #644  Version info bumped from 9:8:8 to 9:9:8;
+                    see https://verbump.de/ for what these numbers do
+
+        Infrastructure:
+       #597 #598  CI: Windows: Start covering MSVC 2022
+            #619  CI: macOS: Migrate off deprecated macOS 10.15
+            #632  CI: Linux: Make migration off deprecated Ubuntu 18.04 work
+            #643  CI: Upgrade Clang from 14 to 15
+            #637  apply-clang-format.sh: Add support for BSD find
+            #633  coverage.sh: Exclude MinGW headers
+            #635  coverage.sh: Fix name collision for -funsigned-char
+
+        Special thanks to:
+            David Faure
+            Felix Wilhelm
+            Frank Bergmann
+            Rhodri James
+            Rosen Penev
+            Thijs Schreijer
+            Vincent Torri
+                 and
+            Google Project Zero
+
+Release 2.4.8 Mon March 28 2022
+        Other changes:
+            #587  pkg-config: Move "-lm" to section "Libs.private"
+            #587  CMake|MSVC: Fix pkg-config section "Libs"
+        #55 #582  CMake|macOS: Start using linker arguments
+                    "-compatibility_version <version>" and
+                    "-current_version <version>" in a way compatible with
+                    GNU Libtool
+       #590 #591  Version info bumped from 9:7:8 to 9:8:8;
+                    see https://verbump.de/ for what these numbers do
+
+        Infrastructure:
+            #589  CI: Upgrade Clang from 13 to 14
+
+        Special thanks to:
+            evpobr
+            Kai Pastor
+            Sam James
+
+Release 2.4.7 Fri March 4 2022
+        Bug fixes:
+       #572 #577  Relax fix to CVE-2022-25236 (introduced with release 2.4.5)
+                    with regard to all valid URI characters (RFC 3986),
+                    i.e. the following set (excluding whitespace):
+                    ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz
+                    0123456789 % -._~ :/?#[]@ !$&'()*+,;=
+
+        Other changes:
+  #555 #570 #581  CMake|Windows: Store Expat version in the DLL
+            #577  Document consequences of namespace separator choices not just
+                    in doc/reference.html but also in header <expat.h>
+            #577  Document Expat's lack of validation of namespace URIs against
+                    RFC 3986, and that the XML 1.0r4 specification doesn't
+                    require Expat to validate namespace URIs, and that Expat
+                    may do more in that regard in future releases.
+                    If you find need for strict RFC 3986 URI validation on
+                    application level today, https://uriparser.github.io/ may
+                    be of interest.
+            #579  Fix documentation of XML_EndDoctypeDeclHandler in <expat.h>
+            #575  Document that a call to XML_FreeContentModel can be done at
+                    a later time from outside the element declaration handler
+            #574  Make hardcoded namespace URIs easier to find in code
+            #573  Update documentation on use of XML_POOR_ENTOPY on Solaris
+       #569 #571  tests: Resolve use of macros NAN and INFINITY for GNU G++
+                    4.8.2 on Solaris.
+       #578 #580  Version info bumped from 9:6:8 to 9:7:8;
+                    see https://verbump.de/ for what these numbers do
+
+        Special thanks to:
+            Jeffrey Walton
+            Johnny Jazeix
+            Thijs Schreijer
+
 Release 2.4.6 Sun February 20 2022
         Bug fixes:
             #566  Fix a regression introduced by the fix for CVE-2022-25313
@@ -156,7 +272,7 @@ Release 2.4.2 Sun December 19 2021
             #498  Autotools: Include files with release archives:
                     - buildconf.sh
                     - fuzz/*.c
-       #507 #519  Autotools: Sync CMake templates
+       #507 #519  Autotools: Sync CMake templates with CMake 3.20
        #495 #524  CMake: MinGW: Fix pkg-config section "Libs" for
                     - non-release build types (e.g. -DCMAKE_BUILD_TYPE=Debug)
                     - multi-config CMake generators (e.g. Ninja Multi-Config)
@@ -230,6 +346,7 @@ Release 2.4.0 Sun May 23 2021
        #468 #469  xmlwf: Improve help output and the xmlwf man page
             #463  xmlwf: Improve maintainability through some refactoring
             #477  xmlwf: Fix man page DocBook validity
+            #456  Autotools: Sync CMake templates with CMake 3.18
        #458 #459  CMake: Support absolute paths for both CMAKE_INSTALL_LIBDIR
                     and CMAKE_INSTALL_INCLUDEDIR
        #471 #481  CMake: Add support for standard variable BUILD_SHARED_LIBS
Index: lib/libexpat/README.md
===================================================================
RCS file: /cvs/src/lib/libexpat/README.md,v
retrieving revision 1.9.2.3
diff -u -p -r1.9.2.3 README.md
--- lib/libexpat/README.md	22 Feb 2022 18:02:41 -0000	1.9.2.3
+++ lib/libexpat/README.md	20 Sep 2022 23:15:28 -0000
@@ -5,7 +5,7 @@
 [![Downloads GitHub](https://img.shields.io/github/downloads/libexpat/libexpat/total?label=Downloads%20GitHub)](https://github.com/libexpat/libexpat/releases)
 
 
-# Expat, Release 2.4.6
+# Expat, Release 2.4.9
 
 This is Expat, a C library for parsing XML, started by
 [James Clark](https://en.wikipedia.org/wiki/James_Clark_%28programmer%29) in 1997.
@@ -222,37 +222,37 @@ CMAKE_INSTALL_PREFIX:PATH=/usr/local
 // Path to a program.
 DOCBOOK_TO_MAN:FILEPATH=/usr/bin/docbook2x-man
 
-// build man page for xmlwf
+// Build man page for xmlwf
 EXPAT_BUILD_DOCS:BOOL=ON
 
-// build the examples for expat library
+// Build the examples for expat library
 EXPAT_BUILD_EXAMPLES:BOOL=ON
 
-// build fuzzers for the expat library
+// Build fuzzers for the expat library
 EXPAT_BUILD_FUZZERS:BOOL=OFF
 
-// build pkg-config file
+// Build pkg-config file
 EXPAT_BUILD_PKGCONFIG:BOOL=ON
 
-// build the tests for expat library
+// Build the tests for expat library
 EXPAT_BUILD_TESTS:BOOL=ON
 
-// build the xmlwf tool for expat library
+// Build the xmlwf tool for expat library
 EXPAT_BUILD_TOOLS:BOOL=ON
 
 // Character type to use (char|ushort|wchar_t) [default=char]
 EXPAT_CHAR_TYPE:STRING=char
 
-// install expat files in cmake install target
+// Install expat files in cmake install target
 EXPAT_ENABLE_INSTALL:BOOL=ON
 
 // Use /MT flag (static CRT) when compiling in MSVC
 EXPAT_MSVC_STATIC_CRT:BOOL=OFF
 
-// build fuzzers via ossfuzz for the expat library
+// Build fuzzers via ossfuzz for the expat library
 EXPAT_OSSFUZZ_BUILD:BOOL=OFF
 
-// build a shared expat library
+// Build a shared expat library
 EXPAT_SHARED_LIBS:BOOL=ON
 
 // Treat all compiler warnings as errors
@@ -261,7 +261,7 @@ EXPAT_WARNINGS_AS_ERRORS:BOOL=OFF
 // Make use of getrandom function (ON|OFF|AUTO) [default=AUTO]
 EXPAT_WITH_GETRANDOM:STRING=AUTO
 
-// utilize libbsd (for arc4random_buf)
+// Utilize libbsd (for arc4random_buf)
 EXPAT_WITH_LIBBSD:BOOL=OFF
 
 // Make use of syscall SYS_getrandom (ON|OFF|AUTO) [default=AUTO]
Index: lib/libexpat/doc/reference.html
===================================================================
RCS file: /cvs/src/lib/libexpat/doc/reference.html,v
retrieving revision 1.13.2.3
diff -u -p -r1.13.2.3 reference.html
--- lib/libexpat/doc/reference.html	22 Feb 2022 18:02:41 -0000	1.13.2.3
+++ lib/libexpat/doc/reference.html	20 Sep 2022 23:15:29 -0000
@@ -18,6 +18,7 @@
    Copyright (c) 2017      Jakub Wilk <jwilk@jwilk.net>
    Copyright (c) 2021      Tomas Korbar <tkorbar@redhat.com>
    Copyright (c) 2021      Nicolas Cavallari <nicolas.cavallari@green-communications.fr>
+   Copyright (c) 2022      Thijs Schreijer <thijs@thijsschreijer.nl>
    Licensed under the MIT license:
 
    Permission is  hereby granted,  free of charge,  to any  person obtaining
@@ -49,7 +50,7 @@
   <div>
     <h1>
       The Expat XML Parser
-      <small>Release 2.4.6</small>
+      <small>Release 2.4.9</small>
     </h1>
   </div>
 <div class="content">
@@ -364,8 +365,12 @@ this is defined, default attribute value
 are reported and attribute value normalization occurs based on the
 type of attributes defined in the external subset.  Without
 this, Expat has a smaller memory footprint and can be faster, but will
-not load external entities or process conditional sections.  This does
-not affect the set of functions available in the API.</dd>
+not load external entities or process conditional sections. If defined, makes
+the functions <code><a 
+href="#XML_SetBillionLaughsAttackProtectionMaximumAmplification">
+XML_SetBillionLaughsAttackProtectionMaximumAmplification</a></code> and <code>
+<a href="#XML_SetBillionLaughsAttackProtectionActivationThreshold">
+XML_SetBillionLaughsAttackProtectionActivationThreshold</a></code> available.</dd>
 
 <dt>XML_NS</dt>
 <dd>When defined, support for the <cite><a href=
@@ -974,6 +979,14 @@ the local part will be concatenated with
 to support RDF processors. It is a programming error to use the null separator
 with <a href= "#XML_SetReturnNSTriplet">namespace triplets</a>.</div>
 
+<p><strong>Note:</strong>
+Expat does not validate namespace URIs (beyond encoding)
+against RFC 3986 today (and is not required to do so with regard to
+the XML 1.0 namespaces specification) but it may start doing that
+in future releases.  Before that, an application using Expat must
+be ready to receive namespace URIs containing non-URI characters.
+</p>
+
 <h4 id="XML_ParserCreate_MM">XML_ParserCreate_MM</h4>
 <pre class="fcndec">
 XML_Parser XMLCALL
@@ -1808,10 +1821,11 @@ struct XML_cp {
 </pre>
 <p>Sets a handler for element declarations in a DTD. The handler gets
 called with the name of the element in the declaration and a pointer
-to a structure that contains the element model. It is the
-application's responsibility to free this data structure using
-<code><a href="#XML_FreeContentModel"
->XML_FreeContentModel</a></code>.</p>
+to a structure that contains the element model. It's the user code's 
+responsibility to free model when finished with it. See <code>
+<a href="#XML_FreeContentModel">XML_FreeContentModel</a></code>.
+There is no need to free the model from the handler, it can be kept
+around and freed at a later stage.</p>
 
 <p>The <code>model</code> argument is the root of a tree of
 <code>XML_Content</code> nodes. If <code>type</code> equals
Index: lib/libexpat/lib/internal.h
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/internal.h,v
retrieving revision 1.9
diff -u -p -r1.9 internal.h
--- lib/libexpat/lib/internal.h	26 May 2021 19:14:32 -0000	1.9
+++ lib/libexpat/lib/internal.h	20 Sep 2022 23:15:29 -0000
@@ -28,7 +28,7 @@
    Copyright (c) 2002-2003 Fred L. Drake, Jr. <fdrake@users.sourceforge.net>
    Copyright (c) 2002-2006 Karl Waclawek <karl@waclawek.net>
    Copyright (c) 2003      Greg Stein <gstein@users.sourceforge.net>
-   Copyright (c) 2016-2021 Sebastian Pipping <sebastian@pipping.org>
+   Copyright (c) 2016-2022 Sebastian Pipping <sebastian@pipping.org>
    Copyright (c) 2018      Yury Gribov <tetra2005@gmail.com>
    Copyright (c) 2019      David Loffredo <loffredo@steptools.com>
    Licensed under the MIT license:
@@ -107,7 +107,9 @@
 
 #include <limits.h> // ULONG_MAX
 
-#if defined(_WIN32) && ! defined(__USE_MINGW_ANSI_STDIO)
+#if defined(_WIN32)                                                            \
+    && (! defined(__USE_MINGW_ANSI_STDIO)                                      \
+        || (1 - __USE_MINGW_ANSI_STDIO - 1 == 0))
 #  define EXPAT_FMT_ULL(midpart) "%" midpart "I64u"
 #  if defined(_WIN64) // Note: modifiers "td" and "zu" do not work for MinGW
 #    define EXPAT_FMT_PTRDIFF_T(midpart) "%" midpart "I64d"
Index: lib/libexpat/lib/siphash.h
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/siphash.h,v
retrieving revision 1.7
diff -u -p -r1.7 siphash.h
--- lib/libexpat/lib/siphash.h	10 May 2021 17:36:48 -0000	1.7
+++ lib/libexpat/lib/siphash.h	20 Sep 2022 23:15:29 -0000
@@ -106,7 +106,7 @@
  * if this code is included and compiled as C++; related GCC warning is:
  * warning: use of C++11 long long integer constant [-Wlong-long]
  */
-#define _SIP_ULL(high, low) (((uint64_t)high << 32) | low)
+#define _SIP_ULL(high, low) ((((uint64_t)high) << 32) | (low))
 
 #define SIP_ROTL(x, b) (uint64_t)(((x) << (b)) | ((x) >> (64 - (b))))
 
Index: lib/libexpat/lib/xmlparse.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmlparse.c,v
retrieving revision 1.29.2.3
diff -u -p -r1.29.2.3 xmlparse.c
--- lib/libexpat/lib/xmlparse.c	22 Feb 2022 18:02:41 -0000	1.29.2.3
+++ lib/libexpat/lib/xmlparse.c	20 Sep 2022 23:15:30 -0000
@@ -1,4 +1,4 @@
-/* a30d2613dcfdef81475a9d1a349134d2d42722172fdaa7d5bb12ed2aa74b9596 (2.4.6+)
+/* 90815a2b2c80c03b2b889fe1d427bb2b9e3282aa065e42784e001db4f23de324 (2.4.9+)
                             __  __            _
                          ___\ \/ /_ __   __ _| |_
                         / _ \\  /| '_ \ / _` | __|
@@ -19,7 +19,7 @@
    Copyright (c) 2016      Gustavo Grieco <gustavo.grieco@imag.fr>
    Copyright (c) 2016      Pascal Cuoq <cuoq@trust-in-soft.com>
    Copyright (c) 2016      Ed Schouten <ed@nuxi.nl>
-   Copyright (c) 2017-2018 Rhodri James <rhodri@wildebeest.org.uk>
+   Copyright (c) 2017-2022 Rhodri James <rhodri@wildebeest.org.uk>
    Copyright (c) 2017      Václav Slavík <vaclav@slavik.io>
    Copyright (c) 2017      Viktor Szakats <commit@vsz.me>
    Copyright (c) 2017      Chanho Park <chanho61.park@samsung.com>
@@ -34,6 +34,7 @@
    Copyright (c) 2019      Vadim Zeitlin <vadim@zeitlins.org>
    Copyright (c) 2021      Dong-hee Na <donghee.na@python.org>
    Copyright (c) 2022      Samanta Navarro <ferivoz@riseup.net>
+   Copyright (c) 2022      Jeffrey Walton <noloader@gmail.com>
    Licensed under the MIT license:
 
    Permission is  hereby granted,  free of charge,  to any  person obtaining
@@ -133,7 +134,7 @@
       * BSD / macOS (including <10.7) (arc4random): HAVE_ARC4RANDOM, \
       * libbsd (arc4random_buf): HAVE_ARC4RANDOM_BUF + HAVE_LIBBSD, \
       * libbsd (arc4random): HAVE_ARC4RANDOM + HAVE_LIBBSD, \
-      * Linux (including <3.17) / BSD / macOS (including <10.7) (/dev/urandom): XML_DEV_URANDOM, \
+      * Linux (including <3.17) / BSD / macOS (including <10.7) / Solaris >=8 (/dev/urandom): XML_DEV_URANDOM, \
       * Windows >=Vista (rand_s): _WIN32. \
     \
     If insist on not using any of these, bypass this error by defining \
@@ -722,6 +723,7 @@ XML_ParserCreateNS(const XML_Char *encod
   return XML_ParserCreate_MM(encodingName, NULL, tmp);
 }
 
+// "xml=http://www.w3.org/XML/1998/namespace"
 static const XML_Char implicitContext[]
     = {ASCII_x,     ASCII_m,     ASCII_l,      ASCII_EQUALS, ASCII_h,
        ASCII_t,     ASCII_t,     ASCII_p,      ASCII_COLON,  ASCII_SLASH,
@@ -3704,12 +3706,124 @@ storeAtts(XML_Parser parser, const ENCOD
   return XML_ERROR_NONE;
 }
 
+static XML_Bool
+is_rfc3986_uri_char(XML_Char candidate) {
+  // For the RFC 3986 ANBF grammar see
+  // https://datatracker.ietf.org/doc/html/rfc3986#appendix-A
+
+  switch (candidate) {
+  // From rule "ALPHA" (uppercase half)
+  case 'A':
+  case 'B':
+  case 'C':
+  case 'D':
+  case 'E':
+  case 'F':
+  case 'G':
+  case 'H':
+  case 'I':
+  case 'J':
+  case 'K':
+  case 'L':
+  case 'M':
+  case 'N':
+  case 'O':
+  case 'P':
+  case 'Q':
+  case 'R':
+  case 'S':
+  case 'T':
+  case 'U':
+  case 'V':
+  case 'W':
+  case 'X':
+  case 'Y':
+  case 'Z':
+
+  // From rule "ALPHA" (lowercase half)
+  case 'a':
+  case 'b':
+  case 'c':
+  case 'd':
+  case 'e':
+  case 'f':
+  case 'g':
+  case 'h':
+  case 'i':
+  case 'j':
+  case 'k':
+  case 'l':
+  case 'm':
+  case 'n':
+  case 'o':
+  case 'p':
+  case 'q':
+  case 'r':
+  case 's':
+  case 't':
+  case 'u':
+  case 'v':
+  case 'w':
+  case 'x':
+  case 'y':
+  case 'z':
+
+  // From rule "DIGIT"
+  case '0':
+  case '1':
+  case '2':
+  case '3':
+  case '4':
+  case '5':
+  case '6':
+  case '7':
+  case '8':
+  case '9':
+
+  // From rule "pct-encoded"
+  case '%':
+
+  // From rule "unreserved"
+  case '-':
+  case '.':
+  case '_':
+  case '~':
+
+  // From rule "gen-delims"
+  case ':':
+  case '/':
+  case '?':
+  case '#':
+  case '[':
+  case ']':
+  case '@':
+
+  // From rule "sub-delims"
+  case '!':
+  case '$':
+  case '&':
+  case '\'':
+  case '(':
+  case ')':
+  case '*':
+  case '+':
+  case ',':
+  case ';':
+  case '=':
+    return XML_TRUE;
+
+  default:
+    return XML_FALSE;
+  }
+}
+
 /* addBinding() overwrites the value of prefix->binding without checking.
    Therefore one must keep track of the old value outside of addBinding().
 */
 static enum XML_Error
 addBinding(XML_Parser parser, PREFIX *prefix, const ATTRIBUTE_ID *attId,
            const XML_Char *uri, BINDING **bindingsPtr) {
+  // "http://www.w3.org/XML/1998/namespace"
   static const XML_Char xmlNamespace[]
       = {ASCII_h,      ASCII_t,     ASCII_t,     ASCII_p,      ASCII_COLON,
          ASCII_SLASH,  ASCII_SLASH, ASCII_w,     ASCII_w,      ASCII_w,
@@ -3720,6 +3834,7 @@ addBinding(XML_Parser parser, PREFIX *pr
          ASCII_e,      ASCII_s,     ASCII_p,     ASCII_a,      ASCII_c,
          ASCII_e,      '\0'};
   static const int xmlLen = (int)sizeof(xmlNamespace) / sizeof(XML_Char) - 1;
+  // "http://www.w3.org/2000/xmlns/"
   static const XML_Char xmlnsNamespace[]
       = {ASCII_h,     ASCII_t,      ASCII_t, ASCII_p, ASCII_COLON,  ASCII_SLASH,
          ASCII_SLASH, ASCII_w,      ASCII_w, ASCII_w, ASCII_PERIOD, ASCII_w,
@@ -3760,14 +3875,26 @@ addBinding(XML_Parser parser, PREFIX *pr
         && (len > xmlnsLen || uri[len] != xmlnsNamespace[len]))
       isXMLNS = XML_FALSE;
 
-    // NOTE: While Expat does not validate namespace URIs against RFC 3986,
-    //       we have to at least make sure that the XML processor on top of
-    //       Expat (that is splitting tag names by namespace separator into
-    //       2- or 3-tuples (uri-local or uri-local-prefix)) cannot be confused
-    //       by an attacker putting additional namespace separator characters
-    //       into namespace declarations.  That would be ambiguous and not to
-    //       be expected.
-    if (parser->m_ns && (uri[len] == parser->m_namespaceSeparator)) {
+    // NOTE: While Expat does not validate namespace URIs against RFC 3986
+    //       today (and is not REQUIRED to do so with regard to the XML 1.0
+    //       namespaces specification) we have to at least make sure, that
+    //       the application on top of Expat (that is likely splitting expanded
+    //       element names ("qualified names") of form
+    //       "[uri sep] local [sep prefix] '\0'" back into 1, 2 or 3 pieces
+    //       in its element handler code) cannot be confused by an attacker
+    //       putting additional namespace separator characters into namespace
+    //       declarations.  That would be ambiguous and not to be expected.
+    //
+    //       While the HTML API docs of function XML_ParserCreateNS have been
+    //       advising against use of a namespace separator character that can
+    //       appear in a URI for >20 years now, some widespread applications
+    //       are using URI characters (':' (colon) in particular) for a
+    //       namespace separator, in practice.  To keep these applications
+    //       functional, we only reject namespaces URIs containing the
+    //       application-chosen namespace separator if the chosen separator
+    //       is a non-URI character with regard to RFC 3986.
+    if (parser->m_ns && (uri[len] == parser->m_namespaceSeparator)
+        && ! is_rfc3986_uri_char(uri[len])) {
       return XML_ERROR_SYNTAX;
     }
   }
@@ -4144,7 +4271,7 @@ processXmlDecl(XML_Parser parser, int is
   const XML_Char *storedEncName = NULL;
   const ENCODING *newEncoding = NULL;
   const char *version = NULL;
-  const char *versionend;
+  const char *versionend = NULL;
   const XML_Char *storedversion = NULL;
   int standalone = -1;
 
@@ -5699,10 +5826,15 @@ internalEntityProcessor(XML_Parser parse
   {
     parser->m_processor = contentProcessor;
     /* see externalEntityContentProcessor vs contentProcessor */
-    return doContent(parser, parser->m_parentParser ? 1 : 0, parser->m_encoding,
-                     s, end, nextPtr,
-                     (XML_Bool)! parser->m_parsingStatus.finalBuffer,
-                     XML_ACCOUNT_DIRECT);
+    result = doContent(parser, parser->m_parentParser ? 1 : 0,
+                       parser->m_encoding, s, end, nextPtr,
+                       (XML_Bool)! parser->m_parsingStatus.finalBuffer,
+                       XML_ACCOUNT_DIRECT);
+    if (result == XML_ERROR_NONE) {
+      if (! storeRawNames(parser))
+        return XML_ERROR_NO_MEMORY;
+    }
+    return result;
   }
 }
 
Index: lib/libexpat/lib/xmltok.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmltok.c,v
retrieving revision 1.13.2.2
diff -u -p -r1.13.2.2 xmltok.c
--- lib/libexpat/lib/xmltok.c	22 Feb 2022 18:02:41 -0000	1.13.2.2
+++ lib/libexpat/lib/xmltok.c	20 Sep 2022 23:15:30 -0000
@@ -21,6 +21,7 @@
    Copyright (c) 2017      José Gutiérrez de la Concha <jose@zeroc.com>
    Copyright (c) 2019      David Loffredo <loffredo@steptools.com>
    Copyright (c) 2021      Dong-hee Na <donghee.na@python.org>
+   Copyright (c) 2022      Martin Ettl <ettl.martin78@googlemail.com>
    Licensed under the MIT license:
 
    Permission is  hereby granted,  free of charge,  to any  person obtaining
@@ -296,7 +297,7 @@ sb_charMatches(const ENCODING *enc, cons
 }
 #else
 /* c is an ASCII character */
-#  define CHAR_MATCHES(enc, p, c) (*(p) == c)
+#  define CHAR_MATCHES(enc, p, c) (*(p) == (c))
 #endif
 
 #define PREFIX(ident) normal_##ident
@@ -740,7 +741,7 @@ DEFINE_UTF16_TO_UTF16(big2_)
   ((p)[1] == 0 ? ((struct normal_encoding *)(enc))->type[(unsigned char)*(p)]  \
                : unicode_byte_type((p)[1], (p)[0]))
 #define LITTLE2_BYTE_TO_ASCII(p) ((p)[1] == 0 ? (p)[0] : -1)
-#define LITTLE2_CHAR_MATCHES(p, c) ((p)[1] == 0 && (p)[0] == c)
+#define LITTLE2_CHAR_MATCHES(p, c) ((p)[1] == 0 && (p)[0] == (c))
 #define LITTLE2_IS_NAME_CHAR_MINBPC(p)                                         \
   UCS2_GET_NAMING(namePages, (unsigned char)p[1], (unsigned char)p[0])
 #define LITTLE2_IS_NMSTRT_CHAR_MINBPC(p)                                       \
@@ -875,7 +876,7 @@ static const struct normal_encoding inte
        ? ((struct normal_encoding *)(enc))->type[(unsigned char)(p)[1]]        \
        : unicode_byte_type((p)[0], (p)[1]))
 #define BIG2_BYTE_TO_ASCII(p) ((p)[0] == 0 ? (p)[1] : -1)
-#define BIG2_CHAR_MATCHES(p, c) ((p)[0] == 0 && (p)[1] == c)
+#define BIG2_CHAR_MATCHES(p, c) ((p)[0] == 0 && (p)[1] == (c))
 #define BIG2_IS_NAME_CHAR_MINBPC(p)                                            \
   UCS2_GET_NAMING(namePages, (unsigned char)p[0], (unsigned char)p[1])
 #define BIG2_IS_NMSTRT_CHAR_MINBPC(p)                                          \
Index: lib/libexpat/lib/xmltok_impl.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmltok_impl.c,v
retrieving revision 1.15.2.1
diff -u -p -r1.15.2.1 xmltok_impl.c
--- lib/libexpat/lib/xmltok_impl.c	22 Feb 2022 18:02:41 -0000	1.15.2.1
+++ lib/libexpat/lib/xmltok_impl.c	20 Sep 2022 23:15:30 -0000
@@ -16,6 +16,7 @@
    Copyright (c) 2018      Anton Maklakov <antmak.pub@gmail.com>
    Copyright (c) 2019      David Loffredo <loffredo@steptools.com>
    Copyright (c) 2020      Boris Kolpackov <boris@codesynthesis.com>
+   Copyright (c) 2022      Martin Ettl <ettl.martin78@googlemail.com>
    Licensed under the MIT license:
 
    Permission is  hereby granted,  free of charge,  to any  person obtaining
@@ -96,7 +97,7 @@
 
 #  define CHECK_NMSTRT_CASE(n, enc, ptr, end, nextTokPtr)                      \
   case BT_LEAD##n:                                                             \
-    if (end - ptr < n)                                                         \
+    if ((end) - (ptr) < (n))                                                   \
       return XML_TOK_PARTIAL_CHAR;                                             \
     if (IS_INVALID_CHAR(enc, ptr, n) || ! IS_NMSTRT_CHAR(enc, ptr, n)) {       \
       *nextTokPtr = ptr;                                                       \
@@ -124,7 +125,8 @@
 #    define PREFIX(ident) ident
 #  endif
 
-#  define HAS_CHARS(enc, ptr, end, count) (end - ptr >= count * MINBPC(enc))
+#  define HAS_CHARS(enc, ptr, end, count)                                      \
+    ((end) - (ptr) >= ((count)*MINBPC(enc)))
 
 #  define HAS_CHAR(enc, ptr, end) HAS_CHARS(enc, ptr, end, 1)
 
Index: lib/libexpat/tests/runtests.c
===================================================================
RCS file: /cvs/src/lib/libexpat/tests/runtests.c,v
retrieving revision 1.12.2.3
diff -u -p -r1.12.2.3 runtests.c
--- lib/libexpat/tests/runtests.c	22 Feb 2022 18:02:41 -0000	1.12.2.3
+++ lib/libexpat/tests/runtests.c	20 Sep 2022 23:15:31 -0000
@@ -54,7 +54,6 @@
 #include <ctype.h>
 #include <limits.h>
 #include <stdint.h> /* intptr_t uint64_t */
-#include <math.h>   /* NAN, INFINITY, isnan */
 
 #if ! defined(__cplusplus)
 #  include <stdbool.h>
@@ -4991,6 +4990,78 @@ START_TEST(test_suspend_resume_internal_
 }
 END_TEST
 
+void
+suspending_comment_handler(void *userData, const XML_Char *data) {
+  UNUSED_P(data);
+  XML_Parser parser = (XML_Parser)userData;
+  XML_StopParser(parser, XML_TRUE);
+}
+
+START_TEST(test_suspend_resume_internal_entity_issue_629) {
+  const char *const text
+      = "<!DOCTYPE a [<!ENTITY e '<!--COMMENT-->a'>]><a>&e;<b>\n"
+        "<"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
+        "/>"
+        "</b></a>";
+  const size_t firstChunkSizeBytes = 54;
+
+  XML_Parser parser = XML_ParserCreate(NULL);
+  XML_SetUserData(parser, parser);
+  XML_SetCommentHandler(parser, suspending_comment_handler);
+
+  if (XML_Parse(parser, text, (int)firstChunkSizeBytes, XML_FALSE)
+      != XML_STATUS_SUSPENDED)
+    xml_failure(parser);
+  if (XML_ResumeParser(parser) != XML_STATUS_OK)
+    xml_failure(parser);
+  if (XML_Parse(parser, text + firstChunkSizeBytes,
+                (int)(strlen(text) - firstChunkSizeBytes), XML_TRUE)
+      != XML_STATUS_OK)
+    xml_failure(parser);
+  XML_ParserFree(parser);
+}
+END_TEST
+
 /* Test syntax error is caught at parse resumption */
 START_TEST(test_resume_entity_with_syntax_error) {
   const char *text = "<!DOCTYPE doc [\n"
@@ -7407,16 +7478,18 @@ START_TEST(test_ns_separator_in_uri) {
   struct test_case {
     enum XML_Status expectedStatus;
     const char *doc;
+    XML_Char namesep;
   };
   struct test_case cases[] = {
-      {XML_STATUS_OK, "<doc xmlns='one_two' />"},
-      {XML_STATUS_ERROR, "<doc xmlns='one&#x0A;two' />"},
+      {XML_STATUS_OK, "<doc xmlns='one_two' />", XCS('\n')},
+      {XML_STATUS_ERROR, "<doc xmlns='one&#x0A;two' />", XCS('\n')},
+      {XML_STATUS_OK, "<doc xmlns='one:two' />", XCS(':')},
   };
 
   size_t i = 0;
   size_t failCount = 0;
   for (; i < sizeof(cases) / sizeof(cases[0]); i++) {
-    XML_Parser parser = XML_ParserCreateNS(NULL, '\n');
+    XML_Parser parser = XML_ParserCreateNS(NULL, cases[i].namesep);
     XML_SetElementHandler(parser, dummy_start_element, dummy_end_element);
     if (XML_Parse(parser, cases[i].doc, (int)strlen(cases[i].doc),
                   /*isFinal*/ XML_TRUE)
@@ -11762,6 +11835,16 @@ START_TEST(test_accounting_precision) {
 }
 END_TEST
 
+static float
+portableNAN(void) {
+  return strtof("nan", NULL);
+}
+
+static float
+portableINFINITY(void) {
+  return strtof("infinity", NULL);
+}
+
 START_TEST(test_billion_laughs_attack_protection_api) {
   XML_Parser parserWithoutParent = XML_ParserCreate(NULL);
   XML_Parser parserWithParent
@@ -11780,7 +11863,7 @@ START_TEST(test_billion_laughs_attack_pr
       == XML_TRUE)
     fail("Call with non-root parser is NOT supposed to succeed");
   if (XML_SetBillionLaughsAttackProtectionMaximumAmplification(
-          parserWithoutParent, NAN)
+          parserWithoutParent, portableNAN())
       == XML_TRUE)
     fail("Call with NaN limit is NOT supposed to succeed");
   if (XML_SetBillionLaughsAttackProtectionMaximumAmplification(
@@ -11802,7 +11885,7 @@ START_TEST(test_billion_laughs_attack_pr
       == XML_FALSE)
     fail("Call with positive limit >=1.0 is supposed to succeed");
   if (XML_SetBillionLaughsAttackProtectionMaximumAmplification(
-          parserWithoutParent, INFINITY)
+          parserWithoutParent, portableINFINITY())
       == XML_FALSE)
     fail("Call with positive limit >=1.0 is supposed to succeed");
 
@@ -12005,6 +12088,8 @@ make_suite(void) {
   tcase_add_test(tc_basic, test_partial_char_in_epilog);
   tcase_add_test(tc_basic, test_hash_collision);
   tcase_add_test__ifdef_xml_dtd(tc_basic, test_suspend_resume_internal_entity);
+  tcase_add_test__ifdef_xml_dtd(tc_basic,
+                                test_suspend_resume_internal_entity_issue_629);
   tcase_add_test__ifdef_xml_dtd(tc_basic, test_resume_entity_with_syntax_error);
   tcase_add_test__ifdef_xml_dtd(tc_basic, test_suspend_resume_parameter_entity);
   tcase_add_test(tc_basic, test_restart_on_error);
