untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46LifZ085IflYKnJj6bispDknBHFg7MqG+DF4cz9z6wVXXPtrQ55HF7QMi2KeDaXgOfHbk+egfz9sNCtXxXoUPAk=

OpenBSD 6.9 errata 036, April 11, 2022:

rpki-client(8) handled time zones incorrectly.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 036_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install rpki-client
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/parser.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/parser.c,v
retrieving revision 1.7.2.1
diff -u -p -r1.7.2.1 parser.c
--- usr.sbin/rpki-client/parser.c	9 Nov 2021 13:41:19 -0000	1.7.2.1
+++ usr.sbin/rpki-client/parser.c	9 Apr 2022 14:11:59 -0000
@@ -376,8 +376,8 @@ proc_parser_crl(struct entity *entp, con
 			warnx("%s: ASN1_time_parse failed", entp->file);
 			goto err;
 		}
-		if ((crl->expires = mktime(&expires_tm)) == -1)
-			errx(1, "%s: mktime failed", entp->file);
+		if ((crl->expires = timegm(&expires_tm)) == -1)
+			errx(1, "%s: timegm failed", entp->file);
 
 		if (RB_INSERT(crl_tree, &crlt, crl) != NULL) {
 			warnx("%s: duplicate AKI %s", entp->file, crl->aki);
Index: usr.sbin/rpki-client/roa.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/roa.c,v
retrieving revision 1.17.2.1
diff -u -p -r1.17.2.1 roa.c
--- usr.sbin/rpki-client/roa.c	9 Nov 2021 13:41:19 -0000	1.17.2.1
+++ usr.sbin/rpki-client/roa.c	9 Apr 2022 14:11:59 -0000
@@ -374,8 +374,8 @@ roa_parse(X509 **x509, const char *fn, c
 		warnx("%s: ASN1_time_parse failed", fn);
 		goto out;
 	}
-	if ((expires = mktime(&expires_tm)) == -1)
-		errx(1, "mktime failed");
+	if ((expires = timegm(&expires_tm)) == -1)
+		errx(1, "timegm failed");
 
 	p.res->expires = expires;
 
Index: usr.sbin/rpki-client/x509.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/x509.c,v
retrieving revision 1.21.2.1
diff -u -p -r1.21.2.1 x509.c
--- usr.sbin/rpki-client/x509.c	9 Nov 2021 13:41:19 -0000	1.21.2.1
+++ usr.sbin/rpki-client/x509.c	9 Apr 2022 14:11:59 -0000
@@ -320,8 +320,8 @@ x509_get_expire(X509 *x, const char *fn,
 		warnx("%s: ASN1_time_parse failed", fn);
 		return 0;
 	}
-	if ((expires = mktime(&expires_tm)) == -1)
-		errx(1, "%s: mktime failed", fn);
+	if ((expires = timegm(&expires_tm)) == -1)
+		errx(1, "%s: timegm failed", fn);
 
 	*tt = expires;
 	return 1;
