untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT8gh/KmURKV6BkIwGDhe7xETLy5YtKaudntSP5lhwXE2Rj0bORr987D0/SoYshaudwcIChbPGsJhvLN9SZ8hQQA=

OpenBSD 6.5 errata 037, May 13, 2020:

An out-of-bounds index access in wscons(4) can cause a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 037_wscons.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/wscons/wsdisplay.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsdisplay.c,v
retrieving revision 1.131
diff -u -p -r1.131 wsdisplay.c
--- sys/dev/wscons/wsdisplay.c	19 Feb 2018 08:59:52 -0000	1.131
+++ sys/dev/wscons/wsdisplay.c	10 May 2020 20:51:38 -0000
@@ -1242,7 +1242,7 @@ wsdisplay_internal_ioctl(struct wsdispla
 
 	case WSDISPLAYIO_GETSCREENTYPE:
 #define d ((struct wsdisplay_screentype *)data)
-		if (d->idx >= sc->sc_scrdata->nscreens)
+		if (d->idx < 0 || d->idx >= sc->sc_scrdata->nscreens)
 			return(EINVAL);
 
 		d->nidx = sc->sc_scrdata->nscreens;
Index: sys/dev/wscons/wsemulconf.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsemulconf.c,v
retrieving revision 1.9
diff -u -p -r1.9 wsemulconf.c
--- sys/dev/wscons/wsemulconf.c	14 Mar 2015 03:38:50 -0000	1.9
+++ sys/dev/wscons/wsemulconf.c	10 May 2020 20:51:38 -0000
@@ -78,7 +78,7 @@ wsemul_pick(const char *name)
 const char *
 wsemul_getname(int idx)
 {
-	if (idx >= nitems(wsemul_conf) - 1)
+	if (idx < 0 || idx >= nitems(wsemul_conf) - 1)
 		return (NULL);
 	return (wsemul_conf[idx]->name);
 }
