/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.lang.ref.SoftReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalVariantGraphResolveStateBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder,
HoldsProjectState {
    private final DomainObjectContext owner;
    private final DependencyMetaDataProvider componentIdentity;
    private final ConfigurationsProvider configurationsProvider;
    private final AttributesSchemaInternal schema;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
    private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
    private final LocalVariantGraphResolveStateBuilder variantStateBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Factory factory;
    private final MetadataHolder holder;

    private DefaultRootComponentMetadataBuilder(DomainObjectContext owner, DependencyMetaDataProvider componentIdentity, ConfigurationsProvider configurationsProvider, AttributesSchemaInternal schema, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentGraphResolveStateFactory localResolveStateFactory, ImmutableAttributesSchemaFactory attributesSchemaFactory, LocalVariantGraphResolveStateBuilder variantStateBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory, Factory factory) {
        this.owner = owner;
        this.componentIdentity = componentIdentity;
        this.configurationsProvider = configurationsProvider;
        this.schema = schema;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.localResolveStateFactory = localResolveStateFactory;
        this.attributesSchemaFactory = attributesSchemaFactory;
        this.variantStateBuilder = variantStateBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.factory = factory;
        this.holder = new MetadataHolder();
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent(final String configurationName) {
        Module module = this.componentIdentity.getModule();
        String status = module.getStatus();
        ComponentIdentifier componentIdentifier = module.getComponentId();
        ModuleVersionIdentifier moduleVersionId = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ImmutableAttributesSchema immutableSchema = this.attributesSchemaFactory.create(this.schema);
        LocalComponentGraphResolveMetadata metadata = new LocalComponentGraphResolveMetadata(moduleVersionId, componentIdentifier, status, immutableSchema);
        final LocalComponentGraphResolveState rootComponent = this.getComponentState(this.owner, metadata);
        final Lazy rootVariant = Lazy.unsafe().of(() -> {
            ConfigurationInternal resolvedConf = this.configurationsProvider.findByName(configurationName);
            if (resolvedConf == null) {
                throw new IllegalStateException(String.format("Expected root variant '%s' to be present in %s", configurationName, rootComponent.getId()));
            }
            return this.variantStateBuilder.createRootVariantState(resolvedConf, componentIdentifier, new LocalVariantGraphResolveStateBuilder.DependencyCache(), this.owner.getModel(), this.calculatedValueContainerFactory);
        });
        return new RootComponentMetadataBuilder.RootComponentState(){

            @Override
            public LocalComponentGraphResolveState getRootComponent() {
                return rootComponent;
            }

            @Override
            public LocalVariantGraphResolveState getRootVariant() {
                return (LocalVariantGraphResolveState)rootVariant.get();
            }

            @Override
            public boolean hasRootVariant() {
                return DefaultRootComponentMetadataBuilder.this.configurationsProvider.findByName(configurationName) != null;
            }
        };
    }

    @Override
    public DependencyMetaDataProvider getComponentIdentity() {
        return this.componentIdentity;
    }

    private LocalComponentGraphResolveState getComponentState(DomainObjectContext domainObjectContext, LocalComponentGraphResolveMetadata metadata) {
        LocalComponentGraphResolveState result;
        LocalComponentGraphResolveState state = this.holder.tryCached(metadata.getId());
        if (state != null) {
            return state;
        }
        ModelContainer model = domainObjectContext.getModel();
        if (this.shouldCacheResolutionState()) {
            result = this.localResolveStateFactory.stateFor(model, metadata, this.configurationsProvider);
            this.holder.cache(result, true);
        } else {
            result = this.localResolveStateFactory.adHocStateFor(model, metadata, this.configurationsProvider);
            this.holder.cache(result, false);
        }
        return result;
    }

    private boolean shouldCacheResolutionState() {
        return !this.configurationsProvider.isFixedSize() || this.configurationsProvider.size() > 1;
    }

    @Override
    public RootComponentMetadataBuilder newBuilder(DependencyMetaDataProvider identity, ConfigurationsProvider provider) {
        return this.factory.create(this.owner, provider, identity, this.schema);
    }

    @Override
    public MutationValidator getValidator() {
        return this.holder;
    }

    public void discardAll() {
        this.holder.discard();
    }

    @ServiceScope(value={Scope.Project.class})
    public static class Factory {
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
        private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
        private final LocalVariantGraphResolveStateBuilder variantStateBuilder;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;

        @Inject
        public Factory(ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentGraphResolveStateFactory localResolveStateFactory, ImmutableAttributesSchemaFactory attributesSchemaFactory, LocalVariantGraphResolveStateBuilder variantStateBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.localResolveStateFactory = localResolveStateFactory;
            this.attributesSchemaFactory = attributesSchemaFactory;
            this.variantStateBuilder = variantStateBuilder;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        public RootComponentMetadataBuilder create(DomainObjectContext owner, ConfigurationsProvider configurationsProvider, DependencyMetaDataProvider componentIdentity, AttributesSchemaInternal schema) {
            return new DefaultRootComponentMetadataBuilder(owner, componentIdentity, configurationsProvider, schema, this.moduleIdentifierFactory, this.localResolveStateFactory, this.attributesSchemaFactory, this.variantStateBuilder, this.calculatedValueContainerFactory, this);
        }
    }

    private static class MetadataHolder
    implements MutationValidator {
        @Nullable
        private SoftReference<LocalComponentGraphResolveState> reference;
        @Nullable
        private LocalComponentGraphResolveState cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            LocalComponentGraphResolveState value;
            if (type != MutationValidator.MutationType.STRATEGY && (value = this.currentValue()) != null) {
                value.reevaluate();
            }
        }

        @Nullable
        LocalComponentGraphResolveState tryCached(ComponentIdentifier id) {
            LocalComponentGraphResolveState value = this.currentValue();
            assert (value == null || value.getId().equals(id));
            return value;
        }

        @Nullable
        private LocalComponentGraphResolveState currentValue() {
            if (this.reference != null) {
                return this.reference.get();
            }
            return this.cachedValue;
        }

        public void discard() {
            this.reference = null;
            this.cachedValue = null;
        }

        public void cache(LocalComponentGraphResolveState state, boolean useStrongReference) {
            if (useStrongReference) {
                this.reference = null;
                this.cachedValue = state;
            } else {
                this.reference = new SoftReference<LocalComponentGraphResolveState>(state);
                this.cachedValue = null;
            }
        }
    }
}

