/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.quarkus.hibernate.cache.AbstractDomainDataAccess;
import org.infinispan.quarkus.hibernate.cache.DomainDataRegionImpl;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;

final class ReadWriteNaturalDataAccess
extends AbstractDomainDataAccess
implements NaturalIdDataAccess {
    ReadWriteNaturalDataAccess(InternalDataAccess internal, DomainDataRegionImpl region) {
        super(internal, region);
    }

    public AccessType getAccessType() {
        return AccessType.READ_WRITE;
    }

    public Object generateCacheKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.region.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object getNaturalIdValues(Object cacheKey) {
        return this.region.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) {
        return this.internal.insert(session, key, value, null);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) {
        return this.internal.afterInsert(session, key, value, null);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) {
        return this.internal.update(session, key, value, null, null);
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) {
        return this.internal.afterUpdate(session, key, value, null, null, lock);
    }
}

