/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.io.StorageRandomAccessFile;

public class VirtualRandomAccessFile
implements StorageRandomAccessFile {
    private final DataStoreEntry entry;
    private final boolean _readOnly;
    private long fp;
    private final BlockedByteArrayInputStream bIn;
    private final DataInputStream dIs;
    private final BlockedByteArrayOutputStream bOut;
    private final DataOutputStream dOs;

    public VirtualRandomAccessFile(DataStoreEntry entry, boolean readOnly) throws FileNotFoundException {
        this.entry = entry;
        this._readOnly = readOnly;
        this.bIn = entry.getInputStream();
        this.bIn.setPosition(0L);
        this.dIs = new DataInputStream(this.bIn);
        if (readOnly) {
            this.bOut = null;
            this.dOs = null;
        } else {
            this.bOut = entry.getOutputStream(true);
            this.bOut.setPosition(0L);
            this.dOs = new DataOutputStream(this.bOut);
        }
    }

    @Override
    public VirtualRandomAccessFile clone() {
        try {
            return new VirtualRandomAccessFile(this.entry, this._readOnly);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void close() throws IOException {
        this.dIs.close();
        if (this.dOs != null) {
            this.dOs.close();
        }
        this.fp = Long.MIN_VALUE;
    }

    @Override
    public long getFilePointer() {
        return this.fp;
    }

    @Override
    public long length() {
        return this.entry.length();
    }

    @Override
    public void seek(long newFilePointer) throws IOException {
        if (newFilePointer < 0L) {
            throw new IOException("Negative position: " + newFilePointer);
        }
        this.fp = newFilePointer;
        this.bIn.setPosition(newFilePointer);
        if (this.bOut != null) {
            this.bOut.setPosition(newFilePointer);
        }
    }

    @Override
    public void setLength(long newLength) {
        if (this.bOut == null) {
            throw new NullPointerException();
        }
        this.entry.setLength(newLength);
        if (newLength < this.fp) {
            this.fp = newLength;
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.bIn.read(b, off, len);
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dIs.readFully(b, off, len);
        this.fp = this.bIn.getPosition();
    }

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        long skipped = Math.min((long)n, this.entry.length() - this.fp);
        this.fp += skipped;
        return (int)skipped;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean ret = this.dIs.readBoolean();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public byte readByte() throws IOException {
        byte ret = this.dIs.readByte();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ret = this.dIs.readUnsignedByte();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public short readShort() throws IOException {
        short ret = this.dIs.readShort();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ret = this.dIs.readUnsignedShort();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public char readChar() throws IOException {
        char ret = this.dIs.readChar();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public int readInt() throws IOException {
        int ret = this.dIs.readInt();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public long readLong() throws IOException {
        long ret = this.dIs.readLong();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public float readFloat() throws IOException {
        float ret = this.dIs.readFloat();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public double readDouble() throws IOException {
        double ret = this.dIs.readDouble();
        this.fp = this.bIn.getPosition();
        return ret;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    @Override
    public String readUTF() throws IOException {
        String utfStr = this.dIs.readUTF();
        this.fp = this.bIn.getPosition();
        return utfStr;
    }

    @Override
    public void write(int b) throws IOException {
        this.dOs.write(b);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dOs.write(b, off, len);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dOs.writeBoolean(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dOs.writeByte(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dOs.writeShort(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dOs.writeChar(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dOs.writeInt(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dOs.writeLong(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dOs.writeFloat(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dOs.writeDouble(v);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dOs.writeBytes(s);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dOs.writeChars(s);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.dOs.writeUTF(s);
        this.fp = this.bOut.getPosition();
    }
}

