# -*- coding: utf-8 -*- #
# Copyright 2025 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Utilities for the cloud monitoring API."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.api_lib.util import apis

API_NAME = 'monitoring'
API_VERSION = 'v3'


def GetClientInstance(no_http=False):
  return apis.GetClientInstance(API_NAME, API_VERSION, no_http=no_http)


def GetMessagesModule(client=None):
  if client is None:
    client = GetClientInstance()
  return client.MESSAGES_MODULE
