/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssociateAddressRequestMarshaller
implements Marshaller<Request<AssociateAddressRequest>, AssociateAddressRequest> {
    public Request<AssociateAddressRequest> marshall(AssociateAddressRequest associateAddressRequest) {
        if (associateAddressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateAddressRequest, "AmazonEC2");
        request.addParameter("Action", "AssociateAddress");
        request.addParameter("Version", "2015-04-15");
        if (associateAddressRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)associateAddressRequest.isDryRun()));
        }
        if (associateAddressRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)associateAddressRequest.getInstanceId()));
        }
        if (associateAddressRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)associateAddressRequest.getPublicIp()));
        }
        if (associateAddressRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)associateAddressRequest.getAllocationId()));
        }
        if (associateAddressRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)associateAddressRequest.getNetworkInterfaceId()));
        }
        if (associateAddressRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)associateAddressRequest.getPrivateIpAddress()));
        }
        if (associateAddressRequest.isAllowReassociation() != null) {
            request.addParameter("AllowReassociation", StringUtils.fromBoolean((Boolean)associateAddressRequest.isAllowReassociation()));
        }
        return request;
    }
}

