/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NavigilProtocolDecoder
extends BaseProtocolDecoder {
    private static final int LEAP_SECONDS_DELTA = 25;
    public static final int MSG_ERROR = 2;
    public static final int MSG_INDICATION = 4;
    public static final int MSG_CONN_OPEN = 5;
    public static final int MSG_CONN_CLOSE = 6;
    public static final int MSG_SYSTEM_REPORT = 7;
    public static final int MSG_UNIT_REPORT = 8;
    public static final int MSG_GEOFENCE_ALARM = 10;
    public static final int MSG_INPUT_ALARM = 11;
    public static final int MSG_TG2_REPORT = 12;
    public static final int MSG_POSITION_REPORT = 13;
    public static final int MSG_POSITION_REPORT_2 = 15;
    public static final int MSG_SNAPSHOT4 = 17;
    public static final int MSG_TRACKING_DATA = 18;
    public static final int MSG_MOTION_ALARM = 19;
    public static final int MSG_ACKNOWLEDGEMENT = 255;
    private int senderSequenceNumber = 1;

    public NavigilProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static Date convertTimestamp(long timestamp) {
        return new Date((timestamp - 25L) * 1000L);
    }

    private void sendAcknowledgment(Channel channel, int sequenceNumber) {
        ByteBuf data = Unpooled.buffer((int)4);
        data.writeShortLE(sequenceNumber);
        data.writeShortLE(0);
        ByteBuf header = Unpooled.buffer((int)20);
        header.writeByte(1);
        header.writeByte(0);
        header.writeShortLE(this.senderSequenceNumber++);
        header.writeShortLE(255);
        header.writeShortLE(header.capacity() + data.capacity());
        header.writeShortLE(0);
        header.writeShortLE(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, data.nioBuffer()));
        header.writeIntLE(0);
        header.writeIntLE((int)(System.currentTimeMillis() / 1000L) + 25);
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, data}), channel.remoteAddress()));
        }
    }

    private Position parseUnitReport(DeviceSession deviceSession, ByteBuf buf, int sequenceNumber) {
        Position position = new Position(this.getProtocolName());
        position.setValid(true);
        position.set("index", sequenceNumber);
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedShortLE();
        position.set("flags", buf.readUnsignedShortLE());
        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
        position.setAltitude(buf.readUnsignedShortLE());
        position.set("sat", buf.readUnsignedShortLE());
        position.set("satVisible", buf.readUnsignedShortLE());
        position.set("gpsAntennaState", buf.readUnsignedShortLE());
        position.setSpeed((double)buf.readUnsignedShortLE() * 0.194384);
        position.setCourse(buf.readUnsignedShortLE());
        position.set("odometer", buf.readUnsignedIntLE());
        position.set("distance", buf.readUnsignedIntLE());
        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
        position.set("charge", buf.readUnsignedShortLE());
        position.setTime(NavigilProtocolDecoder.convertTimestamp(buf.readUnsignedIntLE()));
        return position;
    }

    private Position parseTg2Report(DeviceSession deviceSession, ByteBuf buf, int sequenceNumber) {
        Position position = new Position(this.getProtocolName());
        position.setValid(true);
        position.set("index", sequenceNumber);
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedShortLE();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        position.setTime(NavigilProtocolDecoder.convertTimestamp(buf.readUnsignedIntLE()));
        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
        position.setAltitude(buf.readUnsignedShortLE());
        position.set("sat", buf.readUnsignedByte());
        position.set("satVisible", buf.readUnsignedByte());
        position.setSpeed((double)buf.readUnsignedShortLE() * 0.194384);
        position.setCourse(buf.readUnsignedShortLE());
        position.set("odometer", buf.readUnsignedIntLE());
        position.set("maximumSpeed", buf.readUnsignedShortLE());
        position.set("minimumSpeed", buf.readUnsignedShortLE());
        position.set("io1", buf.readUnsignedShortLE());
        position.set("io2", buf.readUnsignedShortLE());
        position.set("io3", buf.readUnsignedShortLE());
        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
        return position;
    }

    private Position parsePositionReport(DeviceSession deviceSession, ByteBuf buf, int sequenceNumber, long timestamp) {
        Position position = new Position(this.getProtocolName());
        position.set("index", sequenceNumber);
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(NavigilProtocolDecoder.convertTimestamp(timestamp));
        position.setLatitude((double)buf.readMediumLE() * 2.0E-5);
        position.setLongitude((double)buf.readMediumLE() * 2.0E-5);
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        position.setCourse(buf.readUnsignedByte() * 2);
        short flags = buf.readUnsignedByte();
        position.setValid((flags & 0x80) == 128 && (flags & 0x40) == 64);
        buf.readUnsignedByte();
        return position;
    }

    private Position parsePositionReport2(DeviceSession deviceSession, ByteBuf buf, int sequenceNumber, long timestamp) {
        Position position = new Position(this.getProtocolName());
        position.set("index", sequenceNumber);
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(NavigilProtocolDecoder.convertTimestamp(timestamp));
        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
        buf.readUnsignedByte();
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        short flags = buf.readUnsignedByte();
        position.setValid((flags & 0x80) == 128 && (flags & 0x40) == 64);
        position.set("sat", buf.readUnsignedByte());
        position.set("odometer", buf.readUnsignedIntLE());
        return position;
    }

    private Position parseSnapshot4(DeviceSession deviceSession, ByteBuf buf, int sequenceNumber) {
        Position position = new Position(this.getProtocolName());
        position.set("index", sequenceNumber);
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        long flags = buf.readUnsignedIntLE();
        position.setValid((flags & 0x400L) == 1024L);
        position.setTime(NavigilProtocolDecoder.convertTimestamp(buf.readUnsignedIntLE()));
        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
        position.setAltitude(buf.readUnsignedShortLE());
        position.set("sat", buf.readUnsignedByte());
        position.set("satVisible", buf.readUnsignedByte());
        position.setSpeed((double)buf.readUnsignedShortLE() * 0.194384);
        position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
        position.set("maximumSpeed", buf.readUnsignedByte());
        position.set("minimumSpeed", buf.readUnsignedByte());
        position.set("odometer", buf.readUnsignedIntLE());
        position.set("io1", buf.readUnsignedByte());
        position.set("io2", buf.readUnsignedByte());
        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
        return position;
    }

    private Position parseTrackingData(DeviceSession deviceSession, ByteBuf buf, int sequenceNumber, long timestamp) {
        Position position = new Position(this.getProtocolName());
        position.set("index", sequenceNumber);
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(NavigilProtocolDecoder.convertTimestamp(timestamp));
        buf.readUnsignedByte();
        short flags = buf.readUnsignedByte();
        position.setValid((flags & 1) == 1);
        buf.readUnsignedShortLE();
        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        position.setCourse((double)buf.readUnsignedByte() * 2.0);
        position.set("sat", buf.readUnsignedByte());
        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
        position.set("odometer", buf.readUnsignedIntLE());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        int sequenceNumber = buf.readUnsignedShortLE();
        int messageId = buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        int flags = buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(buf.readUnsignedIntLE()));
        if (deviceSession == null) {
            return null;
        }
        long timestamp = buf.readUnsignedIntLE();
        if ((flags & 1) == 0) {
            this.sendAcknowledgment(channel, sequenceNumber);
        }
        return switch (messageId) {
            case 8 -> this.parseUnitReport(deviceSession, buf, sequenceNumber);
            case 12 -> this.parseTg2Report(deviceSession, buf, sequenceNumber);
            case 13 -> this.parsePositionReport(deviceSession, buf, sequenceNumber, timestamp);
            case 15 -> this.parsePositionReport2(deviceSession, buf, sequenceNumber, timestamp);
            case 17 -> this.parseSnapshot4(deviceSession, buf, sequenceNumber);
            case 18 -> this.parseTrackingData(deviceSession, buf, sequenceNumber, timestamp);
            default -> null;
        };
    }
}

