/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.keycloak.client.admin.cli.CmdStdinContext;
import org.keycloak.client.admin.cli.ReflectionUtil;
import org.keycloak.client.admin.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.AccessibleBufferOutputStream;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.Header;
import org.keycloak.client.cli.util.Headers;
import org.keycloak.client.cli.util.HeadersBody;
import org.keycloak.client.cli.util.HeadersBodyStatus;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OutputFormat;
import org.keycloak.client.cli.util.OutputUtil;
import org.keycloak.client.cli.util.ParseUtil;
import org.keycloak.client.cli.util.ReturnFields;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

public abstract class AbstractRequestCmd
extends AbstractAuthOptionsCmd {
    String file;
    String body;
    String fields;
    boolean printHeaders;
    boolean returnId;
    boolean outputResult;
    boolean compressed;
    boolean unquoted;
    boolean mergeMode;
    boolean noMerge;
    Integer offset;
    Integer limit;
    String format = "json";
    OutputFormat outputFormat;
    String httpVerb;
    @CommandLine.Option(names={"-h", "--header"}, description={"Set request header NAME to VALUE"})
    List<String> rawHeaders = new LinkedList<String>();
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..*")
    List<AttributeOperations> rawAttributeOperations = new ArrayList<AttributeOperations>();
    @CommandLine.Option(names={"-q", "--query"}, description={"Add to request URI a NAME query parameter with value VALUE, for example --query q=username:admin"})
    List<String> rawFilters = new LinkedList<String>();
    @CommandLine.Parameters(arity="0..1")
    String uri;
    List<AttributeOperation> attrs = new LinkedList<AttributeOperation>();
    Headers headers = new Headers();
    Map<String, String> filter = new HashMap<String, String>();

    @Override
    protected void processOptions() {
        String[] keyVal;
        super.processOptions();
        for (AttributeOperations entry : this.rawAttributeOperations) {
            if (entry.delete != null) {
                this.attrs.add(new AttributeOperation(AttributeOperation.Type.DELETE, entry.delete));
                continue;
            }
            keyVal = ParseUtil.parseKeyVal(entry.set);
            this.attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
        }
        for (String header : this.rawHeaders) {
            keyVal = ParseUtil.parseKeyVal(header);
            this.headers.add(keyVal[0], keyVal[1]);
        }
        for (String arg : this.rawFilters) {
            keyVal = ParseUtil.parseKeyVal(arg);
            this.filter.put(keyVal[0], keyVal[1]);
        }
        if (this.uri == null) {
            throw new IllegalArgumentException("Resource URI not specified");
        }
        if (this.outputResult && this.returnId) {
            throw new IllegalArgumentException("Options -o and -i are mutually exclusive");
        }
        try {
            this.outputFormat = OutputFormat.valueOf(this.format.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported output format: " + this.format);
        }
        if (this.mergeMode && this.noMerge) {
            throw new IllegalArgumentException("Options --merge and --no-merge are mutually exclusive");
        }
        if (this.body != null && this.file != null) {
            throw new IllegalArgumentException("Options --body and --file are mutually exclusive");
        }
        if (this.file == null && this.attrs.size() > 0 && !this.noMerge) {
            this.mergeMode = true;
        }
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.file == null && this.body == null && this.uri == null && this.fields == null && this.rawAttributeOperations.isEmpty() && this.rawFilters.isEmpty() && this.rawHeaders.isEmpty();
    }

    @Override
    protected void process() {
        int lastByte;
        Header location;
        String id;
        HeadersBodyStatus response;
        Header ctype = this.headers.get("content-type");
        InputStream content = null;
        CmdStdinContext<Object> ctx = new CmdStdinContext();
        if (this.file != null) {
            if (ctype != null && !"application/json".equals(ctype.getValue())) {
                if ("-".equals(this.file)) {
                    content = System.in;
                } else {
                    try {
                        content = new BufferedInputStream(new FileInputStream(this.file));
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException("File not found: " + this.file);
                    }
                }
            } else {
                ctx = CmdStdinContext.parseFileOrStdin(this.file);
            }
        } else if (this.body != null) {
            content = new ByteArrayInputStream(this.body.getBytes(StandardCharsets.UTF_8));
        }
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        this.setupTruststore(config);
        Object auth = null;
        config = this.ensureAuthInfo(config);
        config = this.copyWithServerInfo(config);
        if (ConfigUtil.credentialsAvailable(config)) {
            auth = this.ensureToken(config);
        }
        Object object = auth = auth != null ? "Bearer " + (String)auth : null;
        if (auth != null) {
            this.headers.addIfMissing("Authorization", (String)auth);
        }
        String server = config.getServerUrl();
        String realm = this.getTargetRealm(config);
        String adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
        String resourceUrl = HttpUtil.composeResourceUrl(adminRoot, realm, this.uri);
        String typeName = this.extractTypeNameFromUri(resourceUrl);
        if (this.filter.size() > 0) {
            resourceUrl = HttpUtil.addQueryParamsToUri(resourceUrl, this.filter);
        }
        this.headers.addIfMissing("Accept", "application/json");
        if (this.isUpdate() && this.mergeMode) {
            ObjectNode result;
            try {
                HeadersBodyStatus response2 = HttpUtil.doGet(resourceUrl, new HeadersBody(this.headers));
                HttpUtil.checkSuccess(resourceUrl, response2);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IoUtil.copyStream(response2.getBody(), buffer);
                result = OutputUtil.MAPPER.readValue(buffer.toByteArray(), ObjectNode.class);
            }
            catch (IOException e) {
                throw new RuntimeException("HTTP request error: " + e.getMessage(), e);
            }
            CmdStdinContext<ObjectNode> ctxremote = new CmdStdinContext<ObjectNode>();
            ctxremote.setResult(result);
            if (ctx.getResult() != null) {
                ReflectionUtil.merge((JsonNode)ctx.getResult(), (ObjectNode)ctxremote.getResult());
            }
            ctx = ctxremote;
            try {
                ctx.setContent(JsonSerialization.writeValueAsString(ctxremote.getResult()));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not convert merge result to string " + e.getMessage(), e);
            }
        }
        if (this.attrs.size() > 0) {
            if (content != null) {
                throw new RuntimeException("Can't set attributes on content of type other than application/json");
            }
            ctx = CmdStdinContext.mergeAttributes(ctx, OutputUtil.MAPPER.createObjectNode(), this.attrs);
        }
        if (content == null && ctx.getContent() != null) {
            content = new ByteArrayInputStream(ctx.getContent().getBytes(StandardCharsets.UTF_8));
        }
        ReturnFields returnFields = null;
        if (this.fields != null) {
            returnFields = new ReturnFields(this.fields);
        }
        if (content != null) {
            this.headers.addIfMissing("Content-Type", "application/json");
        }
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        if (this.offset != null) {
            queryParams.put("first", String.valueOf(this.offset));
        }
        if (this.limit != null) {
            queryParams.put("max", String.valueOf(this.limit));
        }
        if (queryParams.size() > 0) {
            resourceUrl = HttpUtil.addQueryParamsToUri(resourceUrl, queryParams);
        }
        try {
            response = HttpUtil.doRequest(this.httpVerb, resourceUrl, new HeadersBody(this.headers, content));
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP request error: " + e.getMessage(), e);
        }
        if (this.printHeaders) {
            IoUtil.printOut(response.getStatus());
            for (Header header : response.getHeaders()) {
                IoUtil.printOut(header.getName() + ": " + header.getValue());
            }
        }
        HttpUtil.checkSuccess(resourceUrl, response);
        AccessibleBufferOutputStream abos = new AccessibleBufferOutputStream(System.out);
        if (response.getBody() == null) {
            throw new RuntimeException("Internal error - response body should never be null");
        }
        if (this.printHeaders) {
            IoUtil.printOut("");
        }
        String string = id = (location = response.getHeaders().get("Location")) != null ? this.extractLastComponentOfUri(location.getValue()) : null;
        if (id != null) {
            if (this.returnId) {
                IoUtil.printOut(id);
            } else if (!this.outputResult) {
                IoUtil.printErr("Created new " + typeName + " with id '" + id + "'");
            }
        }
        if (this.outputResult) {
            boolean json;
            if (this.isCreateOrUpdate() && (response.getStatusCode() == 204 || id != null) && this.isGetByID(this.uri)) {
                this.headers = new Headers();
                if (auth != null) {
                    this.headers.add("Authorization", (String)auth);
                }
                try {
                    String fetchUrl = id != null ? resourceUrl + "/" + id : resourceUrl;
                    response = HttpUtil.doGet(fetchUrl, new HeadersBody(this.headers));
                }
                catch (IOException e) {
                    throw new RuntimeException("HTTP request error: " + e.getMessage(), e);
                }
            }
            if ((json = response.getHeaders().getContentType().map(ContentType::getMimeType).filter("application/json"::equals).isPresent()) && !this.compressed) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IoUtil.copyStream(response.getBody(), buffer);
                try {
                    JsonNode rootNode = OutputUtil.MAPPER.readValue(buffer.toByteArray(), JsonNode.class);
                    if (returnFields != null) {
                        rootNode = this.applyFieldFilter(OutputUtil.MAPPER, rootNode, returnFields);
                    }
                    if (this.outputFormat == OutputFormat.JSON) {
                        OutputUtil.MAPPER.writeValue(abos, (Object)rootNode);
                    }
                    OutputUtil.printAsCsv(rootNode, returnFields, this.unquoted);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing results: " + e.getMessage(), e);
                }
            } else {
                if (this.outputFormat != OutputFormat.JSON || returnFields != null) {
                    IoUtil.printErr("Cannot create CSV nor filter returned fields because the response is " + (this.compressed ? "compressed" : "not json"));
                    return;
                }
                IoUtil.copyStream(response.getBody(), abos);
            }
        }
        if ((lastByte = abos.getLastByte()) != -1 && lastByte != 13 && lastByte != 10) {
            IoUtil.printErr("");
        }
    }

    private boolean isUpdate() {
        return "put".equals(this.httpVerb);
    }

    private boolean isCreateOrUpdate() {
        return "post".equals(this.httpVerb) || "put".equals(this.httpVerb);
    }

    private boolean isGetByID(String url) {
        return !"clients-initial-access".equals(url);
    }

    static class AttributeOperations {
        @CommandLine.Option(names={"-s", "--set"}, required=true)
        String set;
        @CommandLine.Option(names={"-d", "--delete"}, required=true)
        String delete;

        AttributeOperations() {
        }
    }
}

