/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.suretrak;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.primavera.common.ColumnDefinition;
import net.sf.mpxj.primavera.common.Table;
import net.sf.mpxj.primavera.common.TableDefinition;

class TableReader {
    private final TableDefinition m_definition;

    public TableReader(TableDefinition tableDefinition) {
        this.m_definition = tableDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, Table table) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.read(fileInputStream, table);
        }
        catch (Throwable throwable) {
            StreamHelper.closeQuietly(fileInputStream);
            throw throwable;
        }
        StreamHelper.closeQuietly(fileInputStream);
    }

    private void read(InputStream inputStream, Table table) throws IOException {
        int n;
        byte[] byArray = new byte[6];
        inputStream.read(byArray);
        byte[] byArray2 = new byte[2];
        inputStream.read(byArray2);
        byte[] byArray3 = new byte[this.m_definition.getRecordSize()];
        while ((n = inputStream.read(byArray3)) != -1) {
            if (n != byArray3.length) {
                throw new IOException("Unexpected end of file");
            }
            if (byArray3[0] != 0) continue;
            this.readRecord(byArray3, table);
        }
    }

    private void readRecord(byte[] byArray, Table table) {
        int n = this.getShort(byArray, 0);
        if (n != 0) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (ColumnDefinition columnDefinition : this.m_definition.getColumns()) {
                Object object = columnDefinition.read(0, byArray);
                hashMap.put(columnDefinition.getName(), object);
            }
            table.addRow(this.m_definition.getPrimaryKeyColumnName(), hashMap);
        }
    }

    private int getShort(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 16; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }
}

